# ROS Packages

RAI includes multiple configurable ROS 2 packages.

| Package            | Description                                                                                                                                                                                                                                | Documentation                                 |
| ------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------- |
| **rai_perception** | Object detection tools based on open-set models and machine learning techniques. Integrates [GroundingDINO](https://github.com/IDEA-Research/GroundingDINO) and [GroundedSAM](https://github.com/IDEA-Research/Grounded-SAM-2) with ROS 2. | [rai_perception](../extensions/perception.md) |
| **rai_nomad**      | Package integrating [NoMaD](https://general-navigation-models.github.io/nomad/index.html) -- an exploration model with ROS2.                                                                                                               | [rai_nomad](../extensions/nomad.md)           |
| **rai_interfaces** | Definition of custom messages and services used in RAI.                                                                                                                                                                                    |                                               |
| **rai_bringup**    | Launch files to run RAI.                                                                                                                                                                                                                   |                                               |
