# RAI Demos Overview

This document provides an overview of the available RAI demos. Each demo showcases different capabilities of the RAI platform in various robotics applications.

| Demo                                               | Description                                            | Key Features                                                                                                    | Environment                          |
| -------------------------------------------------- | ------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------- | ------------------------------------ |
| [Manipulation](manipulation.md)                    | Robot arm manipulation using natural language          | - Object detection and segmentation<br>- Natural language command processing<br>- Robotic manipulation planning | ROS 2, Franka Emika Panda            |
| [ROSbot XL](rosbot_xl.md)                          | Mobile robot operating in an apartment environment     | - Natural language interaction<br>- Navigation and perception<br>- Streamlit GUI interface                      | ROS 2, Open 3D Engine                |
| [Autonomous Tractor](agriculture.md)               | Autonomous agricultural tractor operating in a field   | - Path planning and navigation<br>- Anomaly detection and handling<br>- RAI agent decision making               | ROS 2, Agricultural field simulation |
| [ROS2 Debugging Assistant](debugging_assistant.md) | Interactive chat interface for debugging ROS 2 systems | - Interactive chat interface for debugging ROS 2 systems                                                        | ROS 2                                |

## Common Requirements

All demos require:

-   ROS 2 (Humble or Jazzy)
-   RAI platform setup

Make sure to follow the [installation instructions](../setup/install.md).

For detailed setup and running instructions, please refer to the individual demo documentation linked above.
