# RAI Contributors Code of Conduct

RAI adopts the [ROS Code of Conduct](https://osrf.github.io/code_of_conduct/) maintained by the OSRF.
We expand the scope of the Code of Conduct to all official RAI communication channels, including, but not limited to:

-   RAI source code repositories
-   RAI discord and other communication channels

What follows is the adopted ROS Code of Conduct (retrieved: 2024-08-22). It also includes contact information to RAI internal Conduct Team.

# ROS Code of Conduct

-   [ROS Code of Conduct](https://osrf.github.io/code_of_conduct/)
-   [Python Software Foundation Code of Conduct](https://www.python.org/psf/conduct/)
-   [The RUST language Code of Conduct](https://www.rust-lang.org/policies/code-of-conduct)
-   [Contributor Covenant](https://www.contributor-covenant.org/)
-   [Frame Shift Consulting Code of Conduct Book](https://frameshiftconsulting.com/code-of-conduct-book/)

## Code of Conduct for ROS

[View the Project on GitHub](https://github.com/osrf/code_of_conduct)

## ROS Community Code of Conduct

### Preamble / Attribution

The ROS Code of Conduct draws heavily from the work of other open source software communities and tries to synthesize their efforts to address the specific needs of the ROS community. In particular, we draw heavily from the following prior work:

-   [Python Software Foundation Code of Conduct](https://policies.python.org/python.org/code-of-conduct/)
-   [The RUST Language Code of Conduct](https://www.rust-lang.org/policies/code-of-conduct)
-   [Contributor Covenant](https://www.contributor-covenant.org/)
-   [Frame Shift Consulting Code of Conduct Book](https://frameshiftconsulting.com/resources/code-of-conduct-book/)

It is worth noting that this is a living document to be used to protect community members. It should not be interpreted as a hard and fast legal guide for community behavior. Instead, it should be interpreted as a broad outline of acceptable and unacceptable behavior, how to report unacceptable behavior, and how it will be dealt with.

The ROS Code of Conduct is released under a [Creative Commons Attribution 4.0 International License](https://creativecommons.org/licenses/by/4.0/).

### Scope of the Code of Conduct

This guide applies to all people, events, web properties, communication media, and source code repositories administered by Open Robotics and the ROS 2 Technical Steering Committee. This includes but is not limited to:

-   ROS source code repositories
-   ROS Discourse
-   ROS Wiki
-   ROS Documentation
-   ROS Answers
-   ROSCon
-   ROS.org
-   All ROS 2 TSC working groups
-   All Open Robotics administered e-mail lists
-   Comments made on event video hosting services
-   Comments made on the official event or ROS hashtags

If you administer a ROS affiliated organization outside of the organizations listed above and would like to adopt this code of conduct for your own project, please contact us at [conduct@robotec.ai](mailto:conduct@robotec.ai). We will require the contact information for at least one administrator for your project.

**Outside organizations that have adopted this code of conduct include the following organizations:**

-   None at this time.

## Code of Conduct

The ROS community is made up of members from around the globe with a diverse set of skills, personalities, and experiences. It is through these differences that our community experiences great successes and continued growth. When you’re working with members of the community, this Code of Conduct will help steer your interactions and keep ROS a positive, successful, and growing community.

### Our Community

Members of the ROS community are open, considerate, and respectful. Behaviors that reinforce these values contribute to a positive environment, and include:

-   **Being open.** Members of the community are open to collaboration, whether it’s on REPs, patches, problems, or otherwise.
-   **Focusing on what is best for the community.** We’re respectful of the processes set forth in the community, and we work within them.
-   **Acknowledging time and effort.** We’re respectful of the volunteer efforts that permeate the ROS community. We’re thoughtful when addressing the efforts of others, keeping in mind that oftentimes the labor was completed simply for the good of the community.
-   **Being respectful of differing viewpoints and experiences.** We’re receptive to constructive comments and criticism, as the experiences and skill sets of other members contribute to the whole of our efforts.
-   **Showing empathy towards other community members.** We’re attentive in our communications, whether in person or online, and we’re tactful when approaching differing views.
-   **Being considerate.** Members of the community are considerate of their peers – other ROS users.
-   **Being respectful.** We’re respectful of others, their positions, their skills, their commitments, and their efforts.
-   **Gracefully accepting constructive criticism.** When we disagree, we are courteous in raising our issues.
-   **Using welcoming and inclusive language.** We’re accepting of all who wish to take part in our activities, fostering an environment where anyone can participate and everyone can make a difference.

### Our Standards

Every member of our community has the right to have their identity respected. The ROS community is dedicated to providing a positive experience for everyone, regardless of age, gender identity and expression, sexual orientation, disability, physical appearance, body size, ethnicity, nationality, race, or religion (or lack thereof), education, or socio-economic status.

### Inappropriate Behavior

Examples of unacceptable behavior by participants include:

-   Harassment of any participants in any form.
-   Deliberate intimidation, stalking, or following.
-   Logging or taking screenshots of online activity for harassment purposes.
-   Publishing others’ private information, such as a physical or electronic address, without explicit permission.
-   Violent threats or language directed against another person.
-   Incitement of violence or harassment towards any individual, including encouraging a person to commit suicide or to engage in self-harm.
-   Creating additional online accounts in order to harass another person or circumvent a ban.
-   Sexual language and imagery in online communities or in any conference venue, including talks.
-   Insults, put downs, or jokes that are based upon stereotypes, that are exclusionary, or that hold others up for ridicule.
-   Excessive swearing.
-   Unwelcome sexual attention or advances.
-   Unwelcome physical contact, including simulated physical contact (e.g., textual descriptions like “hug” or “backrub”) without consent or after a request to stop.
-   Pattern of inappropriate social contact, such as requesting/assuming inappropriate levels of intimacy with others.
-   Sustained disruption of online community discussions, in-person presentations, or other in-person events.
-   Continued one-on-one communication after requests to cease.
-   Other conduct that is inappropriate for a professional audience, including people of many different backgrounds.

Community members asked to stop any inappropriate behavior are expected to comply immediately.

### Weapons Policy

No weapons are allowed at ROS physical events. Weapons include but are not limited to explosives (including fireworks), guns, and large knives such as those used for hunting or display, as well as any other item used for the purpose of causing injury or harm to others. Anyone seen in possession of one of these items will be asked to leave immediately and will only be allowed to return without the weapon.

### Enforcement Responsibilities

The Code of Conduct Team is responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.

The Code of Conduct Team has the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.

### Current Code of Conduct Team

The Code of Conduct Team consists of three volunteers from the ROS community. Optimally, these members are located at multiple locations across the globe to provide for a timely response to conduct questions and violations, and provide native language support as best we can. The Conduct Team members serve a two-year term with replacements nominated by the ROS 2 Technical Steering Committee. The Conduct Team works to adjudicate conduct violations using a consensus model. For most situations, that is those that don’t require an immediate response, the Conduct Team will issue reports and enforcement actions representing the consensus of the team.

The current Code of Conduct Team consists of:

-   Wiktoria Siekierska [wiktoria.siekierska@robotec.ai](mailto:wiktoria.siekierska@robotec.ai)
-   Adam Kutyłowski [adam.kutylowski@robotec.ai](mailto:adam.kutylowski@robotec.ai)
-   Maciej Majek [maciej.majek@robotec.ai](mailto:maciej.majek@robotec.ai)

The entire team can be contacted using [conduct@robotec.ai](mailto:conduct@robotec.ai). The team can arrange for other means of communications after the initial contact. We recommend you use the conduct@robotec.ai address unless you wish to report a Conduct Team member, or you feel uncomfortable communicating with a certain team member.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the Conduct Team responsible for enforcement at [conduct@robotec.ai](mailto:conduct@robotec.ai). All complaints will be reviewed and responded to within 48 hours. The Conduct Team is obligated to respect the privacy and security of the reporter of any incident.

### Enforcement Guidelines

The Conduct Team will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:

#### Correction

-   Your contact info (so we can get in touch with you if we need to follow up)
-   Date and time of the incident
-   Any links, screen shots, videos, or other media that may help
-   Location of the incident
-   Whether the incident is ongoing
-   Description of the incident
-   Identifying information of the reported person
-   Additional circumstances surrounding the incident
-   Other people involved in or witnesses to the incident and their contact information or description

-   **Example Behavior:** Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community.
-   **Consequence:** A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.

#### Warning

-   **Example Behavior:** A violation through a single incident or series of actions.
-   **Consequence:** A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.

#### Temporary Ban

-   **Example Behavior:** A serious violation of community standards, including sustained inappropriate behavior.
-   **Consequence:** A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.

#### Permanent Ban

-   **Example Behavior:** Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.
-   **Consequence:** A permanent ban from any sort of public interaction within the community.

## How To Report A Conduct Violation

If you believe someone is in physical danger, including from themselves, the most important thing is to get that person help. Please contact the appropriate crisis number, non-emergency number, or police number as appropriate. If you are at a ROS event, you can consult with a volunteer or staff member to help find an appropriate number.

If you believe someone has violated the ROS Code of Conduct, we encourage you to report it. If you are unsure whether the incident is a violation, or whether the space where it happened is covered by the Code of Conduct, we encourage you to still report it. We are fine with receiving reports where we decide to take no action for the sake of creating a safer space.

The ROS-related forums and events listed above should have a designated moderator or Code of Conduct point of contact. Larger gatherings, like conferences, may have several people to contact. Specific information should be available for each listed gathering, online or off.

### Report Template

When you make a report via email or phone, please provide as much information as possible to help us make a fair and accurate decision about the appropriate response. The following template should serve as a guide for reporting:

-   Your contact info (so we can get in touch with you if we need to follow up)
-   Date and time of the incident
-   Any links, screenshots, videos, or other media that may help
-   Location of the incident
-   Whether the incident is ongoing
-   Description of the incident
-   Identifying information of the reported person
-   Additional circumstances surrounding the incident
-   Other people involved in or witnesses to the incident and their contact information or description

### Confidentiality

All reports will be kept confidential. When we discuss incidents with people who are reported, we will anonymize details as much as we can to protect reporter privacy.

However, some incidents happen in one-on-one interactions, and even if the details are anonymized, the reported person may be able to guess who made the report. If you have concerns about retaliation or your personal safety, please note those in your report. In some cases, we can compile several anonymized reports into a pattern of behavior and take action on that pattern.

In some cases, we may determine that a public statement will need to be made. If that’s the case, the identities of all victims and reporters will remain confidential unless those individuals instruct us otherwise.

### Report Handling Procedure

When you make a report to the Conduct Team, they will gather information about the incident. If the incident is ongoing and needs to be immediately addressed, any Conduct Team member may take appropriate action to ensure the safety of everyone involved. If the situation requires it, this may take the form of a referral to an appropriate agency, including the local police. The Conduct Team is not equipped to handle emergency situations.

If the incident is less urgent, the report will be discussed by the Conduct Team to determine an appropriate response. You should receive a response from the Conduct Team within 48 hours confirming the receipt of the report, and potentially asking for follow-up information. Within one week of an incident report, a member of the Conduct Team will follow up with the person who made the report. The follow-up may include:

-   An acknowledgment that the Code of Conduct responders discussed the situation
-   Whether or not the report was determined to be a violation of the Code of Conduct
-   What actions (if any) were taken to correct the reported behavior

---
