# Welcome to RAI

**RAI** is an open-source framework that makes it easy to add AI-powered features—like natural language control and smart perception to your robots. It's designed to bridge the gap between cutting-edge AI capabilities and practical robotics applications, enabling developers to create more intelligent and accessible robotic systems.

Whether you're building industrial automation solutions, educational robots, or research prototypes, RAI provides the tools and infrastructure needed to bring advanced AI capabilities to your robotics projects. With its modular architecture and flexible integration options, RAI adapts to your needs while maintaining high performance and reliability.

---

## What is RAI?

-   It helps you control robots using natural language and advanced AI, making them more intuitive and accessible to use.
-   Works with popular robotics systems (like ROS 2), but can also be used on its own, giving you flexibility in how you integrate it.
-   Combines vision, speech, and sensor data to create comprehensive robotic understanding and control.

---

## How does RAI work?

<div style="text-align: center;"><img src="../../imgs/rai_steps.png" alt="rai-steps"></div>

RAI connects human instructions to robot actions in four simple steps:

-   Human gives a command: The user interacts with the robot using speech or text.
-   RAI understands and reasons: RAI interprets the request, plans the response, and decides on the best action.
-   RAI controls the robot: It sends commands to the robot through ROS 2 or the robot’s SDK.
-   Robot responds: The robot performs the action and can communicate back to the user, closing the loop.

---

## Who is RAI for?

-   Robotics developers and researchers looking to enhance their systems with AI capabilities
-   Anyone who wants to add AI and natural language to robots with existing robotics stack
-   Teams building real-world robotic applications that require intuitive human-robot interaction
-   Educational institutions teaching robotics, agentic systems and AI integration
-   Startups and companies developing next-generation robotic solutions
-   Hobbyists interested in exploring AI-powered robotics

---

## What can I do with RAI?

-   Control robots with voice or text commands, making them more accessible and intuitive to use
-   Integrate vision, speech, and sensor data for comprehensive environmental understanding
-   Build and test complex robot behaviors through natural language instructions
-   Use ready-made demos or create your own solutions tailored to specific use cases
-   Develop multi-agent systems that can collaborate on complex tasks
-   Create custom tools and behaviors that extend RAI's core functionality
-   Implement real-time decision making based on environmental inputs
-   Design interactive scenarios where robots can understand and respond to human intentions

---

## Quick Start

**Ready to try RAI?**

-   [Quick Setup Guide](../setup/install.md)
-   [Try a Demo](#try-our-demos)
-   [Build Your Own Solution](#build-your-own-solution)

---

## Try Our Demos

See RAI in action:

-   🤖 [Manipulation Tasks](../demos/manipulation.md) - Watch RAI control a Franka Panda arm using natural language
-   🚗 [Autonomous Navigation](../demos/rosbot_xl.md) - Explore RAI's capabilities with the ROSbot XL platform
-   🚜 [Agricultural Robotics](../demos/agriculture.md) - See how RAI handles complex decision-making in orchard environments

---

## Build Your Own Solution

Follow our [step-by-step walkthrough](../tutorials/walkthrough.md) to:

-   Deploy RAI on your robot
-   Add custom tools and features
-   Create advanced, multi-agents systems to tackle complex tasks

---

## How RAI Works

-   Modular: Use only the parts you need
-   Works with ROS 2 (Humble, Jazzy) but is not limited to it
-   Handles communication, perception, and reasoning

---

## Community & Support

-   [Contribution Guide](../faq/contributing/CONTRIBUTING.md)
-   [FAQ](../faq/faq.md)
-   [Join our Discord](https://discord.gg/3PGHgTaJSB)
-   [Embodied AI Community Group](https://github.com/ros-wg-embodied-ai)

---

## Learn More

-   [RAI at ROSCon 2024 (Talk)](https://vimeo.com/1026029511)
-   [RAI Demos at ROSCon 2024](https://vimeo.com/user222230448/rai-roscon24-reel)

---
