#!/usr/bin/env python
#
# MIT License
#
# Copyright The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

"""
Verify use of the AddMethod() global function (specifically, to add
an unbound method to the Environment class) and its counterpart
construction environment method.
"""

import TestSCons

test = TestSCons.TestSCons()

test.write('SConstruct', """
def foo(self):
    return 'foo-' + self['FOO']

AddMethod(Environment, foo)
env = Environment(FOO = '111')
print(env.foo())

env = Environment(FOO = '222')
print(env.foo())

env.AddMethod(foo, 'bar')
env['FOO'] = '333'

e = env.Clone()
e['FOO'] = '444'

print(env.bar())
print(e.bar())
""")

expect = """\
foo-111
foo-222
foo-333
foo-444
"""

test.run(arguments = '-Q -q', stdout = expect)

test.pass_test()
