#!/usr/bin/env python
#
# MIT License
#
# Copyright The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

"""
Test Java inner classes can be cached.  Requires a working JDK.

Regression test: one iteration of CacheDir left it unable to deal
with class names from the emitter which contained an embedded '$'.
Led to error like:

SyntaxError `invalid syntax (<string>, line 1)' trying to evaluate `$Inner.class'
"""

import TestSCons

test = TestSCons.TestSCons()
where_javac, java_version = test.java_where_javac()

# Work around javac 1.4 not reporting its version:
java_version = java_version or "1.4"

# Skip this test as SCons doesn't (currently) predict the generated
# inner/anonymous class generated .class files generated by gcj
# and so will always fail.
if test.javac_is_gcj:
    test.skip_test('Test not valid for gcj (gnu java); skipping test(s).\n')

test.write(
    'SConstruct',
    """
DefaultEnvironment(tools=[])
env = Environment()
env.CacheDir("cache")
env.Java("classes", "source")
""",
)

test.subdir('source')

test.write(
    ['source', 'Test.java'],
    """\
class Test { class Inner {} }
""",
)

test.run(arguments='.')

test.pass_test()
