#!/usr/bin/env python
#
# MIT License
#
# Copyright The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

"""
Test that the $PDFLATEXCOMSTR construction variable allows you to configure
the C compilation output.
"""

import TestSCons

_python_ = TestSCons._python_

test = TestSCons.TestSCons()

test.file_fixture('mycompile.py')

test.write('SConstruct', """
_ = DefaultEnvironment(tools=[])
env = Environment(TOOLS = ['pdflatex'],
                  PDFLATEXCOM = r'%(_python_)s mycompile.py latex $TARGET $SOURCE',
                  PDFLATEXCOMSTR = 'Building $TARGET from $SOURCE')
env.PDF('test1', 'test1.latex')
""" % locals())

test.write('test1.latex', """\
test1.latex
/*latex*/
""")

test.run(stdout = test.wrap_stdout("""\
Building test1.pdf from test1.latex
"""))

test.must_match('test1.pdf', "test1.latex\n")

test.pass_test()
