#!/usr/bin/env python
#
# MIT License
#
# Copyright The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

import sys

import TestSCons
from TestCmd import IS_WINDOWS

_python_ = TestSCons._python_
_exe   = TestSCons._exe

if IS_WINDOWS:
    compiler = 'msvc'
    linker = 'mslink'
else:
    compiler = 'gcc'
    linker = 'gnulink'

test = TestSCons.TestSCons()

test.subdir('in')

test.dir_fixture('YACCFLAGS-fixture')

test.write('SConstruct', """
DefaultEnvironment(tools=[])
env = Environment(
    YACC=r'%(_python_)s myyacc.py',
    YACCFLAGS='-x -I ${TARGET.dir} -I ${SOURCE.dir}',
    tools=['yacc', '%(linker)s', '%(compiler)s'],
)
env.CFile(target='out/aaa', source='in/aaa.y')
""" % locals())

test.write(['in', 'aaa.y'], "aaa.y\nYACCFLAGS\nI_ARGS\n")
test.run('.', stderr=None)
test.must_match(['out', 'aaa.c'], "aaa.y\n-x\nout in\n")

test.pass_test()
