"""Constants used throughout the TOON library."""

# Delimiters
COMMA = ','
TAB = '\t'
PIPE = '|'
DEFAULT_DELIMITER = COMMA

# Special characters
COLON = ':'
QUOTE = '"'
BACKSLASH = '\\'
NEWLINE = '\n'
SPACE = ' '
LEFT_BRACKET = '['
RIGHT_BRACKET = ']'
LEFT_BRACE = '{'
RIGHT_BRACE = '}'

# Literals
TRUE_LITERAL = 'true'
FALSE_LITERAL = 'false'
NULL_LITERAL = 'null'

# Default options
DEFAULT_INDENT = 2
DEFAULT_KEY_FOLDING = 'off'
DEFAULT_EXPAND_PATHS = 'off'
DEFAULT_STRICT = True

# Key folding modes
KEY_FOLDING_OFF = 'off'
KEY_FOLDING_SAFE = 'safe'

# Path expansion modes
EXPAND_PATHS_OFF = 'off'
EXPAND_PATHS_SAFE = 'safe'

# Special delimiter names
DELIMITER_TAB = 'tab'
DELIMITER_PIPE = 'pipe'
DELIMITER_COMMA = 'comma'
