import { WidgetProps } from "@rjsf/utils";
import {
  InputType,
  mapJsonSchemaTypeToInputType,
} from "@/app/(platform)/build/components/FlowEditor/nodes/helpers";
import { Select } from "@/components/atoms/Select/Select";
import {
  MultiSelector,
  MultiSelectorContent,
  MultiSelectorInput,
  MultiSelectorItem,
  MultiSelectorList,
  MultiSelectorTrigger,
} from "@/components/__legacy__/ui/multiselect";

export const SelectWidget = (props: WidgetProps) => {
  const {
    options,
    value,
    onChange,
    disabled,
    readonly,
    className,
    id,
    formContext,
  } = props;
  const enumOptions = options.enumOptions || [];
  const type = mapJsonSchemaTypeToInputType(props.schema);
  const { size = "small" } = formContext || {};

  // Determine select size based on context
  const selectSize = size === "large" ? "medium" : "small";

  const renderInput = () => {
    if (type === InputType.MULTI_SELECT) {
      return (
        <MultiSelector
          values={Array.isArray(value) ? value : []}
          onValuesChange={onChange}
          className="w-full"
        >
          <MultiSelectorTrigger>
            <MultiSelectorInput placeholder="Select options..." />
          </MultiSelectorTrigger>
          <MultiSelectorContent>
            <MultiSelectorList>
              {enumOptions?.map((option: any) => (
                <MultiSelectorItem key={option.value} value={option.value}>
                  {option.label}
                </MultiSelectorItem>
              ))}
            </MultiSelectorList>
          </MultiSelectorContent>
        </MultiSelector>
      );
    }
    return (
      <Select
        label=""
        id={id}
        hideLabel={true}
        disabled={disabled || readonly}
        size={selectSize as any}
        value={value ?? ""}
        onValueChange={onChange}
        options={
          enumOptions?.map((option: any) => ({
            value: option.value,
            label: option.label,
          })) || []
        }
        wrapperClassName="!mb-0 "
        className={className}
      />
    );
  };

  return renderInput();
};
