# AutoGPT Classic

AutoGPT Classic was an experimental project to demonstrate autonomous GPT-4 operation. It was designed to make GPT-4 independently operate and chain together tasks to achieve more complex goals.

## Project Status

⚠️ **This project is unsupported, and dependencies will not be updated. It was an experiment that has concluded its initial research phase. If you want to use AutoGPT, you should use the [AutoGPT Platform](/autogpt_platform)**

For those interested in autonomous AI agents, we recommend exploring more actively maintained alternatives or referring to this codebase for educational purposes only.

## Overview

AutoGPT Classic was one of the first implementations of autonomous AI agents - AI systems that can independently:
- Break down complex goals into smaller tasks
- Execute those tasks using available tools and APIs
- Learn from the results and adjust its approach
- Chain multiple actions together to achieve an objective

## Key Features

- 🔄 Autonomous task chaining
- 🛠 Tool and API integration capabilities
- 💾 Memory management for context retention
- 🔍 Web browsing and information gathering
- 📝 File operations and content creation
- 🔄 Self-prompting and task breakdown

## Structure

The project is organized into several key components:
- `/benchmark` - Performance testing tools
- `/forge` - Core autonomous agent framework
- `/frontend` - User interface components
- `/original_autogpt` - Original implementation

## Getting Started

While this project is no longer actively maintained, you can still explore the codebase:

1. Clone the repository:
```bash
git clone https://github.com/Significant-Gravitas/AutoGPT.git
cd classic
```

2. Review the documentation:
- For reference, see the [documentation](https://docs.agpt.co). You can browse at the same point in time as this commit so the docs don't change.
- Check `CLI-USAGE.md` for command-line interface details
- Refer to `TROUBLESHOOTING.md` for common issues

## License

This project segment is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Documentation

Please refer to the [documentation](https://docs.agpt.co) for more detailed information about the project's architecture and concepts.
You can browse at the same point in time as this commit so the docs don't change.

## Historical Impact

AutoGPT Classic played a significant role in advancing the field of autonomous AI agents:
- Demonstrated practical implementation of AI autonomy
- Inspired numerous derivative projects and research
- Contributed to the development of AI agent architectures
- Helped identify key challenges in AI autonomy

## Security Notice

If you're studying this codebase, please understand this has KNOWN vulnerabilities and issues with its dependencies. It will not be updated to new dependencies.

## Community & Support

While active development has concluded:
- The codebase remains available for study and reference
- Historical discussions can be found in project issues
- Related research and developments continue in the broader AI agent community

## Acknowledgments

Thanks to all contributors who participated in this experimental project and helped advance the field of autonomous AI agents.
