# AutoGPT Documentation

Welcome to the AutoGPT Documentation.

## What is the AutoGPT Platform?

The AutoGPT Platform is a groundbreaking system that revolutionizes AI utilization for businesses and individuals. It enables the creation, deployment, and management of continuous agents that work tirelessly on your behalf, bringing unprecedented efficiency and innovation to your workflows.

### Key Features

- **Seamless Integration and Low-Code Workflows**: Rapidly create complex workflows without extensive coding knowledge.
- **Autonomous Operation and Continuous Agents**: Deploy cloud-based assistants that run indefinitely, activating on relevant triggers.
- **Intelligent Automation and Maximum Efficiency**: Streamline workflows by automating repetitive processes.
- **Reliable Performance and Predictable Execution**: Enjoy consistent and dependable long-running processes.

## Platform Architecture

The AutoGPT Platform consists of two main components:

### 1. AutoGPT Server

The powerhouse of our platform, containing:

-  **Source Code**: Core logic driving agents and automation processes.
-  **Infrastructure**: Robust systems ensuring reliable and scalable performance.
-  **Marketplace**: A comprehensive marketplace for pre-built agents.

### 2. AutoGPT Frontend

The user interface where you interact with the platform:

-  **Agent Builder**: Design and configure your own AI agents.
-  **Workflow Management**: Build, modify, and optimize automation workflows.
-  **Deployment Controls**: Manage the lifecycle of your agents.
-  **Ready-to-Use Agents**: Select from pre-configured agents.
-  **Agent Interaction**: Run and interact with agents through a user-friendly interface.
-  **Monitoring and Analytics**: Track agent performance and gain insights.

##  Platform Components

### Agents and Workflows

In the platform, you can create highly customized workflows to build agents. An agent is essentially an automated workflow that you design to perform specific tasks or processes. Create customized workflows to build agents for various tasks, including:

- Data processing and analysis
- Task scheduling and management
- Communication and notification systems
- Integration between different software tools
- AI-powered decision making and content generation

### Blocks as Integrations

Blocks represent actions and are the building blocks of your workflows, including:

- Connections to external services
- Data processing tools
- AI models for various tasks
- Custom scripts or functions
- Conditional logic and decision-making components

You can learn more under: [Build your own Blocks](platform/new_blocks.md)

## Available Language Models

The platform comes pre-integrated with cutting-edge LLM providers:

- OpenAI - https://openai.com/
- Anthropic - https://www.anthropic.com/
- Groq - https://groq.com/
- Llama - https://llamaindex.ai/
- AI/ML API - [https://aimlapi.com/](https://aimlapi.com/?utm_source=autogpt&utm_medium=github&utm_campaign=integration)
  - AI/ML API provides 300+ AI models including Deepseek, Gemini, ChatGPT. The models run at enterprise-grade rate limits and uptimes.

## License Overview 

We've adopted a dual-license approach to balance open collaboration with sustainable development:

- **MIT License**: The majority of the AutoGPT repository remains under this license.
- **Polyform Shield License**: Applies to the new `autogpt_platform` folder.

This strategy allows us to share previously closed-source components, fostering a vibrant ecosystem of developers and users.

## Ready to Get Started?

- Read the [Getting Started docs](https://docs.agpt.co/platform/getting-started/) to self-host
- [Join the waitlist](https://agpt.co/waitlist) for the cloud-hosted beta
- [Contribute](contribute/index.md)