# **Creating a Basic AI Agent with AutoGPT**

## **Overview**

This guide walks through creating a simple question-answer AI agent using AutoGPT's visual builder. This is a basic example that can be expanded into more complex agents.

## **Example Agent: Q&A (with AI)**

A step-by-step guide to creating a simple Q&A agent using input and output blocks.

<center><iframe width="560" height="315" src="https://www.youtube.com/embed/ih57vRbH0H0?si=PGHx_qquYpXofiu_" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe></center> 

## **Components Required**
1. Input Block
2. AI Text Generator Block
3. Output Block

## **Step-by-Step Instructions**

### **1. Set Up the Basic Structure**
1. Add an Input Block
2. Add an AI Text Generator Block
3. Add an Output Block

### **2. Connect the Components**
1. Connect the Input Block to the AI Text Generator's Prompt
2. Connect the AI Text Generator's response to the Output Block's value

### **3. Configure Block Names**
* Name the Input Block: "question"
* Name the Output Block: "answer"

### **4. Save the Agent**
1. Click the Save button
2. Name your agent (e.g., "question and answer")

### **5. Test the Agent**
1. Click the Run button
2. Enter a question in the input field (e.g., "How far is Earth from Pluto?")
3. View the results through either:
    * The "View More" option
    * The "Agent Outputs" section

## **Viewing Results**

You can access the AI's response in two ways:

* Click "View More" for detailed results
* Check the "Agent Outputs" section for the response

## **Example Agent: Calculator (without AI)**

A step-by-step guide to creating a simple calculator agent using input and output blocks.

<center><iframe width="560" height="315" src="https://www.youtube.com/embed/ESLKHcXxRvA?si=i2L2sloLskSMO8_I" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe></center>

##**Components Required**
* Input Block (2 instances)
* Calculator Block
* Output Block

## **Setup Instructions**

### **1. Adding Input Blocks**
1. Add two input blocks, positioned one below the other
2. Name the first input block "a"
3. Name the second input block "b"

### **2. Adding Calculator Block**
1. Add a calculator block to your workspace
2. Position it after the input blocks

### **3. Adding Output Block**
1. Add an output block
2. Name it "results"

### **4. Connecting the Blocks**
1. Connect the "a" input block to the "a" input on the calculator block
2. Connect the "b" input block to the "b" input on the calculator block
3. Connect the calculator block's result to the value input of the output block

### **5. Saving Your Agent**
1. Name your agent (e.g., "Simple Calculate Agent")
2. Save the configuration

## **Testing Your Calculator**

### **Running Calculations**
1. Enter values in both input blocks
2. Select the desired operation (e.g., multiply)
3. Click the "Run" button to execute the calculation

### **Viewing Results**

There are two ways to view the calculation results:

1. Click "View More" to see the detailed output
2. Check the "Agent Outputs" section, which displays results from the output block

## **Example Calculation**
* Input A: 227
* Input B: 17
* Operation: Multiply
* Expected output will be shown in the results section

## **Tips**
* Always save your agent after making changes
* Verify all connections are properly made before running
* Use the "View More" option for detailed output information

## **Note**
While these are basic example, you can enhance the agent with additional blocks and functionality to create more complex interactions.