
## Audio Filters
  * [Butterworth Filter](audio_filters/butterworth_filter.py)
  * [Iir Filter](audio_filters/iir_filter.py)
  * [Show Response](audio_filters/show_response.py)

## Backtracking
  * [All Combinations](backtracking/all_combinations.py)
  * [All Permutations](backtracking/all_permutations.py)
  * [All Subsequences](backtracking/all_subsequences.py)
  * [Coloring](backtracking/coloring.py)
  * [Combination Sum](backtracking/combination_sum.py)
  * [Crossword Puzzle Solver](backtracking/crossword_puzzle_solver.py)
  * [Generate Parentheses](backtracking/generate_parentheses.py)
  * [Generate Parentheses Iterative](backtracking/generate_parentheses_iterative.py)
  * [Hamiltonian Cycle](backtracking/hamiltonian_cycle.py)
  * [Knight Tour](backtracking/knight_tour.py)
  * [Match Word Pattern](backtracking/match_word_pattern.py)
  * [Minimax](backtracking/minimax.py)
  * [N Queens](backtracking/n_queens.py)
  * [N Queens Math](backtracking/n_queens_math.py)
  * [Power Sum](backtracking/power_sum.py)
  * [Rat In Maze](backtracking/rat_in_maze.py)
  * [Sudoku](backtracking/sudoku.py)
  * [Sum Of Subsets](backtracking/sum_of_subsets.py)
  * [Word Break](backtracking/word_break.py)
  * [Word Ladder](backtracking/word_ladder.py)
  * [Word Search](backtracking/word_search.py)

## Bit Manipulation
  * [Binary And Operator](bit_manipulation/binary_and_operator.py)
  * [Binary Coded Decimal](bit_manipulation/binary_coded_decimal.py)
  * [Binary Count Setbits](bit_manipulation/binary_count_setbits.py)
  * [Binary Count Trailing Zeros](bit_manipulation/binary_count_trailing_zeros.py)
  * [Binary Or Operator](bit_manipulation/binary_or_operator.py)
  * [Binary Shifts](bit_manipulation/binary_shifts.py)
  * [Binary Twos Complement](bit_manipulation/binary_twos_complement.py)
  * [Binary Xor Operator](bit_manipulation/binary_xor_operator.py)
  * [Bitwise Addition Recursive](bit_manipulation/bitwise_addition_recursive.py)
  * [Count 1S Brian Kernighan Method](bit_manipulation/count_1s_brian_kernighan_method.py)
  * [Count Number Of One Bits](bit_manipulation/count_number_of_one_bits.py)
  * [Excess 3 Code](bit_manipulation/excess_3_code.py)
  * [Find Previous Power Of Two](bit_manipulation/find_previous_power_of_two.py)
  * [Find Unique Number](bit_manipulation/find_unique_number.py)
  * [Gray Code Sequence](bit_manipulation/gray_code_sequence.py)
  * [Highest Set Bit](bit_manipulation/highest_set_bit.py)
  * [Index Of Rightmost Set Bit](bit_manipulation/index_of_rightmost_set_bit.py)
  * [Is Even](bit_manipulation/is_even.py)
  * [Is Power Of Two](bit_manipulation/is_power_of_two.py)
  * [Largest Pow Of Two Le Num](bit_manipulation/largest_pow_of_two_le_num.py)
  * [Missing Number](bit_manipulation/missing_number.py)
  * [Numbers Different Signs](bit_manipulation/numbers_different_signs.py)
  * [Power Of 4](bit_manipulation/power_of_4.py)
  * [Reverse Bits](bit_manipulation/reverse_bits.py)
  * [Single Bit Manipulation Operations](bit_manipulation/single_bit_manipulation_operations.py)
  * [Swap All Odd And Even Bits](bit_manipulation/swap_all_odd_and_even_bits.py)

## Blockchain
  * [Diophantine Equation](blockchain/diophantine_equation.py)

## Boolean Algebra
  * [And Gate](boolean_algebra/and_gate.py)
  * [Imply Gate](boolean_algebra/imply_gate.py)
  * [Karnaugh Map Simplification](boolean_algebra/karnaugh_map_simplification.py)
  * [Multiplexer](boolean_algebra/multiplexer.py)
  * [Nand Gate](boolean_algebra/nand_gate.py)
  * [Nimply Gate](boolean_algebra/nimply_gate.py)
  * [Nor Gate](boolean_algebra/nor_gate.py)
  * [Not Gate](boolean_algebra/not_gate.py)
  * [Or Gate](boolean_algebra/or_gate.py)
  * [Quine Mc Cluskey](boolean_algebra/quine_mc_cluskey.py)
  * [Xnor Gate](boolean_algebra/xnor_gate.py)
  * [Xor Gate](boolean_algebra/xor_gate.py)

## Cellular Automata
  * [Conways Game Of Life](cellular_automata/conways_game_of_life.py)
  * [Game Of Life](cellular_automata/game_of_life.py)
  * [Langtons Ant](cellular_automata/langtons_ant.py)
  * [Nagel Schrekenberg](cellular_automata/nagel_schrekenberg.py)
  * [One Dimensional](cellular_automata/one_dimensional.py)
  * [Wa Tor](cellular_automata/wa_tor.py)

## Ciphers
  * [A1Z26](ciphers/a1z26.py)
  * [Affine Cipher](ciphers/affine_cipher.py)
  * [Atbash](ciphers/atbash.py)
  * [Autokey](ciphers/autokey.py)
  * [Baconian Cipher](ciphers/baconian_cipher.py)
  * [Base16](ciphers/base16.py)
  * [Base32](ciphers/base32.py)
  * [Base64 Cipher](ciphers/base64_cipher.py)
  * [Base85](ciphers/base85.py)
  * [Beaufort Cipher](ciphers/beaufort_cipher.py)
  * [Bifid](ciphers/bifid.py)
  * [Brute Force Caesar Cipher](ciphers/brute_force_caesar_cipher.py)
  * [Caesar Cipher](ciphers/caesar_cipher.py)
  * [Cryptomath Module](ciphers/cryptomath_module.py)
  * [Decrypt Caesar With Chi Squared](ciphers/decrypt_caesar_with_chi_squared.py)
  * [Deterministic Miller Rabin](ciphers/deterministic_miller_rabin.py)
  * [Diffie](ciphers/diffie.py)
  * [Diffie Hellman](ciphers/diffie_hellman.py)
  * [Elgamal Key Generator](ciphers/elgamal_key_generator.py)
  * [Enigma Machine2](ciphers/enigma_machine2.py)
  * [Fractionated Morse Cipher](ciphers/fractionated_morse_cipher.py)
  * [Gronsfeld Cipher](ciphers/gronsfeld_cipher.py)
  * [Hill Cipher](ciphers/hill_cipher.py)
  * [Mixed Keyword Cypher](ciphers/mixed_keyword_cypher.py)
  * [Mono Alphabetic Ciphers](ciphers/mono_alphabetic_ciphers.py)
  * [Morse Code](ciphers/morse_code.py)
  * [Onepad Cipher](ciphers/onepad_cipher.py)
  * [Permutation Cipher](ciphers/permutation_cipher.py)
  * [Playfair Cipher](ciphers/playfair_cipher.py)
  * [Polybius](ciphers/polybius.py)
  * [Porta Cipher](ciphers/porta_cipher.py)
  * [Rabin Miller](ciphers/rabin_miller.py)
  * [Rail Fence Cipher](ciphers/rail_fence_cipher.py)
  * [Rot13](ciphers/rot13.py)
  * [Rsa Cipher](ciphers/rsa_cipher.py)
  * [Rsa Factorization](ciphers/rsa_factorization.py)
  * [Rsa Key Generator](ciphers/rsa_key_generator.py)
  * [Running Key Cipher](ciphers/running_key_cipher.py)
  * [Shuffled Shift Cipher](ciphers/shuffled_shift_cipher.py)
  * [Simple Keyword Cypher](ciphers/simple_keyword_cypher.py)
  * [Simple Substitution Cipher](ciphers/simple_substitution_cipher.py)
  * [Transposition Cipher](ciphers/transposition_cipher.py)
  * [Transposition Cipher Encrypt Decrypt File](ciphers/transposition_cipher_encrypt_decrypt_file.py)
  * [Trifid Cipher](ciphers/trifid_cipher.py)
  * [Vernam Cipher](ciphers/vernam_cipher.py)
  * [Vigenere Cipher](ciphers/vigenere_cipher.py)
  * [Xor Cipher](ciphers/xor_cipher.py)

## Computer Vision
  * [Cnn Classification](computer_vision/cnn_classification.py)
  * [Flip Augmentation](computer_vision/flip_augmentation.py)
  * [Haralick Descriptors](computer_vision/haralick_descriptors.py)
  * [Harris Corner](computer_vision/harris_corner.py)
  * [Horn Schunck](computer_vision/horn_schunck.py)
  * [Intensity Based Segmentation](computer_vision/intensity_based_segmentation.py)
  * [Mean Threshold](computer_vision/mean_threshold.py)
  * [Mosaic Augmentation](computer_vision/mosaic_augmentation.py)
  * [Pooling Functions](computer_vision/pooling_functions.py)

## Conversions
  * [Astronomical Length Scale Conversion](conversions/astronomical_length_scale_conversion.py)
  * [Binary To Decimal](conversions/binary_to_decimal.py)
  * [Binary To Hexadecimal](conversions/binary_to_hexadecimal.py)
  * [Binary To Octal](conversions/binary_to_octal.py)
  * [Convert Number To Words](conversions/convert_number_to_words.py)
  * [Decimal To Any](conversions/decimal_to_any.py)
  * [Decimal To Binary](conversions/decimal_to_binary.py)
  * [Decimal To Hexadecimal](conversions/decimal_to_hexadecimal.py)
  * [Decimal To Octal](conversions/decimal_to_octal.py)
  * [Energy Conversions](conversions/energy_conversions.py)
  * [Excel Title To Column](conversions/excel_title_to_column.py)
  * [Hex To Bin](conversions/hex_to_bin.py)
  * [Hexadecimal To Decimal](conversions/hexadecimal_to_decimal.py)
  * [Ipv4 Conversion](conversions/ipv4_conversion.py)
  * [Length Conversion](conversions/length_conversion.py)
  * [Molecular Chemistry](conversions/molecular_chemistry.py)
  * [Octal To Binary](conversions/octal_to_binary.py)
  * [Octal To Decimal](conversions/octal_to_decimal.py)
  * [Octal To Hexadecimal](conversions/octal_to_hexadecimal.py)
  * [Prefix Conversions](conversions/prefix_conversions.py)
  * [Prefix Conversions String](conversions/prefix_conversions_string.py)
  * [Pressure Conversions](conversions/pressure_conversions.py)
  * [Rectangular To Polar](conversions/rectangular_to_polar.py)
  * [Rgb Cmyk Conversion](conversions/rgb_cmyk_conversion.py)
  * [Rgb Hsv Conversion](conversions/rgb_hsv_conversion.py)
  * [Roman Numerals](conversions/roman_numerals.py)
  * [Speed Conversions](conversions/speed_conversions.py)
  * [Temperature Conversions](conversions/temperature_conversions.py)
  * [Time Conversions](conversions/time_conversions.py)
  * [Volume Conversions](conversions/volume_conversions.py)
  * [Weight Conversion](conversions/weight_conversion.py)

## Data Compression
  * [Burrows Wheeler](data_compression/burrows_wheeler.py)
  * [Coordinate Compression](data_compression/coordinate_compression.py)
  * [Huffman](data_compression/huffman.py)
  * [Lempel Ziv](data_compression/lempel_ziv.py)
  * [Lempel Ziv Decompress](data_compression/lempel_ziv_decompress.py)
  * [Lz77](data_compression/lz77.py)
  * [Peak Signal To Noise Ratio](data_compression/peak_signal_to_noise_ratio.py)
  * [Run Length Encoding](data_compression/run_length_encoding.py)

## Data Structures
  * Arrays
    * [Equilibrium Index In Array](data_structures/arrays/equilibrium_index_in_array.py)
    * [Find Triplets With 0 Sum](data_structures/arrays/find_triplets_with_0_sum.py)
    * [Index 2D Array In 1D](data_structures/arrays/index_2d_array_in_1d.py)
    * [Kth Largest Element](data_structures/arrays/kth_largest_element.py)
    * [Median Two Array](data_structures/arrays/median_two_array.py)
    * [Monotonic Array](data_structures/arrays/monotonic_array.py)
    * [Pairs With Given Sum](data_structures/arrays/pairs_with_given_sum.py)
    * [Permutations](data_structures/arrays/permutations.py)
    * [Prefix Sum](data_structures/arrays/prefix_sum.py)
    * [Product Sum](data_structures/arrays/product_sum.py)
    * [Rotate Array](data_structures/arrays/rotate_array.py)
    * [Sparse Table](data_structures/arrays/sparse_table.py)
    * [Sudoku Solver](data_structures/arrays/sudoku_solver.py)
  * Binary Tree
    * [Avl Tree](data_structures/binary_tree/avl_tree.py)
    * [Basic Binary Tree](data_structures/binary_tree/basic_binary_tree.py)
    * [Binary Search Tree](data_structures/binary_tree/binary_search_tree.py)
    * [Binary Search Tree Recursive](data_structures/binary_tree/binary_search_tree_recursive.py)
    * [Binary Tree Mirror](data_structures/binary_tree/binary_tree_mirror.py)
    * [Binary Tree Node Sum](data_structures/binary_tree/binary_tree_node_sum.py)
    * [Binary Tree Path Sum](data_structures/binary_tree/binary_tree_path_sum.py)
    * [Binary Tree Traversals](data_structures/binary_tree/binary_tree_traversals.py)
    * [Diameter Of Binary Tree](data_structures/binary_tree/diameter_of_binary_tree.py)
    * [Diff Views Of Binary Tree](data_structures/binary_tree/diff_views_of_binary_tree.py)
    * [Distribute Coins](data_structures/binary_tree/distribute_coins.py)
    * [Fenwick Tree](data_structures/binary_tree/fenwick_tree.py)
    * [Flatten Binarytree To Linkedlist](data_structures/binary_tree/flatten_binarytree_to_linkedlist.py)
    * [Floor And Ceiling](data_structures/binary_tree/floor_and_ceiling.py)
    * [Inorder Tree Traversal 2022](data_structures/binary_tree/inorder_tree_traversal_2022.py)
    * [Is Sorted](data_structures/binary_tree/is_sorted.py)
    * [Is Sum Tree](data_structures/binary_tree/is_sum_tree.py)
    * [Lazy Segment Tree](data_structures/binary_tree/lazy_segment_tree.py)
    * [Lowest Common Ancestor](data_structures/binary_tree/lowest_common_ancestor.py)
    * [Maximum Fenwick Tree](data_structures/binary_tree/maximum_fenwick_tree.py)
    * [Maximum Sum Bst](data_structures/binary_tree/maximum_sum_bst.py)
    * [Merge Two Binary Trees](data_structures/binary_tree/merge_two_binary_trees.py)
    * [Mirror Binary Tree](data_structures/binary_tree/mirror_binary_tree.py)
    * [Non Recursive Segment Tree](data_structures/binary_tree/non_recursive_segment_tree.py)
    * [Number Of Possible Binary Trees](data_structures/binary_tree/number_of_possible_binary_trees.py)
    * [Red Black Tree](data_structures/binary_tree/red_black_tree.py)
    * [Segment Tree](data_structures/binary_tree/segment_tree.py)
    * [Segment Tree Other](data_structures/binary_tree/segment_tree_other.py)
    * [Serialize Deserialize Binary Tree](data_structures/binary_tree/serialize_deserialize_binary_tree.py)
    * [Symmetric Tree](data_structures/binary_tree/symmetric_tree.py)
    * [Treap](data_structures/binary_tree/treap.py)
    * [Wavelet Tree](data_structures/binary_tree/wavelet_tree.py)
  * Disjoint Set
    * [Alternate Disjoint Set](data_structures/disjoint_set/alternate_disjoint_set.py)
    * [Disjoint Set](data_structures/disjoint_set/disjoint_set.py)
  * Hashing
    * [Bloom Filter](data_structures/hashing/bloom_filter.py)
    * [Double Hash](data_structures/hashing/double_hash.py)
    * [Hash Map](data_structures/hashing/hash_map.py)
    * [Hash Table](data_structures/hashing/hash_table.py)
    * [Hash Table With Linked List](data_structures/hashing/hash_table_with_linked_list.py)
    * Number Theory
      * [Prime Numbers](data_structures/hashing/number_theory/prime_numbers.py)
    * [Quadratic Probing](data_structures/hashing/quadratic_probing.py)
    * Tests
      * [Test Hash Map](data_structures/hashing/tests/test_hash_map.py)
  * Heap
    * [Binomial Heap](data_structures/heap/binomial_heap.py)
    * [Heap](data_structures/heap/heap.py)
    * [Heap Generic](data_structures/heap/heap_generic.py)
    * [Max Heap](data_structures/heap/max_heap.py)
    * [Min Heap](data_structures/heap/min_heap.py)
    * [Randomized Heap](data_structures/heap/randomized_heap.py)
    * [Skew Heap](data_structures/heap/skew_heap.py)
  * Kd Tree
    * [Build Kdtree](data_structures/kd_tree/build_kdtree.py)
    * Example
      * [Example Usage](data_structures/kd_tree/example/example_usage.py)
      * [Hypercube Points](data_structures/kd_tree/example/hypercube_points.py)
    * [Kd Node](data_structures/kd_tree/kd_node.py)
    * [Nearest Neighbour Search](data_structures/kd_tree/nearest_neighbour_search.py)
    * Tests
      * [Test Kdtree](data_structures/kd_tree/tests/test_kdtree.py)
  * Linked List
    * [Circular Linked List](data_structures/linked_list/circular_linked_list.py)
    * [Deque Doubly](data_structures/linked_list/deque_doubly.py)
    * [Doubly Linked List](data_structures/linked_list/doubly_linked_list.py)
    * [Doubly Linked List Two](data_structures/linked_list/doubly_linked_list_two.py)
    * [Floyds Cycle Detection](data_structures/linked_list/floyds_cycle_detection.py)
    * [From Sequence](data_structures/linked_list/from_sequence.py)
    * [Has Loop](data_structures/linked_list/has_loop.py)
    * [Is Palindrome](data_structures/linked_list/is_palindrome.py)
    * [Merge Two Lists](data_structures/linked_list/merge_two_lists.py)
    * [Middle Element Of Linked List](data_structures/linked_list/middle_element_of_linked_list.py)
    * [Print Reverse](data_structures/linked_list/print_reverse.py)
    * [Reverse K Group](data_structures/linked_list/reverse_k_group.py)
    * [Rotate To The Right](data_structures/linked_list/rotate_to_the_right.py)
    * [Singly Linked List](data_structures/linked_list/singly_linked_list.py)
    * [Skip List](data_structures/linked_list/skip_list.py)
    * [Swap Nodes](data_structures/linked_list/swap_nodes.py)
  * Queues
    * [Circular Queue](data_structures/queues/circular_queue.py)
    * [Circular Queue Linked List](data_structures/queues/circular_queue_linked_list.py)
    * [Double Ended Queue](data_structures/queues/double_ended_queue.py)
    * [Linked Queue](data_structures/queues/linked_queue.py)
    * [Priority Queue Using List](data_structures/queues/priority_queue_using_list.py)
    * [Queue By List](data_structures/queues/queue_by_list.py)
    * [Queue By Two Stacks](data_structures/queues/queue_by_two_stacks.py)
    * [Queue On Pseudo Stack](data_structures/queues/queue_on_pseudo_stack.py)
  * Stacks
    * [Balanced Parentheses](data_structures/stacks/balanced_parentheses.py)
    * [Dijkstras Two Stack Algorithm](data_structures/stacks/dijkstras_two_stack_algorithm.py)
    * [Infix To Postfix Conversion](data_structures/stacks/infix_to_postfix_conversion.py)
    * [Infix To Prefix Conversion](data_structures/stacks/infix_to_prefix_conversion.py)
    * [Largest Rectangle Histogram](data_structures/stacks/largest_rectangle_histogram.py)
    * [Lexicographical Numbers](data_structures/stacks/lexicographical_numbers.py)
    * [Next Greater Element](data_structures/stacks/next_greater_element.py)
    * [Postfix Evaluation](data_structures/stacks/postfix_evaluation.py)
    * [Prefix Evaluation](data_structures/stacks/prefix_evaluation.py)
    * [Stack](data_structures/stacks/stack.py)
    * [Stack Using Two Queues](data_structures/stacks/stack_using_two_queues.py)
    * [Stack With Doubly Linked List](data_structures/stacks/stack_with_doubly_linked_list.py)
    * [Stack With Singly Linked List](data_structures/stacks/stack_with_singly_linked_list.py)
    * [Stock Span Problem](data_structures/stacks/stock_span_problem.py)
  * Suffix Tree
    * Example
      * [Example Usage](data_structures/suffix_tree/example/example_usage.py)
    * [Suffix Tree](data_structures/suffix_tree/suffix_tree.py)
    * [Suffix Tree Node](data_structures/suffix_tree/suffix_tree_node.py)
    * Tests
      * [Test Suffix Tree](data_structures/suffix_tree/tests/test_suffix_tree.py)
  * Trie
    * [Radix Tree](data_structures/trie/radix_tree.py)
    * [Trie](data_structures/trie/trie.py)

## Digital Image Processing
  * [Change Brightness](digital_image_processing/change_brightness.py)
  * [Change Contrast](digital_image_processing/change_contrast.py)
  * [Convert To Negative](digital_image_processing/convert_to_negative.py)
  * Dithering
    * [Burkes](digital_image_processing/dithering/burkes.py)
  * Edge Detection
    * [Canny](digital_image_processing/edge_detection/canny.py)
  * Filters
    * [Bilateral Filter](digital_image_processing/filters/bilateral_filter.py)
    * [Convolve](digital_image_processing/filters/convolve.py)
    * [Gabor Filter](digital_image_processing/filters/gabor_filter.py)
    * [Gaussian Filter](digital_image_processing/filters/gaussian_filter.py)
    * [Laplacian Filter](digital_image_processing/filters/laplacian_filter.py)
    * [Local Binary Pattern](digital_image_processing/filters/local_binary_pattern.py)
    * [Median Filter](digital_image_processing/filters/median_filter.py)
    * [Sobel Filter](digital_image_processing/filters/sobel_filter.py)
  * Histogram Equalization
    * [Histogram Stretch](digital_image_processing/histogram_equalization/histogram_stretch.py)
  * [Index Calculation](digital_image_processing/index_calculation.py)
  * Morphological Operations
    * [Dilation Operation](digital_image_processing/morphological_operations/dilation_operation.py)
    * [Erosion Operation](digital_image_processing/morphological_operations/erosion_operation.py)
  * Resize
    * [Resize](digital_image_processing/resize/resize.py)
  * Rotation
    * [Rotation](digital_image_processing/rotation/rotation.py)
  * [Sepia](digital_image_processing/sepia.py)
  * [Test Digital Image Processing](digital_image_processing/test_digital_image_processing.py)

## Divide And Conquer
  * [Closest Pair Of Points](divide_and_conquer/closest_pair_of_points.py)
  * [Convex Hull](divide_and_conquer/convex_hull.py)
  * [Heaps Algorithm](divide_and_conquer/heaps_algorithm.py)
  * [Heaps Algorithm Iterative](divide_and_conquer/heaps_algorithm_iterative.py)
  * [Inversions](divide_and_conquer/inversions.py)
  * [Kth Order Statistic](divide_and_conquer/kth_order_statistic.py)
  * [Max Difference Pair](divide_and_conquer/max_difference_pair.py)
  * [Max Subarray](divide_and_conquer/max_subarray.py)
  * [Mergesort](divide_and_conquer/mergesort.py)
  * [Peak](divide_and_conquer/peak.py)
  * [Power](divide_and_conquer/power.py)
  * [Strassen Matrix Multiplication](divide_and_conquer/strassen_matrix_multiplication.py)

## Docs
  * [Conf](docs/conf.py)

## Dynamic Programming
  * [Abbreviation](dynamic_programming/abbreviation.py)
  * [All Construct](dynamic_programming/all_construct.py)
  * [Bitmask](dynamic_programming/bitmask.py)
  * [Catalan Numbers](dynamic_programming/catalan_numbers.py)
  * [Climbing Stairs](dynamic_programming/climbing_stairs.py)
  * [Combination Sum Iv](dynamic_programming/combination_sum_iv.py)
  * [Edit Distance](dynamic_programming/edit_distance.py)
  * [Factorial](dynamic_programming/factorial.py)
  * [Fast Fibonacci](dynamic_programming/fast_fibonacci.py)
  * [Fibonacci](dynamic_programming/fibonacci.py)
  * [Fizz Buzz](dynamic_programming/fizz_buzz.py)
  * [Floyd Warshall](dynamic_programming/floyd_warshall.py)
  * [Integer Partition](dynamic_programming/integer_partition.py)
  * [Iterating Through Submasks](dynamic_programming/iterating_through_submasks.py)
  * [K Means Clustering Tensorflow](dynamic_programming/k_means_clustering_tensorflow.py)
  * [Knapsack](dynamic_programming/knapsack.py)
  * [Largest Divisible Subset](dynamic_programming/largest_divisible_subset.py)
  * [Longest Common Subsequence](dynamic_programming/longest_common_subsequence.py)
  * [Longest Common Substring](dynamic_programming/longest_common_substring.py)
  * [Longest Increasing Subsequence](dynamic_programming/longest_increasing_subsequence.py)
  * [Longest Increasing Subsequence Iterative](dynamic_programming/longest_increasing_subsequence_iterative.py)
  * [Longest Increasing Subsequence O Nlogn](dynamic_programming/longest_increasing_subsequence_o_nlogn.py)
  * [Longest Palindromic Subsequence](dynamic_programming/longest_palindromic_subsequence.py)
  * [Matrix Chain Multiplication](dynamic_programming/matrix_chain_multiplication.py)
  * [Matrix Chain Order](dynamic_programming/matrix_chain_order.py)
  * [Max Non Adjacent Sum](dynamic_programming/max_non_adjacent_sum.py)
  * [Max Product Subarray](dynamic_programming/max_product_subarray.py)
  * [Max Subarray Sum](dynamic_programming/max_subarray_sum.py)
  * [Min Distance Up Bottom](dynamic_programming/min_distance_up_bottom.py)
  * [Minimum Coin Change](dynamic_programming/minimum_coin_change.py)
  * [Minimum Cost Path](dynamic_programming/minimum_cost_path.py)
  * [Minimum Partition](dynamic_programming/minimum_partition.py)
  * [Minimum Size Subarray Sum](dynamic_programming/minimum_size_subarray_sum.py)
  * [Minimum Squares To Represent A Number](dynamic_programming/minimum_squares_to_represent_a_number.py)
  * [Minimum Steps To One](dynamic_programming/minimum_steps_to_one.py)
  * [Minimum Tickets Cost](dynamic_programming/minimum_tickets_cost.py)
  * [Narcissistic Number](dynamic_programming/narcissistic_number.py)
  * [Optimal Binary Search Tree](dynamic_programming/optimal_binary_search_tree.py)
  * [Palindrome Partitioning](dynamic_programming/palindrome_partitioning.py)
  * [Range Sum Query](dynamic_programming/range_sum_query.py)
  * [Regex Match](dynamic_programming/regex_match.py)
  * [Rod Cutting](dynamic_programming/rod_cutting.py)
  * [Smith Waterman](dynamic_programming/smith_waterman.py)
  * [Subset Generation](dynamic_programming/subset_generation.py)
  * [Sum Of Subset](dynamic_programming/sum_of_subset.py)
  * [Trapped Water](dynamic_programming/trapped_water.py)
  * [Tribonacci](dynamic_programming/tribonacci.py)
  * [Viterbi](dynamic_programming/viterbi.py)
  * [Wildcard Matching](dynamic_programming/wildcard_matching.py)
  * [Word Break](dynamic_programming/word_break.py)

## Electronics
  * [Apparent Power](electronics/apparent_power.py)
  * [Builtin Voltage](electronics/builtin_voltage.py)
  * [Capacitor Equivalence](electronics/capacitor_equivalence.py)
  * [Carrier Concentration](electronics/carrier_concentration.py)
  * [Charging Capacitor](electronics/charging_capacitor.py)
  * [Charging Inductor](electronics/charging_inductor.py)
  * [Circular Convolution](electronics/circular_convolution.py)
  * [Coulombs Law](electronics/coulombs_law.py)
  * [Electric Conductivity](electronics/electric_conductivity.py)
  * [Electric Power](electronics/electric_power.py)
  * [Electrical Impedance](electronics/electrical_impedance.py)
  * [Ic 555 Timer](electronics/ic_555_timer.py)
  * [Ind Reactance](electronics/ind_reactance.py)
  * [Ohms Law](electronics/ohms_law.py)
  * [Real And Reactive Power](electronics/real_and_reactive_power.py)
  * [Resistor Color Code](electronics/resistor_color_code.py)
  * [Resistor Equivalence](electronics/resistor_equivalence.py)
  * [Resonant Frequency](electronics/resonant_frequency.py)
  * [Wheatstone Bridge](electronics/wheatstone_bridge.py)

## File Transfer
  * [Receive File](file_transfer/receive_file.py)
  * [Send File](file_transfer/send_file.py)
  * Tests
    * [Test Send File](file_transfer/tests/test_send_file.py)

## Financial
  * [Equated Monthly Installments](financial/equated_monthly_installments.py)
  * [Exponential Moving Average](financial/exponential_moving_average.py)
  * [Interest](financial/interest.py)
  * [Present Value](financial/present_value.py)
  * [Price Plus Tax](financial/price_plus_tax.py)
  * [Simple Moving Average](financial/simple_moving_average.py)
  * [Straight Line Depreciation](financial/straight_line_depreciation.py)
  * [Time And Half Pay](financial/time_and_half_pay.py)

## Fractals
  * [Julia Sets](fractals/julia_sets.py)
  * [Koch Snowflake](fractals/koch_snowflake.py)
  * [Mandelbrot](fractals/mandelbrot.py)
  * [Sierpinski Triangle](fractals/sierpinski_triangle.py)
  * [Vicsek](fractals/vicsek.py)

## Fuzzy Logic
  * [Fuzzy Operations](fuzzy_logic/fuzzy_operations.py)

## Genetic Algorithm
  * [Basic String](genetic_algorithm/basic_string.py)

## Geodesy
  * [Haversine Distance](geodesy/haversine_distance.py)
  * [Lamberts Ellipsoidal Distance](geodesy/lamberts_ellipsoidal_distance.py)

## Geometry
  * [Geometry](geometry/geometry.py)

## Graphics
  * [Bezier Curve](graphics/bezier_curve.py)
  * [Butterfly Pattern](graphics/butterfly_pattern.py)
  * [Digital Differential Analyzer Line](graphics/digital_differential_analyzer_line.py)
  * [Vector3 For 2D Rendering](graphics/vector3_for_2d_rendering.py)

## Graphs
  * [A Star](graphs/a_star.py)
  * [Ant Colony Optimization Algorithms](graphs/ant_colony_optimization_algorithms.py)
  * [Articulation Points](graphs/articulation_points.py)
  * [Basic Graphs](graphs/basic_graphs.py)
  * [Bellman Ford](graphs/bellman_ford.py)
  * [Bi Directional Dijkstra](graphs/bi_directional_dijkstra.py)
  * [Bidirectional A Star](graphs/bidirectional_a_star.py)
  * [Bidirectional Breadth First Search](graphs/bidirectional_breadth_first_search.py)
  * [Bidirectional Search](graphs/bidirectional_search.py)
  * [Boruvka](graphs/boruvka.py)
  * [Breadth First Search](graphs/breadth_first_search.py)
  * [Breadth First Search 2](graphs/breadth_first_search_2.py)
  * [Breadth First Search Shortest Path](graphs/breadth_first_search_shortest_path.py)
  * [Breadth First Search Shortest Path 2](graphs/breadth_first_search_shortest_path_2.py)
  * [Breadth First Search Zero One Shortest Path](graphs/breadth_first_search_zero_one_shortest_path.py)
  * [Check Bipatrite](graphs/check_bipatrite.py)
  * [Check Cycle](graphs/check_cycle.py)
  * [Connected Components](graphs/connected_components.py)
  * [Deep Clone Graph](graphs/deep_clone_graph.py)
  * [Depth First Search](graphs/depth_first_search.py)
  * [Depth First Search 2](graphs/depth_first_search_2.py)
  * [Dijkstra](graphs/dijkstra.py)
  * [Dijkstra 2](graphs/dijkstra_2.py)
  * [Dijkstra Algorithm](graphs/dijkstra_algorithm.py)
  * [Dijkstra Alternate](graphs/dijkstra_alternate.py)
  * [Dijkstra Binary Grid](graphs/dijkstra_binary_grid.py)
  * [Dinic](graphs/dinic.py)
  * [Directed And Undirected Weighted Graph](graphs/directed_and_undirected_weighted_graph.py)
  * [Edmonds Karp Multiple Source And Sink](graphs/edmonds_karp_multiple_source_and_sink.py)
  * [Eulerian Path And Circuit For Undirected Graph](graphs/eulerian_path_and_circuit_for_undirected_graph.py)
  * [Even Tree](graphs/even_tree.py)
  * [Finding Bridges](graphs/finding_bridges.py)
  * [Frequent Pattern Graph Miner](graphs/frequent_pattern_graph_miner.py)
  * [G Topological Sort](graphs/g_topological_sort.py)
  * [Gale Shapley Bigraph](graphs/gale_shapley_bigraph.py)
  * [Graph Adjacency List](graphs/graph_adjacency_list.py)
  * [Graph Adjacency Matrix](graphs/graph_adjacency_matrix.py)
  * [Graph List](graphs/graph_list.py)
  * [Graphs Floyd Warshall](graphs/graphs_floyd_warshall.py)
  * [Greedy Best First](graphs/greedy_best_first.py)
  * [Greedy Min Vertex Cover](graphs/greedy_min_vertex_cover.py)
  * [Kahns Algorithm Long](graphs/kahns_algorithm_long.py)
  * [Kahns Algorithm Topo](graphs/kahns_algorithm_topo.py)
  * [Karger](graphs/karger.py)
  * [Lanczos Eigenvectors](graphs/lanczos_eigenvectors.py)
  * [Markov Chain](graphs/markov_chain.py)
  * [Matching Min Vertex Cover](graphs/matching_min_vertex_cover.py)
  * [Minimum Path Sum](graphs/minimum_path_sum.py)
  * [Minimum Spanning Tree Boruvka](graphs/minimum_spanning_tree_boruvka.py)
  * [Minimum Spanning Tree Kruskal](graphs/minimum_spanning_tree_kruskal.py)
  * [Minimum Spanning Tree Kruskal2](graphs/minimum_spanning_tree_kruskal2.py)
  * [Minimum Spanning Tree Prims](graphs/minimum_spanning_tree_prims.py)
  * [Minimum Spanning Tree Prims2](graphs/minimum_spanning_tree_prims2.py)
  * [Multi Heuristic Astar](graphs/multi_heuristic_astar.py)
  * [Page Rank](graphs/page_rank.py)
  * [Prim](graphs/prim.py)
  * [Random Graph Generator](graphs/random_graph_generator.py)
  * [Scc Kosaraju](graphs/scc_kosaraju.py)
  * [Strongly Connected Components](graphs/strongly_connected_components.py)
  * [Tarjans Scc](graphs/tarjans_scc.py)
  * Tests
    * [Test Min Spanning Tree Kruskal](graphs/tests/test_min_spanning_tree_kruskal.py)
    * [Test Min Spanning Tree Prim](graphs/tests/test_min_spanning_tree_prim.py)

## Greedy Methods
  * [Best Time To Buy And Sell Stock](greedy_methods/best_time_to_buy_and_sell_stock.py)
  * [Fractional Cover Problem](greedy_methods/fractional_cover_problem.py)
  * [Fractional Knapsack](greedy_methods/fractional_knapsack.py)
  * [Fractional Knapsack 2](greedy_methods/fractional_knapsack_2.py)
  * [Gas Station](greedy_methods/gas_station.py)
  * [Minimum Coin Change](greedy_methods/minimum_coin_change.py)
  * [Minimum Waiting Time](greedy_methods/minimum_waiting_time.py)
  * [Optimal Merge Pattern](greedy_methods/optimal_merge_pattern.py)
  * [Smallest Range](greedy_methods/smallest_range.py)

## Hashes
  * [Adler32](hashes/adler32.py)
  * [Chaos Machine](hashes/chaos_machine.py)
  * [Djb2](hashes/djb2.py)
  * [Elf](hashes/elf.py)
  * [Enigma Machine](hashes/enigma_machine.py)
  * [Fletcher16](hashes/fletcher16.py)
  * [Hamming Code](hashes/hamming_code.py)
  * [Luhn](hashes/luhn.py)
  * [Md5](hashes/md5.py)
  * [Sdbm](hashes/sdbm.py)
  * [Sha1](hashes/sha1.py)
  * [Sha256](hashes/sha256.py)

## Knapsack
  * [Greedy Knapsack](knapsack/greedy_knapsack.py)
  * [Knapsack](knapsack/knapsack.py)
  * [Recursive Approach Knapsack](knapsack/recursive_approach_knapsack.py)
  * Tests
    * [Test Greedy Knapsack](knapsack/tests/test_greedy_knapsack.py)
    * [Test Knapsack](knapsack/tests/test_knapsack.py)

## Linear Algebra
  * [Gaussian Elimination](linear_algebra/gaussian_elimination.py)
  * [Jacobi Iteration Method](linear_algebra/jacobi_iteration_method.py)
  * [Lu Decomposition](linear_algebra/lu_decomposition.py)
  * [Matrix Inversion](linear_algebra/matrix_inversion.py)
  * Src
    * [Conjugate Gradient](linear_algebra/src/conjugate_gradient.py)
    * [Gaussian Elimination Pivoting](linear_algebra/src/gaussian_elimination_pivoting.py)
    * [Lib](linear_algebra/src/lib.py)
    * [Polynom For Points](linear_algebra/src/polynom_for_points.py)
    * [Power Iteration](linear_algebra/src/power_iteration.py)
    * [Rank Of Matrix](linear_algebra/src/rank_of_matrix.py)
    * [Rayleigh Quotient](linear_algebra/src/rayleigh_quotient.py)
    * [Schur Complement](linear_algebra/src/schur_complement.py)
    * [Test Linear Algebra](linear_algebra/src/test_linear_algebra.py)
    * [Transformations 2D](linear_algebra/src/transformations_2d.py)

## Linear Programming
  * [Simplex](linear_programming/simplex.py)

## Machine Learning
  * [Apriori Algorithm](machine_learning/apriori_algorithm.py)
  * [Astar](machine_learning/astar.py)
  * [Automatic Differentiation](machine_learning/automatic_differentiation.py)
  * [Data Transformations](machine_learning/data_transformations.py)
  * [Decision Tree](machine_learning/decision_tree.py)
  * [Dimensionality Reduction](machine_learning/dimensionality_reduction.py)
  * Forecasting
    * [Run](machine_learning/forecasting/run.py)
  * [Frequent Pattern Growth](machine_learning/frequent_pattern_growth.py)
  * [Gradient Boosting Classifier](machine_learning/gradient_boosting_classifier.py)
  * [Gradient Descent](machine_learning/gradient_descent.py)
  * [K Means Clust](machine_learning/k_means_clust.py)
  * [K Nearest Neighbours](machine_learning/k_nearest_neighbours.py)
  * [Linear Discriminant Analysis](machine_learning/linear_discriminant_analysis.py)
  * [Linear Regression](machine_learning/linear_regression.py)
  * Local Weighted Learning
    * [Local Weighted Learning](machine_learning/local_weighted_learning/local_weighted_learning.py)
  * [Logistic Regression](machine_learning/logistic_regression.py)
  * [Loss Functions](machine_learning/loss_functions.py)
  * Lstm
    * [Lstm Prediction](machine_learning/lstm/lstm_prediction.py)
  * [Mfcc](machine_learning/mfcc.py)
  * [Multilayer Perceptron Classifier](machine_learning/multilayer_perceptron_classifier.py)
  * [Polynomial Regression](machine_learning/polynomial_regression.py)
  * [Principle Component Analysis](machine_learning/principle_component_analysis.py)
  * [Scoring Functions](machine_learning/scoring_functions.py)
  * [Self Organizing Map](machine_learning/self_organizing_map.py)
  * [Sequential Minimum Optimization](machine_learning/sequential_minimum_optimization.py)
  * [Similarity Search](machine_learning/similarity_search.py)
  * [Support Vector Machines](machine_learning/support_vector_machines.py)
  * [T Stochastic Neighbour Embedding](machine_learning/t_stochastic_neighbour_embedding.py)
  * [Word Frequency Functions](machine_learning/word_frequency_functions.py)
  * [Xgboost Classifier](machine_learning/xgboost_classifier.py)
  * [Xgboost Regressor](machine_learning/xgboost_regressor.py)

## Maths
  * [Abs](maths/abs.py)
  * [Addition Without Arithmetic](maths/addition_without_arithmetic.py)
  * [Aliquot Sum](maths/aliquot_sum.py)
  * [Allocation Number](maths/allocation_number.py)
  * [Arc Length](maths/arc_length.py)
  * [Area](maths/area.py)
  * [Area Under Curve](maths/area_under_curve.py)
  * [Average Absolute Deviation](maths/average_absolute_deviation.py)
  * [Average Mean](maths/average_mean.py)
  * [Average Median](maths/average_median.py)
  * [Average Mode](maths/average_mode.py)
  * [Bailey Borwein Plouffe](maths/bailey_borwein_plouffe.py)
  * [Base Neg2 Conversion](maths/base_neg2_conversion.py)
  * [Basic Maths](maths/basic_maths.py)
  * [Binary Exponentiation](maths/binary_exponentiation.py)
  * [Binary Multiplication](maths/binary_multiplication.py)
  * [Binomial Coefficient](maths/binomial_coefficient.py)
  * [Binomial Distribution](maths/binomial_distribution.py)
  * [Ceil](maths/ceil.py)
  * [Chebyshev Distance](maths/chebyshev_distance.py)
  * [Check Polygon](maths/check_polygon.py)
  * [Chinese Remainder Theorem](maths/chinese_remainder_theorem.py)
  * [Chudnovsky Algorithm](maths/chudnovsky_algorithm.py)
  * [Collatz Sequence](maths/collatz_sequence.py)
  * [Combinations](maths/combinations.py)
  * [Continued Fraction](maths/continued_fraction.py)
  * [Decimal Isolate](maths/decimal_isolate.py)
  * [Decimal To Fraction](maths/decimal_to_fraction.py)
  * [Dodecahedron](maths/dodecahedron.py)
  * [Double Factorial](maths/double_factorial.py)
  * [Dual Number Automatic Differentiation](maths/dual_number_automatic_differentiation.py)
  * [Entropy](maths/entropy.py)
  * [Euclidean Distance](maths/euclidean_distance.py)
  * [Euler Method](maths/euler_method.py)
  * [Euler Modified](maths/euler_modified.py)
  * [Eulers Totient](maths/eulers_totient.py)
  * [Extended Euclidean Algorithm](maths/extended_euclidean_algorithm.py)
  * [Factorial](maths/factorial.py)
  * [Factors](maths/factors.py)
  * [Fast Inverse Sqrt](maths/fast_inverse_sqrt.py)
  * [Fermat Little Theorem](maths/fermat_little_theorem.py)
  * [Fibonacci](maths/fibonacci.py)
  * [Find Max](maths/find_max.py)
  * [Find Min](maths/find_min.py)
  * [Floor](maths/floor.py)
  * [Gamma](maths/gamma.py)
  * [Gaussian](maths/gaussian.py)
  * [Gcd Of N Numbers](maths/gcd_of_n_numbers.py)
  * [Geometric Mean](maths/geometric_mean.py)
  * [Germain Primes](maths/germain_primes.py)
  * [Greatest Common Divisor](maths/greatest_common_divisor.py)
  * [Hardy Ramanujanalgo](maths/hardy_ramanujanalgo.py)
  * [Integer Square Root](maths/integer_square_root.py)
  * [Interquartile Range](maths/interquartile_range.py)
  * [Is Int Palindrome](maths/is_int_palindrome.py)
  * [Is Ip V4 Address Valid](maths/is_ip_v4_address_valid.py)
  * [Is Square Free](maths/is_square_free.py)
  * [Jaccard Similarity](maths/jaccard_similarity.py)
  * [Joint Probability Distribution](maths/joint_probability_distribution.py)
  * [Josephus Problem](maths/josephus_problem.py)
  * [Juggler Sequence](maths/juggler_sequence.py)
  * [Karatsuba](maths/karatsuba.py)
  * [Kth Lexicographic Permutation](maths/kth_lexicographic_permutation.py)
  * [Largest Of Very Large Numbers](maths/largest_of_very_large_numbers.py)
  * [Least Common Multiple](maths/least_common_multiple.py)
  * [Line Length](maths/line_length.py)
  * [Liouville Lambda](maths/liouville_lambda.py)
  * [Lucas Lehmer Primality Test](maths/lucas_lehmer_primality_test.py)
  * [Lucas Series](maths/lucas_series.py)
  * [Maclaurin Series](maths/maclaurin_series.py)
  * [Manhattan Distance](maths/manhattan_distance.py)
  * [Matrix Exponentiation](maths/matrix_exponentiation.py)
  * [Max Sum Sliding Window](maths/max_sum_sliding_window.py)
  * [Minkowski Distance](maths/minkowski_distance.py)
  * [Mobius Function](maths/mobius_function.py)
  * [Modular Division](maths/modular_division.py)
  * [Modular Exponential](maths/modular_exponential.py)
  * [Monte Carlo](maths/monte_carlo.py)
  * [Monte Carlo Dice](maths/monte_carlo_dice.py)
  * [Number Of Digits](maths/number_of_digits.py)
  * Numerical Analysis
    * [Adams Bashforth](maths/numerical_analysis/adams_bashforth.py)
    * [Bisection](maths/numerical_analysis/bisection.py)
    * [Bisection 2](maths/numerical_analysis/bisection_2.py)
    * [Integration By Simpson Approx](maths/numerical_analysis/integration_by_simpson_approx.py)
    * [Intersection](maths/numerical_analysis/intersection.py)
    * [Nevilles Method](maths/numerical_analysis/nevilles_method.py)
    * [Newton Forward Interpolation](maths/numerical_analysis/newton_forward_interpolation.py)
    * [Newton Raphson](maths/numerical_analysis/newton_raphson.py)
    * [Numerical Integration](maths/numerical_analysis/numerical_integration.py)
    * [Proper Fractions](maths/numerical_analysis/proper_fractions.py)
    * [Runge Kutta](maths/numerical_analysis/runge_kutta.py)
    * [Runge Kutta Fehlberg 45](maths/numerical_analysis/runge_kutta_fehlberg_45.py)
    * [Runge Kutta Gills](maths/numerical_analysis/runge_kutta_gills.py)
    * [Secant Method](maths/numerical_analysis/secant_method.py)
    * [Simpson Rule](maths/numerical_analysis/simpson_rule.py)
    * [Square Root](maths/numerical_analysis/square_root.py)
    * [Weierstrass Method](maths/numerical_analysis/weierstrass_method.py)
  * [Odd Sieve](maths/odd_sieve.py)
  * [Perfect Cube](maths/perfect_cube.py)
  * [Perfect Number](maths/perfect_number.py)
  * [Perfect Square](maths/perfect_square.py)
  * [Persistence](maths/persistence.py)
  * [Pi Generator](maths/pi_generator.py)
  * [Pi Monte Carlo Estimation](maths/pi_monte_carlo_estimation.py)
  * [Points Are Collinear 3D](maths/points_are_collinear_3d.py)
  * [Pollard Rho](maths/pollard_rho.py)
  * [Polynomial Evaluation](maths/polynomial_evaluation.py)
  * Polynomials
    * [Single Indeterminate Operations](maths/polynomials/single_indeterminate_operations.py)
  * [Power Using Recursion](maths/power_using_recursion.py)
  * [Prime Check](maths/prime_check.py)
  * [Prime Factors](maths/prime_factors.py)
  * [Prime Numbers](maths/prime_numbers.py)
  * [Prime Sieve Eratosthenes](maths/prime_sieve_eratosthenes.py)
  * [Primelib](maths/primelib.py)
  * [Print Multiplication Table](maths/print_multiplication_table.py)
  * [Pythagoras](maths/pythagoras.py)
  * [Qr Decomposition](maths/qr_decomposition.py)
  * [Quadratic Equations Complex Numbers](maths/quadratic_equations_complex_numbers.py)
  * [Radians](maths/radians.py)
  * [Radix2 Fft](maths/radix2_fft.py)
  * [Remove Digit](maths/remove_digit.py)
  * [Segmented Sieve](maths/segmented_sieve.py)
  * Series
    * [Arithmetic](maths/series/arithmetic.py)
    * [Geometric](maths/series/geometric.py)
    * [Geometric Series](maths/series/geometric_series.py)
    * [Harmonic](maths/series/harmonic.py)
    * [Harmonic Series](maths/series/harmonic_series.py)
    * [Hexagonal Numbers](maths/series/hexagonal_numbers.py)
    * [P Series](maths/series/p_series.py)
  * [Sieve Of Eratosthenes](maths/sieve_of_eratosthenes.py)
  * [Sigmoid](maths/sigmoid.py)
  * [Signum](maths/signum.py)
  * [Simultaneous Linear Equation Solver](maths/simultaneous_linear_equation_solver.py)
  * [Sin](maths/sin.py)
  * [Sock Merchant](maths/sock_merchant.py)
  * [Softmax](maths/softmax.py)
  * [Solovay Strassen Primality Test](maths/solovay_strassen_primality_test.py)
  * [Spearman Rank Correlation Coefficient](maths/spearman_rank_correlation_coefficient.py)
  * Special Numbers
    * [Armstrong Numbers](maths/special_numbers/armstrong_numbers.py)
    * [Automorphic Number](maths/special_numbers/automorphic_number.py)
    * [Bell Numbers](maths/special_numbers/bell_numbers.py)
    * [Carmichael Number](maths/special_numbers/carmichael_number.py)
    * [Catalan Number](maths/special_numbers/catalan_number.py)
    * [Hamming Numbers](maths/special_numbers/hamming_numbers.py)
    * [Happy Number](maths/special_numbers/happy_number.py)
    * [Harshad Numbers](maths/special_numbers/harshad_numbers.py)
    * [Hexagonal Number](maths/special_numbers/hexagonal_number.py)
    * [Krishnamurthy Number](maths/special_numbers/krishnamurthy_number.py)
    * [Perfect Number](maths/special_numbers/perfect_number.py)
    * [Polygonal Numbers](maths/special_numbers/polygonal_numbers.py)
    * [Pronic Number](maths/special_numbers/pronic_number.py)
    * [Proth Number](maths/special_numbers/proth_number.py)
    * [Triangular Numbers](maths/special_numbers/triangular_numbers.py)
    * [Ugly Numbers](maths/special_numbers/ugly_numbers.py)
    * [Weird Number](maths/special_numbers/weird_number.py)
  * [Sum Of Arithmetic Series](maths/sum_of_arithmetic_series.py)
  * [Sum Of Digits](maths/sum_of_digits.py)
  * [Sum Of Geometric Progression](maths/sum_of_geometric_progression.py)
  * [Sum Of Harmonic Series](maths/sum_of_harmonic_series.py)
  * [Sumset](maths/sumset.py)
  * [Sylvester Sequence](maths/sylvester_sequence.py)
  * [Tanh](maths/tanh.py)
  * [Test Factorial](maths/test_factorial.py)
  * [Test Prime Check](maths/test_prime_check.py)
  * [Three Sum](maths/three_sum.py)
  * [Trapezoidal Rule](maths/trapezoidal_rule.py)
  * [Triplet Sum](maths/triplet_sum.py)
  * [Twin Prime](maths/twin_prime.py)
  * [Two Pointer](maths/two_pointer.py)
  * [Two Sum](maths/two_sum.py)
  * [Volume](maths/volume.py)
  * [Zellers Congruence](maths/zellers_congruence.py)

## Matrix
  * [Binary Search Matrix](matrix/binary_search_matrix.py)
  * [Count Islands In Matrix](matrix/count_islands_in_matrix.py)
  * [Count Negative Numbers In Sorted Matrix](matrix/count_negative_numbers_in_sorted_matrix.py)
  * [Count Paths](matrix/count_paths.py)
  * [Cramers Rule 2X2](matrix/cramers_rule_2x2.py)
  * [Inverse Of Matrix](matrix/inverse_of_matrix.py)
  * [Largest Square Area In Matrix](matrix/largest_square_area_in_matrix.py)
  * [Matrix Based Game](matrix/matrix_based_game.py)
  * [Matrix Class](matrix/matrix_class.py)
  * [Matrix Equalization](matrix/matrix_equalization.py)
  * [Matrix Multiplication Recursion](matrix/matrix_multiplication_recursion.py)
  * [Matrix Operation](matrix/matrix_operation.py)
  * [Max Area Of Island](matrix/max_area_of_island.py)
  * [Median Matrix](matrix/median_matrix.py)
  * [Nth Fibonacci Using Matrix Exponentiation](matrix/nth_fibonacci_using_matrix_exponentiation.py)
  * [Pascal Triangle](matrix/pascal_triangle.py)
  * [Rotate Matrix](matrix/rotate_matrix.py)
  * [Searching In Sorted Matrix](matrix/searching_in_sorted_matrix.py)
  * [Sherman Morrison](matrix/sherman_morrison.py)
  * [Spiral Print](matrix/spiral_print.py)
  * Tests
    * [Test Matrix Operation](matrix/tests/test_matrix_operation.py)
  * [Validate Sudoku Board](matrix/validate_sudoku_board.py)

## Networking Flow
  * [Ford Fulkerson](networking_flow/ford_fulkerson.py)
  * [Minimum Cut](networking_flow/minimum_cut.py)

## Neural Network
  * Activation Functions
    * [Binary Step](neural_network/activation_functions/binary_step.py)
    * [Exponential Linear Unit](neural_network/activation_functions/exponential_linear_unit.py)
    * [Gaussian Error Linear Unit](neural_network/activation_functions/gaussian_error_linear_unit.py)
    * [Leaky Rectified Linear Unit](neural_network/activation_functions/leaky_rectified_linear_unit.py)
    * [Mish](neural_network/activation_functions/mish.py)
    * [Rectified Linear Unit](neural_network/activation_functions/rectified_linear_unit.py)
    * [Scaled Exponential Linear Unit](neural_network/activation_functions/scaled_exponential_linear_unit.py)
    * [Soboleva Modified Hyperbolic Tangent](neural_network/activation_functions/soboleva_modified_hyperbolic_tangent.py)
    * [Softplus](neural_network/activation_functions/softplus.py)
    * [Squareplus](neural_network/activation_functions/squareplus.py)
    * [Swish](neural_network/activation_functions/swish.py)
  * [Back Propagation Neural Network](neural_network/back_propagation_neural_network.py)
  * [Convolution Neural Network](neural_network/convolution_neural_network.py)
  * [Input Data](neural_network/input_data.py)
  * [Simple Neural Network](neural_network/simple_neural_network.py)
  * [Two Hidden Layers Neural Network](neural_network/two_hidden_layers_neural_network.py)

## Other
  * [Activity Selection](other/activity_selection.py)
  * [Alternative List Arrange](other/alternative_list_arrange.py)
  * [Bankers Algorithm](other/bankers_algorithm.py)
  * [Davis Putnam Logemann Loveland](other/davis_putnam_logemann_loveland.py)
  * [Doomsday](other/doomsday.py)
  * [Fischer Yates Shuffle](other/fischer_yates_shuffle.py)
  * [Gauss Easter](other/gauss_easter.py)
  * [Graham Scan](other/graham_scan.py)
  * [Greedy](other/greedy.py)
  * [Guess The Number Search](other/guess_the_number_search.py)
  * [H Index](other/h_index.py)
  * [Least Recently Used](other/least_recently_used.py)
  * [Lfu Cache](other/lfu_cache.py)
  * [Linear Congruential Generator](other/linear_congruential_generator.py)
  * [Lru Cache](other/lru_cache.py)
  * [Magicdiamondpattern](other/magicdiamondpattern.py)
  * [Majority Vote Algorithm](other/majority_vote_algorithm.py)
  * [Maximum Subsequence](other/maximum_subsequence.py)
  * [Nested Brackets](other/nested_brackets.py)
  * [Number Container System](other/number_container_system.py)
  * [Password](other/password.py)
  * [Quine](other/quine.py)
  * [Scoring Algorithm](other/scoring_algorithm.py)
  * [Sdes](other/sdes.py)
  * [Tower Of Hanoi](other/tower_of_hanoi.py)
  * [Word Search](other/word_search.py)

## Physics
  * [Altitude Pressure](physics/altitude_pressure.py)
  * [Archimedes Principle Of Buoyant Force](physics/archimedes_principle_of_buoyant_force.py)
  * [Basic Orbital Capture](physics/basic_orbital_capture.py)
  * [Casimir Effect](physics/casimir_effect.py)
  * [Center Of Mass](physics/center_of_mass.py)
  * [Centripetal Force](physics/centripetal_force.py)
  * [Coulombs Law](physics/coulombs_law.py)
  * [Doppler Frequency](physics/doppler_frequency.py)
  * [Escape Velocity](physics/escape_velocity.py)
  * [Grahams Law](physics/grahams_law.py)
  * [Horizontal Projectile Motion](physics/horizontal_projectile_motion.py)
  * [Hubble Parameter](physics/hubble_parameter.py)
  * [Ideal Gas Law](physics/ideal_gas_law.py)
  * [In Static Equilibrium](physics/in_static_equilibrium.py)
  * [Kinetic Energy](physics/kinetic_energy.py)
  * [Lens Formulae](physics/lens_formulae.py)
  * [Lorentz Transformation Four Vector](physics/lorentz_transformation_four_vector.py)
  * [Malus Law](physics/malus_law.py)
  * [Mass Energy Equivalence](physics/mass_energy_equivalence.py)
  * [Mirror Formulae](physics/mirror_formulae.py)
  * [N Body Simulation](physics/n_body_simulation.py)
  * [Newtons Law Of Gravitation](physics/newtons_law_of_gravitation.py)
  * [Newtons Second Law Of Motion](physics/newtons_second_law_of_motion.py)
  * [Orbital Transfer Work](physics/orbital_transfer_work.py)
  * [Period Of Pendulum](physics/period_of_pendulum.py)
  * [Photoelectric Effect](physics/photoelectric_effect.py)
  * [Potential Energy](physics/potential_energy.py)
  * [Rainfall Intensity](physics/rainfall_intensity.py)
  * [Reynolds Number](physics/reynolds_number.py)
  * [Rms Speed Of Molecule](physics/rms_speed_of_molecule.py)
  * [Shear Stress](physics/shear_stress.py)
  * [Speed Of Sound](physics/speed_of_sound.py)
  * [Speeds Of Gas Molecules](physics/speeds_of_gas_molecules.py)
  * [Terminal Velocity](physics/terminal_velocity.py)

## Project Euler
  * Problem 001
    * [Sol1](project_euler/problem_001/sol1.py)
    * [Sol2](project_euler/problem_001/sol2.py)
    * [Sol3](project_euler/problem_001/sol3.py)
    * [Sol4](project_euler/problem_001/sol4.py)
    * [Sol5](project_euler/problem_001/sol5.py)
    * [Sol6](project_euler/problem_001/sol6.py)
    * [Sol7](project_euler/problem_001/sol7.py)
  * Problem 002
    * [Sol1](project_euler/problem_002/sol1.py)
    * [Sol2](project_euler/problem_002/sol2.py)
    * [Sol3](project_euler/problem_002/sol3.py)
    * [Sol4](project_euler/problem_002/sol4.py)
    * [Sol5](project_euler/problem_002/sol5.py)
  * Problem 003
    * [Sol1](project_euler/problem_003/sol1.py)
    * [Sol2](project_euler/problem_003/sol2.py)
    * [Sol3](project_euler/problem_003/sol3.py)
  * Problem 004
    * [Sol1](project_euler/problem_004/sol1.py)
    * [Sol2](project_euler/problem_004/sol2.py)
  * Problem 005
    * [Sol1](project_euler/problem_005/sol1.py)
    * [Sol2](project_euler/problem_005/sol2.py)
  * Problem 006
    * [Sol1](project_euler/problem_006/sol1.py)
    * [Sol2](project_euler/problem_006/sol2.py)
    * [Sol3](project_euler/problem_006/sol3.py)
    * [Sol4](project_euler/problem_006/sol4.py)
  * Problem 007
    * [Sol1](project_euler/problem_007/sol1.py)
    * [Sol2](project_euler/problem_007/sol2.py)
    * [Sol3](project_euler/problem_007/sol3.py)
  * Problem 008
    * [Sol1](project_euler/problem_008/sol1.py)
    * [Sol2](project_euler/problem_008/sol2.py)
    * [Sol3](project_euler/problem_008/sol3.py)
  * Problem 009
    * [Sol1](project_euler/problem_009/sol1.py)
    * [Sol2](project_euler/problem_009/sol2.py)
    * [Sol3](project_euler/problem_009/sol3.py)
    * [Sol4](project_euler/problem_009/sol4.py)
  * Problem 010
    * [Sol1](project_euler/problem_010/sol1.py)
    * [Sol2](project_euler/problem_010/sol2.py)
    * [Sol3](project_euler/problem_010/sol3.py)
  * Problem 011
    * [Sol1](project_euler/problem_011/sol1.py)
    * [Sol2](project_euler/problem_011/sol2.py)
  * Problem 012
    * [Sol1](project_euler/problem_012/sol1.py)
    * [Sol2](project_euler/problem_012/sol2.py)
  * Problem 013
    * [Sol1](project_euler/problem_013/sol1.py)
  * Problem 014
    * [Sol1](project_euler/problem_014/sol1.py)
    * [Sol2](project_euler/problem_014/sol2.py)
  * Problem 015
    * [Sol1](project_euler/problem_015/sol1.py)
  * Problem 016
    * [Sol1](project_euler/problem_016/sol1.py)
    * [Sol2](project_euler/problem_016/sol2.py)
  * Problem 017
    * [Sol1](project_euler/problem_017/sol1.py)
  * Problem 018
    * [Solution](project_euler/problem_018/solution.py)
  * Problem 019
    * [Sol1](project_euler/problem_019/sol1.py)
  * Problem 020
    * [Sol1](project_euler/problem_020/sol1.py)
    * [Sol2](project_euler/problem_020/sol2.py)
    * [Sol3](project_euler/problem_020/sol3.py)
    * [Sol4](project_euler/problem_020/sol4.py)
  * Problem 021
    * [Sol1](project_euler/problem_021/sol1.py)
  * Problem 022
    * [Sol1](project_euler/problem_022/sol1.py)
    * [Sol2](project_euler/problem_022/sol2.py)
  * Problem 023
    * [Sol1](project_euler/problem_023/sol1.py)
  * Problem 024
    * [Sol1](project_euler/problem_024/sol1.py)
  * Problem 025
    * [Sol1](project_euler/problem_025/sol1.py)
    * [Sol2](project_euler/problem_025/sol2.py)
    * [Sol3](project_euler/problem_025/sol3.py)
  * Problem 026
    * [Sol1](project_euler/problem_026/sol1.py)
  * Problem 027
    * [Sol1](project_euler/problem_027/sol1.py)
  * Problem 028
    * [Sol1](project_euler/problem_028/sol1.py)
  * Problem 029
    * [Sol1](project_euler/problem_029/sol1.py)
  * Problem 030
    * [Sol1](project_euler/problem_030/sol1.py)
  * Problem 031
    * [Sol1](project_euler/problem_031/sol1.py)
    * [Sol2](project_euler/problem_031/sol2.py)
  * Problem 032
    * [Sol32](project_euler/problem_032/sol32.py)
  * Problem 033
    * [Sol1](project_euler/problem_033/sol1.py)
  * Problem 034
    * [Sol1](project_euler/problem_034/sol1.py)
  * Problem 035
    * [Sol1](project_euler/problem_035/sol1.py)
  * Problem 036
    * [Sol1](project_euler/problem_036/sol1.py)
  * Problem 037
    * [Sol1](project_euler/problem_037/sol1.py)
  * Problem 038
    * [Sol1](project_euler/problem_038/sol1.py)
  * Problem 039
    * [Sol1](project_euler/problem_039/sol1.py)
  * Problem 040
    * [Sol1](project_euler/problem_040/sol1.py)
  * Problem 041
    * [Sol1](project_euler/problem_041/sol1.py)
  * Problem 042
    * [Solution42](project_euler/problem_042/solution42.py)
  * Problem 043
    * [Sol1](project_euler/problem_043/sol1.py)
  * Problem 044
    * [Sol1](project_euler/problem_044/sol1.py)
  * Problem 045
    * [Sol1](project_euler/problem_045/sol1.py)
  * Problem 046
    * [Sol1](project_euler/problem_046/sol1.py)
  * Problem 047
    * [Sol1](project_euler/problem_047/sol1.py)
  * Problem 048
    * [Sol1](project_euler/problem_048/sol1.py)
  * Problem 049
    * [Sol1](project_euler/problem_049/sol1.py)
  * Problem 050
    * [Sol1](project_euler/problem_050/sol1.py)
  * Problem 051
    * [Sol1](project_euler/problem_051/sol1.py)
  * Problem 052
    * [Sol1](project_euler/problem_052/sol1.py)
  * Problem 053
    * [Sol1](project_euler/problem_053/sol1.py)
  * Problem 054
    * [Sol1](project_euler/problem_054/sol1.py)
    * [Test Poker Hand](project_euler/problem_054/test_poker_hand.py)
  * Problem 055
    * [Sol1](project_euler/problem_055/sol1.py)
  * Problem 056
    * [Sol1](project_euler/problem_056/sol1.py)
  * Problem 057
    * [Sol1](project_euler/problem_057/sol1.py)
  * Problem 058
    * [Sol1](project_euler/problem_058/sol1.py)
  * Problem 059
    * [Sol1](project_euler/problem_059/sol1.py)
  * Problem 062
    * [Sol1](project_euler/problem_062/sol1.py)
  * Problem 063
    * [Sol1](project_euler/problem_063/sol1.py)
  * Problem 064
    * [Sol1](project_euler/problem_064/sol1.py)
  * Problem 065
    * [Sol1](project_euler/problem_065/sol1.py)
  * Problem 067
    * [Sol1](project_euler/problem_067/sol1.py)
    * [Sol2](project_euler/problem_067/sol2.py)
  * Problem 068
    * [Sol1](project_euler/problem_068/sol1.py)
  * Problem 069
    * [Sol1](project_euler/problem_069/sol1.py)
  * Problem 070
    * [Sol1](project_euler/problem_070/sol1.py)
  * Problem 071
    * [Sol1](project_euler/problem_071/sol1.py)
  * Problem 072
    * [Sol1](project_euler/problem_072/sol1.py)
    * [Sol2](project_euler/problem_072/sol2.py)
  * Problem 073
    * [Sol1](project_euler/problem_073/sol1.py)
  * Problem 074
    * [Sol1](project_euler/problem_074/sol1.py)
    * [Sol2](project_euler/problem_074/sol2.py)
  * Problem 075
    * [Sol1](project_euler/problem_075/sol1.py)
  * Problem 076
    * [Sol1](project_euler/problem_076/sol1.py)
  * Problem 077
    * [Sol1](project_euler/problem_077/sol1.py)
  * Problem 078
    * [Sol1](project_euler/problem_078/sol1.py)
  * Problem 079
    * [Sol1](project_euler/problem_079/sol1.py)
  * Problem 080
    * [Sol1](project_euler/problem_080/sol1.py)
  * Problem 081
    * [Sol1](project_euler/problem_081/sol1.py)
  * Problem 082
    * [Sol1](project_euler/problem_082/sol1.py)
  * Problem 085
    * [Sol1](project_euler/problem_085/sol1.py)
  * Problem 086
    * [Sol1](project_euler/problem_086/sol1.py)
  * Problem 087
    * [Sol1](project_euler/problem_087/sol1.py)
  * Problem 089
    * [Sol1](project_euler/problem_089/sol1.py)
  * Problem 091
    * [Sol1](project_euler/problem_091/sol1.py)
  * Problem 092
    * [Sol1](project_euler/problem_092/sol1.py)
  * Problem 094
    * [Sol1](project_euler/problem_094/sol1.py)
  * Problem 095
    * [Sol1](project_euler/problem_095/sol1.py)
  * Problem 097
    * [Sol1](project_euler/problem_097/sol1.py)
  * Problem 099
    * [Sol1](project_euler/problem_099/sol1.py)
  * Problem 100
    * [Sol1](project_euler/problem_100/sol1.py)
  * Problem 101
    * [Sol1](project_euler/problem_101/sol1.py)
  * Problem 102
    * [Sol1](project_euler/problem_102/sol1.py)
  * Problem 104
    * [Sol1](project_euler/problem_104/sol1.py)
  * Problem 107
    * [Sol1](project_euler/problem_107/sol1.py)
  * Problem 109
    * [Sol1](project_euler/problem_109/sol1.py)
  * Problem 112
    * [Sol1](project_euler/problem_112/sol1.py)
  * Problem 113
    * [Sol1](project_euler/problem_113/sol1.py)
  * Problem 114
    * [Sol1](project_euler/problem_114/sol1.py)
  * Problem 115
    * [Sol1](project_euler/problem_115/sol1.py)
  * Problem 116
    * [Sol1](project_euler/problem_116/sol1.py)
  * Problem 117
    * [Sol1](project_euler/problem_117/sol1.py)
  * Problem 119
    * [Sol1](project_euler/problem_119/sol1.py)
  * Problem 120
    * [Sol1](project_euler/problem_120/sol1.py)
  * Problem 121
    * [Sol1](project_euler/problem_121/sol1.py)
  * Problem 122
    * [Sol1](project_euler/problem_122/sol1.py)
  * Problem 123
    * [Sol1](project_euler/problem_123/sol1.py)
  * Problem 125
    * [Sol1](project_euler/problem_125/sol1.py)
  * Problem 129
    * [Sol1](project_euler/problem_129/sol1.py)
  * Problem 131
    * [Sol1](project_euler/problem_131/sol1.py)
  * Problem 135
    * [Sol1](project_euler/problem_135/sol1.py)
  * Problem 136
    * [Sol1](project_euler/problem_136/sol1.py)
  * Problem 144
    * [Sol1](project_euler/problem_144/sol1.py)
  * Problem 145
    * [Sol1](project_euler/problem_145/sol1.py)
  * Problem 164
    * [Sol1](project_euler/problem_164/sol1.py)
  * Problem 173
    * [Sol1](project_euler/problem_173/sol1.py)
  * Problem 174
    * [Sol1](project_euler/problem_174/sol1.py)
  * Problem 180
    * [Sol1](project_euler/problem_180/sol1.py)
  * Problem 187
    * [Sol1](project_euler/problem_187/sol1.py)
  * Problem 188
    * [Sol1](project_euler/problem_188/sol1.py)
  * Problem 190
    * [Sol1](project_euler/problem_190/sol1.py)
  * Problem 191
    * [Sol1](project_euler/problem_191/sol1.py)
  * Problem 203
    * [Sol1](project_euler/problem_203/sol1.py)
  * Problem 205
    * [Sol1](project_euler/problem_205/sol1.py)
  * Problem 206
    * [Sol1](project_euler/problem_206/sol1.py)
  * Problem 207
    * [Sol1](project_euler/problem_207/sol1.py)
  * Problem 234
    * [Sol1](project_euler/problem_234/sol1.py)
  * Problem 301
    * [Sol1](project_euler/problem_301/sol1.py)
  * Problem 345
    * [Sol1](project_euler/problem_345/sol1.py)
  * Problem 493
    * [Sol1](project_euler/problem_493/sol1.py)
  * Problem 551
    * [Sol1](project_euler/problem_551/sol1.py)
  * Problem 587
    * [Sol1](project_euler/problem_587/sol1.py)
  * Problem 686
    * [Sol1](project_euler/problem_686/sol1.py)
  * Problem 800
    * [Sol1](project_euler/problem_800/sol1.py)

## Quantum
  * [Q Fourier Transform](quantum/q_fourier_transform.py)

## Scheduling
  * [First Come First Served](scheduling/first_come_first_served.py)
  * [Highest Response Ratio Next](scheduling/highest_response_ratio_next.py)
  * [Job Sequence With Deadline](scheduling/job_sequence_with_deadline.py)
  * [Job Sequencing With Deadline](scheduling/job_sequencing_with_deadline.py)
  * [Multi Level Feedback Queue](scheduling/multi_level_feedback_queue.py)
  * [Non Preemptive Shortest Job First](scheduling/non_preemptive_shortest_job_first.py)
  * [Round Robin](scheduling/round_robin.py)
  * [Shortest Job First](scheduling/shortest_job_first.py)

## Searches
  * [Binary Search](searches/binary_search.py)
  * [Binary Tree Traversal](searches/binary_tree_traversal.py)
  * [Double Linear Search](searches/double_linear_search.py)
  * [Double Linear Search Recursion](searches/double_linear_search_recursion.py)
  * [Exponential Search](searches/exponential_search.py)
  * [Fibonacci Search](searches/fibonacci_search.py)
  * [Hill Climbing](searches/hill_climbing.py)
  * [Interpolation Search](searches/interpolation_search.py)
  * [Jump Search](searches/jump_search.py)
  * [Linear Search](searches/linear_search.py)
  * [Median Of Medians](searches/median_of_medians.py)
  * [Quick Select](searches/quick_select.py)
  * [Sentinel Linear Search](searches/sentinel_linear_search.py)
  * [Simple Binary Search](searches/simple_binary_search.py)
  * [Simulated Annealing](searches/simulated_annealing.py)
  * [Tabu Search](searches/tabu_search.py)
  * [Ternary Search](searches/ternary_search.py)

## Sorts
  * [Bead Sort](sorts/bead_sort.py)
  * [Binary Insertion Sort](sorts/binary_insertion_sort.py)
  * [Bitonic Sort](sorts/bitonic_sort.py)
  * [Bogo Sort](sorts/bogo_sort.py)
  * [Bubble Sort](sorts/bubble_sort.py)
  * [Bucket Sort](sorts/bucket_sort.py)
  * [Circle Sort](sorts/circle_sort.py)
  * [Cocktail Shaker Sort](sorts/cocktail_shaker_sort.py)
  * [Comb Sort](sorts/comb_sort.py)
  * [Counting Sort](sorts/counting_sort.py)
  * [Cycle Sort](sorts/cycle_sort.py)
  * [Cyclic Sort](sorts/cyclic_sort.py)
  * [Double Sort](sorts/double_sort.py)
  * [Dutch National Flag Sort](sorts/dutch_national_flag_sort.py)
  * [Exchange Sort](sorts/exchange_sort.py)
  * [External Sort](sorts/external_sort.py)
  * [Gnome Sort](sorts/gnome_sort.py)
  * [Heap Sort](sorts/heap_sort.py)
  * [Insertion Sort](sorts/insertion_sort.py)
  * [Intro Sort](sorts/intro_sort.py)
  * [Iterative Merge Sort](sorts/iterative_merge_sort.py)
  * [Merge Insertion Sort](sorts/merge_insertion_sort.py)
  * [Merge Sort](sorts/merge_sort.py)
  * [Msd Radix Sort](sorts/msd_radix_sort.py)
  * [Natural Sort](sorts/natural_sort.py)
  * [Odd Even Sort](sorts/odd_even_sort.py)
  * [Odd Even Transposition Parallel](sorts/odd_even_transposition_parallel.py)
  * [Odd Even Transposition Single Threaded](sorts/odd_even_transposition_single_threaded.py)
  * [Pancake Sort](sorts/pancake_sort.py)
  * [Patience Sort](sorts/patience_sort.py)
  * [Pigeon Sort](sorts/pigeon_sort.py)
  * [Pigeonhole Sort](sorts/pigeonhole_sort.py)
  * [Quick Sort](sorts/quick_sort.py)
  * [Quick Sort 3 Partition](sorts/quick_sort_3_partition.py)
  * [Radix Sort](sorts/radix_sort.py)
  * [Recursive Insertion Sort](sorts/recursive_insertion_sort.py)
  * [Recursive Mergesort Array](sorts/recursive_mergesort_array.py)
  * [Recursive Quick Sort](sorts/recursive_quick_sort.py)
  * [Selection Sort](sorts/selection_sort.py)
  * [Shell Sort](sorts/shell_sort.py)
  * [Shrink Shell Sort](sorts/shrink_shell_sort.py)
  * [Slowsort](sorts/slowsort.py)
  * [Stalin Sort](sorts/stalin_sort.py)
  * [Stooge Sort](sorts/stooge_sort.py)
  * [Strand Sort](sorts/strand_sort.py)
  * [Tim Sort](sorts/tim_sort.py)
  * [Topological Sort](sorts/topological_sort.py)
  * [Tree Sort](sorts/tree_sort.py)
  * [Unknown Sort](sorts/unknown_sort.py)
  * [Wiggle Sort](sorts/wiggle_sort.py)

## Strings
  * [Aho Corasick](strings/aho_corasick.py)
  * [Alternative String Arrange](strings/alternative_string_arrange.py)
  * [Anagrams](strings/anagrams.py)
  * [Autocomplete Using Trie](strings/autocomplete_using_trie.py)
  * [Barcode Validator](strings/barcode_validator.py)
  * [Bitap String Match](strings/bitap_string_match.py)
  * [Boyer Moore Search](strings/boyer_moore_search.py)
  * [Camel Case To Snake Case](strings/camel_case_to_snake_case.py)
  * [Can String Be Rearranged As Palindrome](strings/can_string_be_rearranged_as_palindrome.py)
  * [Capitalize](strings/capitalize.py)
  * [Check Anagrams](strings/check_anagrams.py)
  * [Count Vowels](strings/count_vowels.py)
  * [Credit Card Validator](strings/credit_card_validator.py)
  * [Damerau Levenshtein Distance](strings/damerau_levenshtein_distance.py)
  * [Detecting English Programmatically](strings/detecting_english_programmatically.py)
  * [Dna](strings/dna.py)
  * [Edit Distance](strings/edit_distance.py)
  * [Frequency Finder](strings/frequency_finder.py)
  * [Hamming Distance](strings/hamming_distance.py)
  * [Indian Phone Validator](strings/indian_phone_validator.py)
  * [Is Contains Unique Chars](strings/is_contains_unique_chars.py)
  * [Is Isogram](strings/is_isogram.py)
  * [Is Pangram](strings/is_pangram.py)
  * [Is Polish National Id](strings/is_polish_national_id.py)
  * [Is Spain National Id](strings/is_spain_national_id.py)
  * [Is Srilankan Phone Number](strings/is_srilankan_phone_number.py)
  * [Is Valid Email Address](strings/is_valid_email_address.py)
  * [Jaro Winkler](strings/jaro_winkler.py)
  * [Join](strings/join.py)
  * [Knuth Morris Pratt](strings/knuth_morris_pratt.py)
  * [Levenshtein Distance](strings/levenshtein_distance.py)
  * [Lower](strings/lower.py)
  * [Manacher](strings/manacher.py)
  * [Min Cost String Conversion](strings/min_cost_string_conversion.py)
  * [Naive String Search](strings/naive_string_search.py)
  * [Ngram](strings/ngram.py)
  * [Palindrome](strings/palindrome.py)
  * [Pig Latin](strings/pig_latin.py)
  * [Prefix Function](strings/prefix_function.py)
  * [Rabin Karp](strings/rabin_karp.py)
  * [Remove Duplicate](strings/remove_duplicate.py)
  * [Reverse Letters](strings/reverse_letters.py)
  * [Reverse Words](strings/reverse_words.py)
  * [Snake Case To Camel Pascal Case](strings/snake_case_to_camel_pascal_case.py)
  * [Split](strings/split.py)
  * [String Switch Case](strings/string_switch_case.py)
  * [Strip](strings/strip.py)
  * [Text Justification](strings/text_justification.py)
  * [Title](strings/title.py)
  * [Top K Frequent Words](strings/top_k_frequent_words.py)
  * [Upper](strings/upper.py)
  * [Wave String](strings/wave_string.py)
  * [Wildcard Pattern Matching](strings/wildcard_pattern_matching.py)
  * [Word Occurrence](strings/word_occurrence.py)
  * [Word Patterns](strings/word_patterns.py)
  * [Z Function](strings/z_function.py)

## Web Programming
  * [Co2 Emission](web_programming/co2_emission.py)
  * [Covid Stats Via Xpath](web_programming/covid_stats_via_xpath.py)
  * [Crawl Google Results](web_programming/crawl_google_results.py)
  * [Crawl Google Scholar Citation](web_programming/crawl_google_scholar_citation.py)
  * [Currency Converter](web_programming/currency_converter.py)
  * [Current Stock Price](web_programming/current_stock_price.py)
  * [Current Weather](web_programming/current_weather.py)
  * [Daily Horoscope](web_programming/daily_horoscope.py)
  * [Download Images From Google Query](web_programming/download_images_from_google_query.py)
  * [Emails From Url](web_programming/emails_from_url.py)
  * [Fetch Anime And Play](web_programming/fetch_anime_and_play.py)
  * [Fetch Bbc News](web_programming/fetch_bbc_news.py)
  * [Fetch Github Info](web_programming/fetch_github_info.py)
  * [Fetch Jobs](web_programming/fetch_jobs.py)
  * [Fetch Quotes](web_programming/fetch_quotes.py)
  * [Fetch Well Rx Price](web_programming/fetch_well_rx_price.py)
  * [Get Amazon Product Data](web_programming/get_amazon_product_data.py)
  * [Get Imdb Top 250 Movies Csv](web_programming/get_imdb_top_250_movies_csv.py)
  * [Get Ip Geolocation](web_programming/get_ip_geolocation.py)
  * [Get Top Billionaires](web_programming/get_top_billionaires.py)
  * [Get Top Hn Posts](web_programming/get_top_hn_posts.py)
  * [Giphy](web_programming/giphy.py)
  * [Instagram Crawler](web_programming/instagram_crawler.py)
  * [Instagram Pic](web_programming/instagram_pic.py)
  * [Instagram Video](web_programming/instagram_video.py)
  * [Nasa Data](web_programming/nasa_data.py)
  * [Open Google Results](web_programming/open_google_results.py)
  * [Random Anime Character](web_programming/random_anime_character.py)
  * [Recaptcha Verification](web_programming/recaptcha_verification.py)
  * [Reddit](web_programming/reddit.py)
  * [Search Books By Isbn](web_programming/search_books_by_isbn.py)
  * [Slack Message](web_programming/slack_message.py)
  * [Test Fetch Github Info](web_programming/test_fetch_github_info.py)
  * [World Covid19 Stats](web_programming/world_covid19_stats.py)
