# Contribution Guidelines

## App to be submitted

Not all tools can be considered.
The aim of the list is to provide a concise list of awesome CLI tools and apps.
This means that all suggested software should:
  
- Do one thing and do it well.
- Have a free and open source license.
- Be easy to install.
- Be well documented.
- Be older than 90 days.
- Have more than 20 stars (if it is hosted on GitHub.)

## Pull request to add an app

**Contents:**

Add the app at the bottom of the relevant category.
Use the following format for the entry: `[APP_NAME](LINK) - DESCRIPTION.`
Where:
- The description starts with a capital and ends with a full stop (period).
- The description is short and concise. No redundant information like "CLI" or "terminal"
  Usually the apps repository description or tag line is a good starting point.
- There is no trailing whitespace.

**Style:**

Open one pull request per app suggestion and title it simply `Add APP_NAME`.
Use the provided pull request template.
Failure follow this point means the PR will be closed without being looked at.

Thank you for contributing :)

## Other Pull Requests

Pull requests that are not adding a new app, but introduce new categories or improve the readme are always welcome!
In that case feel free to disregard the given structure above.
