# Awesome macOS Screensavers [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

> A curated list of screensavers for macOS.

Inspired by the [awesome](https://github.com/sindresorhus/awesome) list thing.

## Table of Contents

- [Clocks](#clocks)
- [Apple Inspired](#apple-inspired)
- [Retro](#retro)
- [Sci-Fi](#sci-fi)
- [Video Game](#video-game)
- [Aquarium](#aquarium)
- [Developer](#developer)
- [Graphics](#graphics)
- [Other](#other)
- [Collections](#collections)

---

## Clocks

### fliqlo

> A flip clock screensaver.

[![](screenshots/fliqlo.png)](http://fliqlo.com/)

### Today

> Time or date displayed in a similar way to On Kawara's "Today Series" paintings.

[![](screenshots/today.png)](http://www.gingerbeardman.com/today/)

### Word Clock

> A clock made of words. It switches between a circular and a paragraph layout.

[![](screenshots/wordClock.png)](https://www.simonheys.com/wordclock/)

### Fractal Clock

> A clock that produces a fractal tree pattern around it as it moves.

[![](screenshots/fractalClock.png)](http://www.dqd.com/~mayoff/programs/FractalClock/)

### Epoch Flip Clock

> Unix Time (epoch) flip clock.

[![](screenshots/epochFlipClock.png)](https://github.com/chrstphrknwtn/epoch-flip-clock-screensaver/)

### Grid Clock

> Twelve hour time in words.

[![](screenshots/gridClock.png)](https://github.com/chrstphrknwtn/grid-clock-screensaver/)

### Word Clock

> A super simple word clock, like your computer is typing the time for you.

[![](screenshots/wordClock2.gif)](https://github.com/chrstphrknwtn/word-clock-screensaver/)

### Simple Clock

> A simple clock screensaver with different analogue clock faces as skins.

Free

[![](screenshots/simpleClock.png)](https://github.com/Wandmalfarbe/Simple-Clock-Screensaver/)

### ColorClock

> Displays a solid color corresponding to the current time.

[![](screenshots/colorClockSaver.png)](https://github.com/edwardloveall/colorclocksaver)

### ScreenMazer

> Continuously builds and then solves a maze, while displaying the current time.

[![](screenshots/screenMazer.png)](https://github.com/dado3212/screenmazer)

### Evangelion Clock

> A digital clock screensaver inspired by the graphical interfaces from Neon Genesis Evengelion.

Free

[![](screenshots/evangelionClock.png)](https://github.com/Wandmalfarbe/evangelion-clock-screensaver/)

### Predator

> A predator-inspired clock screensaver.

[![](screenshots/predator.png)](https://github.com/vpeschenkov/Predator)

### Death Counter

> A simple counter screensaver that counts down to your death.

[![](screenshots/deathcounter.png)](https://github.com/anhmv/DeathCounter)

### MinimalClock

> Simple and elegant screensaver for MacOS that displays the time.

Free

[![](screenshots/MinimalClock.png)](https://github.com/mattiarossini/MinimalClock)

### MultiClock

> Displays the time (and animations) using 24 individual clocks

[![](screenshots/multiclock.png)](https://github.com/amiantos/multiclock)

### Flip Clock Screensaver

> A flip clock screensaver that can automatically dim the screen.

Free

[![](screenshots/FlipClockScreensaver.jpg)](https://www.smart-app.dev/downloads/downloads.html)

### Digital Electric

> A vintage screensaver inspired by old-fashioned alarm clocks.

[![](screenshots/digital-electric-screensaver.png)](https://quismi.com/digital-electric)

## Apple Inspired

### Aerial

> Apple TV Aerial Screensaver for Mac.

[![](screenshots/aerial.png)](https://github.com/JohnCoates/Aerial)

### Apple Watch

> A screensaver that looks like an Apple Watch.

[![](screenshots/appleWatch.png)](http://www.rasmusnielsen.dk/applewatch/)

### Brooklyn

> A screensaver inspired by Apple's Event on October 30, 2018

[![](screenshots/brooklyn.png)](https://github.com/pedrommcarrasco/Brooklyn#readme)

Free

### Start Now

> Draw inspiration from great minds every time you wake up your Mac

[![](https://github.com/Ventuss-OvO/start-now-saver/raw/main/Resources/Now.png)](https://github.com/Ventuss-OvO/start-now-saver)

## MusaicFM

> A screensaver inspired by the iTunes Artwork Screensaver for Spotify and Last.fm.

[![](screenshots/musaicFm.png)](https://github.com/docterd/MusaicFM)

Free

### iOS Lockscreen for macOS

> A screensaver that looks like the lockscreen on iPhone and iPad.

[![](screenshots/iOSLockscreen.png)](http://littleendiangamestudios.com/project/ios-8-screen-saver/)

### October 30

> Smoothly changes between 371 Apple logos from their 2018 iPad event.

Free

[![](screenshots/october30.png)](https://github.com/lekevicius/october30)

### Fruit

> Animated vintage Apple logo

[![](screenshots/fruit.png)](https://github.com/ppamorim/fruit)

Free

### SwiftBubble

> Recreation of the soap bubble screen saver from apple's promotional videos for the new MacBook 12"

[![](screenshots/swiftbubble.png)](https://github.com/nemesit/SwiftBubble)

Free (Open Source)

## Retro

### PongSaver

> PongSaver is an macOS screensaver/clock which keeps time by using the score of a game of Pong. The left side wins once an hour, and the right side wins once a minute.

[![](screenshots/pongSaver.png)](https://mikeash.com/software/pongsaver/)

### Textify Me

> This interactive screen saver turns everything in front of your camera into text.

$0.99

[![](screenshots/textifyMe.png)](https://itunes.apple.com/us/app/textify-me/id470453599)

## Sci-Fi

### The Github Matrix Screensaver

> The latest commits from GitHub visualized in a Matrix-style animation.

[![](screenshots/githubMatrix.png)](https://github.com/winterbe/github-matrix-screensaver)

### StarWarsScroll

> Recreates the opening titles of the first 6 Star Wars movies.

[![](screenshots/starWarsScroll.png)](http://download.cnet.com/StarWarsScroll-Screen-Saver/3000-2257_4-82580.html)

### Matrix

> One interpretation of The Matrix.

[![](screenshots/matrix.png)](https://github.com/monroewilliams/MatrixDownload)

## Video Game

### SpeedS@ver

> Plays videos of people completing speed runs of games.

[![](screenshots/speedS@ver.png)](https://github.com/orta/SpeedS-ver)

## Aquarium

### Aquarium live lite

> Video of aquariums.

[![](screenshots/aquariumLive.png)](https://itunes.apple.com/us/app/aquarium-live-lite-relaxing/id462563503)

## Developer

### Developer Excuses

> A macOS Screensaver which shows quotes from [http://developerexcuses.com](http://developerexcuses.com) (unofficial).

[![](screenshots/developerExcuses.png)](https://github.com/kimar/DeveloperExcuses)

### MacOS Kernel Panic

> Harmless screensaver that faithfully emulates the horrifying experience of a kernel panic.

Free

[![](screenshots/macosKernelPanic.png)](http://doomlaser.com/kernel-panic-screensaver/)

### Windows Kernel Panic

> Blue Screen of Death (BSOD) screensaver for Mac.

Free

[![](screenshots/kernelPanic.png)](https://github.com/dessibelle/Blue-Screen-Saver)

### octoscreen

> An OS X screensaver with octicons

Free (Open Source)

[![](screenshots/octoscreen.png)](https://github.com/orderedlist/octoscreen)

## Graphics

### Electric Sheep Infinite Evolving Artwork

> Animations of evolving fractals.

Free

[![](screenshots/electricSheep.png)](http://electricsheep.org/)

### Screensson

> Creates unique patterns on your display by randomly stacking vector stencils.

Donationware

[![](screenshots/screensson.png)](http://www.siggieggertsson.com/Saver-Screensson)

### Emoji Saver

> Animates Apple, EmojiOne and Twitter Emojis in 7 different effects with many customizable settings.

Lite Version (Free) and Full Version ($3)

[![](screenshots/emojiSaver.png)](https://www.emojisaver.eu/)

### Life Saver

> Designer-friendly abstract visualization of Conway's Game of Life.

Free (Open Source)

[![](screenshots/lifesaver.png)](https://www.github.com/amiantos/lifesaver)

### ElectropaintOSX

> Port of the mesmerizing Silicon Graphics screensaver

Free (Open Source)

[![image](https://user-images.githubusercontent.com/16557/134262935-72d6194d-97b2-4de3-9a44-79cf826cc114.png)](http://crimsonmagic.net/)

### Ealain

> Infinite and forever changing abstract art, generated by Stable Diffusion

Free (Open Source)

[![](screenshots/ealain-examples.jpg)](https://www.github.com/amiantos/ealain)

## Other

### Google Trends

> Shows the latest hot searches for all regions or specific countries.

Free

[![](screenshots/googleTrends.png)](https://www.google.com/trends/hottrends/visualize?nrow=5&ncol=5)

### Last Statement

> Like the macOS "Word of the Day" screensaver, but instead of words and definitions, it's the names and last statements of people executed by the State of Texas.

Free (Open Source)

[![](screenshots/last-statement.png)](https://www.github.com/amiantos/last-statement)

### macOS Live Screensaver

> Plays live video streams from YouTube and HLS sources.

Free (Open Source)

[![](screenshots/macosLiveScreensaver.png)](https://github.com/hauxir/macos-live-screensaver)

## Collections

### Bjorn Johansson

> Digital art in the form of screensavers by designer Bjorn Johansson.

Free (pay what you want)

[![](screenshots/johansson.png)](https://vsxop.com/work/screensavers)

---

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Adam Garrett-Harris](https://twitter.com/agarrharr) has waived all copyright and related or neighboring rights to this work.
