/* tslint:disable */
/* eslint-disable */
/**
 * Agent Protocol
 * Specification of the API protocol for communication with an agent.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Artifact,
  GetAgentTask404Response,
  Step,
  StepRequestBody,
  Task,
  TaskArtifactsListResponse,
  TaskListResponse,
  TaskRequestBody,
  TaskStepsListResponse,
} from '../models/index';
import {
    ArtifactFromJSON,
    ArtifactToJSON,
    GetAgentTask404ResponseFromJSON,
    GetAgentTask404ResponseToJSON,
    StepFromJSON,
    StepToJSON,
    StepRequestBodyFromJSON,
    StepRequestBodyToJSON,
    TaskFromJSON,
    TaskToJSON,
    TaskArtifactsListResponseFromJSON,
    TaskArtifactsListResponseToJSON,
    TaskListResponseFromJSON,
    TaskListResponseToJSON,
    TaskRequestBodyFromJSON,
    TaskRequestBodyToJSON,
    TaskStepsListResponseFromJSON,
    TaskStepsListResponseToJSON,
} from '../models/index';

export interface CreateAgentTaskRequest {
    taskRequestBody?: TaskRequestBody;
}

export interface DownloadAgentTaskArtifactRequest {
    taskId: string;
    artifactId: string;
}

export interface ExecuteAgentTaskStepRequest {
    taskId: string;
    stepRequestBody?: StepRequestBody;
}

export interface GetAgentTaskRequest {
    taskId: string;
}

export interface GetAgentTaskStepRequest {
    taskId: string;
    stepId: string;
}

export interface ListAgentTaskArtifactsRequest {
    taskId: string;
    currentPage?: number;
    pageSize?: number;
}

export interface ListAgentTaskStepsRequest {
    taskId: string;
    currentPage?: number;
    pageSize?: number;
}

export interface ListAgentTasksRequest {
    currentPage?: number;
    pageSize?: number;
}

export interface UploadAgentTaskArtifactsRequest {
    taskId: string;
    file: Blob;
    relativePath?: string;
}

/**
 * 
 */
export class AgentApi extends runtime.BaseAPI {

    /**
     * Creates a task for the agent.
     */
    async createAgentTaskRaw(requestParameters: CreateAgentTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Task>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/ap/v1/agent/tasks`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: TaskRequestBodyToJSON(requestParameters['taskRequestBody']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TaskFromJSON(jsonValue));
    }

    /**
     * Creates a task for the agent.
     */
    async createAgentTask(requestParameters: CreateAgentTaskRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Task> {
        const response = await this.createAgentTaskRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Download a specified artifact.
     */
    async downloadAgentTaskArtifactRaw(requestParameters: DownloadAgentTaskArtifactRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling downloadAgentTaskArtifact().'
            );
        }

        if (requestParameters['artifactId'] == null) {
            throw new runtime.RequiredError(
                'artifactId',
                'Required parameter "artifactId" was null or undefined when calling downloadAgentTaskArtifact().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}/artifacts/{artifact_id}`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))).replace(`{${"artifact_id"}}`, encodeURIComponent(String(requestParameters['artifactId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * Download a specified artifact.
     */
    async downloadAgentTaskArtifact(requestParameters: DownloadAgentTaskArtifactRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.downloadAgentTaskArtifactRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Execute a step in the specified agent task.
     */
    async executeAgentTaskStepRaw(requestParameters: ExecuteAgentTaskStepRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Step>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling executeAgentTaskStep().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}/steps`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: StepRequestBodyToJSON(requestParameters['stepRequestBody']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StepFromJSON(jsonValue));
    }

    /**
     * Execute a step in the specified agent task.
     */
    async executeAgentTaskStep(requestParameters: ExecuteAgentTaskStepRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Step> {
        const response = await this.executeAgentTaskStepRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get details about a specified agent task.
     */
    async getAgentTaskRaw(requestParameters: GetAgentTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Task>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling getAgentTask().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TaskFromJSON(jsonValue));
    }

    /**
     * Get details about a specified agent task.
     */
    async getAgentTask(requestParameters: GetAgentTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Task> {
        const response = await this.getAgentTaskRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get details about a specified task step.
     */
    async getAgentTaskStepRaw(requestParameters: GetAgentTaskStepRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Step>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling getAgentTaskStep().'
            );
        }

        if (requestParameters['stepId'] == null) {
            throw new runtime.RequiredError(
                'stepId',
                'Required parameter "stepId" was null or undefined when calling getAgentTaskStep().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}/steps/{step_id}`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))).replace(`{${"step_id"}}`, encodeURIComponent(String(requestParameters['stepId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StepFromJSON(jsonValue));
    }

    /**
     * Get details about a specified task step.
     */
    async getAgentTaskStep(requestParameters: GetAgentTaskStepRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Step> {
        const response = await this.getAgentTaskStepRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List all artifacts that have been created for the given task.
     */
    async listAgentTaskArtifactsRaw(requestParameters: ListAgentTaskArtifactsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TaskArtifactsListResponse>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling listAgentTaskArtifacts().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['currentPage'] != null) {
            queryParameters['current_page'] = requestParameters['currentPage'];
        }

        if (requestParameters['pageSize'] != null) {
            queryParameters['page_size'] = requestParameters['pageSize'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}/artifacts`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TaskArtifactsListResponseFromJSON(jsonValue));
    }

    /**
     * List all artifacts that have been created for the given task.
     */
    async listAgentTaskArtifacts(requestParameters: ListAgentTaskArtifactsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TaskArtifactsListResponse> {
        const response = await this.listAgentTaskArtifactsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List all steps for the specified task.
     */
    async listAgentTaskStepsRaw(requestParameters: ListAgentTaskStepsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TaskStepsListResponse>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling listAgentTaskSteps().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['currentPage'] != null) {
            queryParameters['current_page'] = requestParameters['currentPage'];
        }

        if (requestParameters['pageSize'] != null) {
            queryParameters['page_size'] = requestParameters['pageSize'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}/steps`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TaskStepsListResponseFromJSON(jsonValue));
    }

    /**
     * List all steps for the specified task.
     */
    async listAgentTaskSteps(requestParameters: ListAgentTaskStepsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TaskStepsListResponse> {
        const response = await this.listAgentTaskStepsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List all tasks that have been created for the agent.
     */
    async listAgentTasksRaw(requestParameters: ListAgentTasksRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TaskListResponse>> {
        const queryParameters: any = {};

        if (requestParameters['currentPage'] != null) {
            queryParameters['current_page'] = requestParameters['currentPage'];
        }

        if (requestParameters['pageSize'] != null) {
            queryParameters['page_size'] = requestParameters['pageSize'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/ap/v1/agent/tasks`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TaskListResponseFromJSON(jsonValue));
    }

    /**
     * List all tasks that have been created for the agent.
     */
    async listAgentTasks(requestParameters: ListAgentTasksRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TaskListResponse> {
        const response = await this.listAgentTasksRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Upload an artifact for the specified task.
     */
    async uploadAgentTaskArtifactsRaw(requestParameters: UploadAgentTaskArtifactsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Artifact>> {
        if (requestParameters['taskId'] == null) {
            throw new runtime.RequiredError(
                'taskId',
                'Required parameter "taskId" was null or undefined when calling uploadAgentTaskArtifacts().'
            );
        }

        if (requestParameters['file'] == null) {
            throw new runtime.RequiredError(
                'file',
                'Required parameter "file" was null or undefined when calling uploadAgentTaskArtifacts().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters['file'] != null) {
            formParams.append('file', requestParameters['file'] as any);
        }

        if (requestParameters['relativePath'] != null) {
            formParams.append('relative_path', requestParameters['relativePath'] as any);
        }

        const response = await this.request({
            path: `/ap/v1/agent/tasks/{task_id}/artifacts`.replace(`{${"task_id"}}`, encodeURIComponent(String(requestParameters['taskId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ArtifactFromJSON(jsonValue));
    }

    /**
     * Upload an artifact for the specified task.
     */
    async uploadAgentTaskArtifacts(requestParameters: UploadAgentTaskArtifactsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Artifact> {
        const response = await this.uploadAgentTaskArtifactsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
