/* tslint:disable */
/* eslint-disable */
/**
 * Agent Protocol
 * Specification of the API protocol for communication with an agent.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * An Artifact either created by or submitted to the agent.
 * @export
 * @interface Artifact
 */
export interface Artifact {
    /**
     * ID of the artifact.
     * @type {string}
     * @memberof Artifact
     */
    artifactId: string;
    /**
     * Whether the artifact has been created by the agent.
     * @type {boolean}
     * @memberof Artifact
     */
    agentCreated: boolean;
    /**
     * Filename of the artifact.
     * @type {string}
     * @memberof Artifact
     */
    fileName: string;
    /**
     * Relative path of the artifact in the agent's workspace.
     * @type {string}
     * @memberof Artifact
     */
    relativePath?: string;
}

/**
 * Check if a given object implements the Artifact interface.
 */
export function instanceOfArtifact(value: object): boolean {
    if (!('artifactId' in value)) return false;
    if (!('agentCreated' in value)) return false;
    if (!('fileName' in value)) return false;
    return true;
}

export function ArtifactFromJSON(json: any): Artifact {
    return ArtifactFromJSONTyped(json, false);
}

export function ArtifactFromJSONTyped(json: any, ignoreDiscriminator: boolean): Artifact {
    if (json == null) {
        return json;
    }
    return {
        
        'artifactId': json['artifact_id'],
        'agentCreated': json['agent_created'],
        'fileName': json['file_name'],
        'relativePath': json['relative_path'] == null ? undefined : json['relative_path'],
    };
}

export function ArtifactToJSON(value?: Artifact | null): any {
    if (value == null) {
        return value;
    }
    return {
        
        'artifact_id': value['artifactId'],
        'agent_created': value['agentCreated'],
        'file_name': value['fileName'],
        'relative_path': value['relativePath'],
    };
}

