/* tslint:disable */
/* eslint-disable */
/**
 * Agent Protocol
 * Specification of the API protocol for communication with an agent.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { Artifact } from './Artifact';
import {
    ArtifactFromJSON,
    ArtifactFromJSONTyped,
    ArtifactToJSON,
} from './Artifact';

/**
 * 
 * @export
 * @interface Step
 */
export interface Step {
    /**
     * Input prompt for the step.
     * @type {string}
     * @memberof Step
     */
    input?: string;
    /**
     * Input parameters for the task step. Any value is allowed.
     * @type {object}
     * @memberof Step
     */
    additionalInput?: object;
    /**
     * The ID of the task this step belongs to.
     * @type {string}
     * @memberof Step
     */
    taskId: string;
    /**
     * The ID of the task step.
     * @type {string}
     * @memberof Step
     */
    stepId: string;
    /**
     * The name of the task step.
     * @type {string}
     * @memberof Step
     */
    name?: string;
    /**
     * The status of the task step.
     * @type {string}
     * @memberof Step
     */
    status: StepStatusEnum;
    /**
     * Output of the task step.
     * @type {string}
     * @memberof Step
     */
    output?: string;
    /**
     * Output that the task step has produced. Any value is allowed.
     * @type {object}
     * @memberof Step
     */
    additionalOutput?: object;
    /**
     * A list of artifacts that the step has produced.
     * @type {Array<Artifact>}
     * @memberof Step
     */
    artifacts: Array<Artifact>;
    /**
     * Whether this is the last step in the task.
     * @type {boolean}
     * @memberof Step
     */
    isLast: boolean;
}


/**
 * @export
 */
export const StepStatusEnum = {
    Created: 'created',
    Running: 'running',
    Completed: 'completed'
} as const;
export type StepStatusEnum = typeof StepStatusEnum[keyof typeof StepStatusEnum];


/**
 * Check if a given object implements the Step interface.
 */
export function instanceOfStep(value: object): boolean {
    if (!('taskId' in value)) return false;
    if (!('stepId' in value)) return false;
    if (!('status' in value)) return false;
    if (!('artifacts' in value)) return false;
    if (!('isLast' in value)) return false;
    return true;
}

export function StepFromJSON(json: any): Step {
    return StepFromJSONTyped(json, false);
}

export function StepFromJSONTyped(json: any, ignoreDiscriminator: boolean): Step {
    if (json == null) {
        return json;
    }
    return {
        
        'input': json['input'] == null ? undefined : json['input'],
        'additionalInput': json['additional_input'] == null ? undefined : json['additional_input'],
        'taskId': json['task_id'],
        'stepId': json['step_id'],
        'name': json['name'] == null ? undefined : json['name'],
        'status': json['status'],
        'output': json['output'] == null ? undefined : json['output'],
        'additionalOutput': json['additional_output'] == null ? undefined : json['additional_output'],
        'artifacts': ((json['artifacts'] as Array<any>).map(ArtifactFromJSON)),
        'isLast': json['is_last'],
    };
}

export function StepToJSON(value?: Step | null): any {
    if (value == null) {
        return value;
    }
    return {
        
        'input': value['input'],
        'additional_input': value['additionalInput'],
        'task_id': value['taskId'],
        'step_id': value['stepId'],
        'name': value['name'],
        'status': value['status'],
        'output': value['output'],
        'additional_output': value['additionalOutput'],
        'artifacts': ((value['artifacts'] as Array<any>).map(ArtifactToJSON)),
        'is_last': value['isLast'],
    };
}

