[![Logo](docs/img/Logo.png)](https://ajenti.org/)

Ajenti is a Linux & BSD modular server admin panel. Ajenti 2 provides a new interface and a better architecture, developed with [Python3](https://www.python.org/) and [AngularJS](https://angularjs.org/).

<p align="center">
    <a href="https://crowdin.net/project/ajenti">
        <img src="https://badges.crowdin.net/ajenti/localized.svg" alt="Badge Crowdin" />
    </a>
    <a href="https://github.com/ajenti/ajenti/graphs/contributors">
        <img src="https://img.shields.io/github/contributors/ajenti/ajenti?label=Contributors" alt="Badge Contributors" />
    </a>
    <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/LICENSE"> 
        <img src="https://img.shields.io/github/license/ajenti/ajenti?label=License" alt="Badge License" />
    </a>
</p>

----

# Feature highlights

* **Easy installation** : Ajenti 2 can be easy installed [with pip and the provided script](https://docs.ajenti.org/en/latest/man/install.html#installing).

* **Existing configuration** : Picks up your current configuration and works on your existing system as-is, without any preparation.

* **Caring** : Does not overwrite your config files, options and comments. All changes are non-destructive.

* **Batteries included** : Includes lots of plugins for system and software configuration, monitoring and management.

* **Extensible** : Ajenti 2 is easily extensible using Python. Plugin development is a quick and pleasant with Ajenti APIs. [Write your first plugin](https://docs.ajenti.org/en/latest/dev/intro.html#your-first-plugin).

* **Modern** : Pleasant to look at, satisfying to click and accessible anywhere from tablets and mobile.

* **Lightweight** : Small memory footprint and CPU usage. Runs on low-end machines, wall plugs, routers and so on.

----

# Screenshots

<table align="center">
    <tr>
        <td align="center">
            <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/docs/img/rd-login.png">
                <img src="docs/img/rd-login.png" alt="Screenshot Ajenti Login" width="300px" />
            </a>
        </td>
        <td align="center">
            <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/docs/img/rd-dashboard.png">
                <img src="docs/img/rd-dashboard.png" alt="Screenshot Ajenti Dashboard" width="300px" /> 
            </a>
        </td>
        <td align="center">
            <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/docs/img/rd-settings.png"> 
                <img src="docs/img/rd-settings.png" alt="Screenshot Ajenti Settings" width="300px" />
            </a>
        </td>
    </tr>
    <tr>
        <td align="center">
            <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/docs/img/rd-plugins.png"> 
                <img src="docs/img/rd-plugins.png" alt="Screenshot Ajenti Plugins" width="300px" /> 
            </a>
        </td>
        <td align="center">
            <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/docs/img/rd-systemd.png"> 
                <img src="docs/img/rd-systemd.png" alt="Screenshot Ajenti Systemd" width="300px" />
            </a> 
        </td>
        <td align="center">
            <a href="https://raw.githubusercontent.com/ajenti/ajenti/master/docs/img/rd-terminal.png"> 
                <img src="docs/img/rd-terminal.png" alt="Screenshot Ajenti Terminal" width="300px" /> 
            </a>
        </td>
    </tr>
</table>

See https://docs.ajenti.org for more information

----

# Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://www.unpeud.info"><img src="https://avatars2.githubusercontent.com/u/10401079?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Kientz Arnaud</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=kiarn" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/DmZ"><img src="https://avatars2.githubusercontent.com/u/222974?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Dmitry Zamaruev</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=DmZ" title="Code">💻</a></td>
    <td align="center"><a href="http://dierz.pro"><img src="https://avatars3.githubusercontent.com/u/7171587?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Ivlev Denis</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=ivlevdenis" title="Code">💻</a></td>
    <td align="center"><a href="http://bryukh.com"><img src="https://avatars0.githubusercontent.com/u/343120?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Valentin Bryukhanov</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=Bryukh" title="Code">💻</a></td>
    <td align="center"><a href="http://kstep.me"><img src="https://avatars0.githubusercontent.com/u/28537?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Konstantin Stepanov</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=kstep" title="Code">💻</a></td>
    <td align="center"><a href="http://alexsnet.ru"><img src="https://avatars2.githubusercontent.com/u/221848?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Alex Raeder</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=AlexSnet" title="Code">💻</a></td>
    <td align="center"><a href="http://openmandriva.org"><img src="https://avatars2.githubusercontent.com/u/598477?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Alexander Stefanov</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=fedya" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/triplem"><img src="https://avatars2.githubusercontent.com/u/160079?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Markus M. May</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=triplem" title="Code">💻</a></td>
    <td align="center"><a href="http://bugsfollow.me"><img src="https://avatars0.githubusercontent.com/u/20956?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Artsiomi Silivonchyk</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=MrHant" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ivoronin"><img src="https://avatars1.githubusercontent.com/u/1638389?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Ilya Voronin</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=ivoronin" title="Code">💻</a></td>
    <td align="center"><a href="http://www.crystalyx.net/"><img src="https://avatars2.githubusercontent.com/u/961976?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Xéfir Destiny</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=Xefir" title="Code">💻</a></td>
    <td align="center"><a href="http://eleventy-two.com"><img src="https://avatars3.githubusercontent.com/u/474014?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Martin Ellis</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=egelmex" title="Code">💻</a></td>
    <td align="center"><a href="http://geeklife.in.ua/"><img src="https://avatars1.githubusercontent.com/u/1715850?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Alex Kucherenko</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=AlexTiTanium" title="Code">💻</a></td>
    <td align="center"><a href="https://l4sh.github.io"><img src="https://avatars1.githubusercontent.com/u/4382808?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Luis Salazar</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=l4sh" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/migonzalvar"><img src="https://avatars0.githubusercontent.com/u/928566?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Miguel Gonzalez</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=migonzalvar" title="Code">💻</a></td>
    <td align="center"><a href="http://bitquant.ddns.net:82/"><img src="https://avatars0.githubusercontent.com/u/2908185?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Joseph Wang</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=joequant" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/fixmycode"><img src="https://avatars1.githubusercontent.com/u/705903?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Pablo Albornoz</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=fixmycode" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/praveenbm5"><img src="https://avatars3.githubusercontent.com/u/507203?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Praveen Baratam</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=praveenbm5" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/PLanB2008"><img src="https://avatars2.githubusercontent.com/u/26460239?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Andreas Till</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=PLanB2008" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/zysyl"><img src="https://avatars0.githubusercontent.com/u/631895?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Roman</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=zysyl" title="Code">💻</a></td>
    <td align="center"><a href="https://pnijhara.me"><img src="https://avatars0.githubusercontent.com/u/40136154?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Prajjwal Nijhara</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=pnijhara" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://nailuj.net"><img src="https://avatars0.githubusercontent.com/u/17853630?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Julian B</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=nailujx86" title="Code">💻</a></td>
    <td align="center"><a href="https://stackoverflow.com/story/catrielmuller"><img src="https://avatars1.githubusercontent.com/u/2272323?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Catriel Müller</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=catrielmuller" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/UnicronNL"><img src="https://avatars1.githubusercontent.com/u/1267745?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Kim</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=UnicronNL" title="Code">💻</a></td>
    <td align="center"><a href="https://www.daniel-schulz-software.de"><img src="https://avatars.githubusercontent.com/u/8694700?v=4?s=75" width="75px;" alt=""/><br /><sub><b>Daniel Schulz</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=daniel-schulz" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/dendilz"><img src="https://avatars.githubusercontent.com/u/33727631?v=4?s=75" width="75px;" alt=""/><br /><sub><b>dendilz</b></sub></a><br /><a href="https://github.com/ajenti/ajenti/commits?author=dendilz" title="Code">💻</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

# Contributing

Helpers are welcome ! There are many ways to help in Ajenti Project : 

  * [Translations](https://docs.ajenti.org/en/latest/man/contributing.html)
  * [Plugin development](https://docs.ajenti.org/en/latest/dev/intro.html)
  * [Core development](https://docs.ajenti.org/en/latest/dev/intro-core.html)

## Roadmap

Actually big changes are planned and under development. A global roadmap is : 

  * <s>Migrating to Python3
  * Migrating to [python-socketio](https://github.com/miguelgrinberg/python-socketio)
  * Implement better API REST with @get, @post ... decorators</s>
  * Migrating from AngularJS to Angular 13 (work in progress): 
      * plugins core and dashboard are almost done, but there's a lot of work to migrate all other plugins. 
      * This work take actually place in the branch [ajenti-3-dev](https://github.com/ajenti/ajenti/tree/ajenti-3-dev) and the new plugins are stored in the directory [plugins-new](https://github.com/ajenti/ajenti/tree/ajenti-3-dev/plugins-new)
      * The documentation is located at https://docs.ajenti.org/en/ajenti-3-dev/index.html
  * Add a lot of new plugins: once the migration to Angular done, we can add a lot of plugins to manage services on the server ( like apache2, nginx, postfix, etc ... ).
  * Migrating to [asyncio](https://docs.python.org/3/library/asyncio.html): concept tested, but migration not really started.
