## [AKShare](https://github.com/akfamily/akshare) 私募基金数据

### 中国证券投资基金业协会

#### 会员信息

##### 会员机构综合查询

接口: amac_member_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/member/index.html

描述: 中国证券投资基金业协会-信息公示-会员信息-会员机构综合查询

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称       | 类型     | 描述 |
|----------|--------|----|
| 机构（会员）名称 | object | -  |
| 会员代表     | object | -  |
| 会员类型     | object | -  |
| 会员编号     | object | -  |
| 入会时间     | object | -  |
| 机构类型     | object | -  |
| 是否星标     | object | -  |

接口示例

```python
import akshare as ak

amac_member_info_df = ak.amac_member_info()
print(amac_member_info_df)
```

数据示例

```
          机构（会员）名称 会员代表  会员类型          会员编号        入会时间            机构类型 是否星标
0         天相投资顾问有限公司  林义相  联席会员  LX1800000144  2012-06-06            其他机构    N
1         国泰基金管理有限公司  周向勇  普通会员  PT0100000001  2012-06-06        公募基金管理公司    Y
2       南方基金管理股份有限公司  杨小松  普通会员  PT0100000002  2012-06-06        公募基金管理公司    Y
3         华夏基金管理有限公司  李一梅  普通会员  PT0100000003  2012-06-06        公募基金管理公司    Y
4         华安基金管理有限公司  张霄岭  普通会员  PT0100000004  2012-06-06        公募基金管理公司    Y
              ...  ...   ...           ...         ...             ...  ...
4858  南通乐洵私募基金管理有限公司  胡爱文  观察会员  GC1900033127  2024-03-25     私募证券投资基金管理人    N
4859  上海瀛赐私募基金管理有限公司   黄振  观察会员  GC1900033128  2024-03-25     私募证券投资基金管理人    N
4860  合肥高新资本创业投资有限公司  吴玉麟  观察会员  GC1900033129  2024-03-25  私募股权、创业投资基金管理人    N
4861    上海涌见资产管理有限公司   张阳  观察会员  GC1900033130  2024-03-25     私募证券投资基金管理人    N
4862    深圳布谷资本管理有限公司  林三秀  观察会员  GC1900033131  2024-03-25     私募证券投资基金管理人    N
[4863 rows x 7 columns]
```

#### 从业人员信息

##### 基金从业人员资格注册信息

接口: amac_person_fund_org_list

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/person/personOrgList.html

描述: 中国证券投资基金业协会-信息公示-从业人员信息-基金从业人员资格注册信息

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称     | 类型  | 描述                                                                                                                                                                                                                                                                                                         |
|--------|-----|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| symbol | str | symbol="公募基金管理公司"; choice of {"公募基金管理公司", "公募基金管理公司资管子公司", "商业银行", "证券公司", "证券公司子公司", "私募基金管理人", "保险公司子公司", "保险公司", "外包服务机构", "期货公司", "期货公司资管子公司", "媒体机构", "证券投资咨询机构", "评价机构", "外资私募证券基金管理人", "支付结算", "独立服务机构", "地方自律组织", "境外机构", "律师事务所", "会计师事务所", "交易所", "独立第三方销售机构", "证券公司资管子公司", "证券公司私募基金子公司", "其他"} |

输出参数

| 名称       | 类型     | 描述  |
|----------|--------|-----|
| 序号       | int64  | -   |
| 机构名称     | object | -   |
| 员工人数     | object | -   |
| 基金从业资格   | int64  | -   |
| 基金销售业务资格 | int64  | -   |
| 基金经理     | int64  | -   |
| 投资经理     | int64  | -   |

接口示例

```python
import akshare as ak

amac_person_fund_org_list_df = ak.amac_person_fund_org_list(symbol="公募基金管理公司")
print(amac_person_fund_org_list_df)
```

数据示例

```
    序号            机构名称      机构类型  员工人数  基金从业资格  基金销售业务资格  基金经理  投资经理
0      1      安信基金管理有限责任公司  公募基金管理公司   234     233         0    19    33
1      2        百嘉基金管理有限公司  公募基金管理公司    42      42         0     2     2
2      3        宝盈基金管理有限公司  公募基金管理公司   180     176         0     8    16
3      4  北京京管泰富基金管理有限责任公司  公募基金管理公司    47      47         0     3     2
4      5       贝莱德基金管理有限公司  公募基金管理公司   100     100         0     3     8
..   ...               ...       ...   ...     ...       ...   ...   ...
141  142      中信保诚基金管理有限公司  公募基金管理公司   210     207         0    11    26
142  143      中信建投基金管理有限公司  公募基金管理公司   198     198         0     9    19
143  144        中银基金管理有限公司  公募基金管理公司   407     407         0    15    45
144  145    中邮创业基金管理股份有限公司  公募基金管理公司   207     207         0     6    21
145  146        朱雀基金管理有限公司  公募基金管理公司    90      90         0     9     8
[146 rows x 8 columns]
```

##### 债券投资交易相关人员公示

接口: amac_person_bond_org_list

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/person/personOrgList.html

描述: 中国证券投资基金业协会-信息公示-从业人员信息-债券投资交易相关人员公示

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称  | 类型  | 描述  |
|-----|-----|-----|
| -   | -   | -   |

输出参数

| 名称   | 类型     | 描述  |
|------|--------|-----|
| 序号   | int64  | -   |
| 机构类型 | object | -   |
| 机构名称 | object | -   |
| 公示网址 | object | -   |

接口示例

```python
import akshare as ak

amac_person_bond_org_list_df = ak.amac_person_bond_org_list()
print(amac_person_bond_org_list_df)
```

数据示例

```
      序号  ...                                               公示网址
0      1  ...  https://www.essencefund.com/mall/views/custser...
1      2  ...  http://www.baijiafunds.com.cn/aboutus/annnounc...
2      3  ...  http://www.byfunds.com/baoying/aboutus/about-u...
3      4  ...  http://www.cdbsfund.com/main/gywm/zzcx/index.s...
4      5  ...  https://www.bxrfund.com/#/list?menuid=10129&se...
..   ...  ...                                                ...
302  303  ...     https://www.citicsam.com/nformation/personnel/
303  304  ...  https://www.tkfunds.com.cn/aboutus/bondstaff/i...
304  305  ...  http://fund.piccamc.com/pc/newsInfo/articleInf...
305  306  ...         http://www.ebscn.com/gdzb/views/index.html
306  307  ...         https://hs.guosen.com.cn/hs/xxgs_zqjy.html
[307 rows x 4 columns]
```

#### 私募基金管理人公示

##### 私募基金管理人综合查询

接口: amac_manager_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/manager/index.html

描述: 中国证券投资基金业协会-信息公示-私募基金管理人公示-私募基金管理人综合查询

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称                    | 类型     | 描述 |
|-----------------------|--------|----|
| 私募基金管理人名称             | object | -  |
| 法定代表人/执行事务合伙人(委派代表)姓名 | object | -  |
| 机构类型                  | object | -  |
| 注册地                   | object | -  |
| 登记编号                  | object | -  |
| 成立时间                  | object | -  |
| 登记时间                  | object | -  |

接口示例

```python
import akshare as ak

amac_manager_info_df = ak.amac_manager_info()
print(amac_manager_info_df)
```

数据示例

```
              私募基金管理人名称 法定代表人/执行事务合伙人(委派代表)姓名  ...        成立时间        登记时间
0      平安道远投资管理（上海）有限公司                    王博  ...  2011-03-15  2014-03-17
1        上海重阳投资管理股份有限公司                    王庆  ...  2009-06-26  2014-03-17
2          上海景林资产管理有限公司                   高云程  ...  2012-06-06  2014-03-17
3        富舜资产管理（上海）有限公司                    周楠  ...  2012-02-10  2014-03-17
4            深圳民森投资有限公司                    蔡明  ...  2007-04-05  2014-03-17
                 ...                   ...  ...         ...         ...
21087  汉领（上海）私募基金管理有限公司                   夏明晨  ...  2022-09-07  2024-03-18
21088    青岛亿洋创业投资管理有限公司                   陆游龙  ...  2024-02-05  2024-03-25
21089    广州山岳私募基金管理有限公司                    柯声  ...  2023-08-15  2024-03-25
21090   东莞市生技私募基金管理有限公司                    肖丹  ...  2022-10-28  2024-04-01
21091  湖北农发创业投资基金管理有限公司                    熊赟  ...  2023-08-21  2024-04-01
[21092 rows x 7 columns]
```

##### 私募基金管理人分类公示

接口: amac_manager_classify_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/manager/managerList.html

描述: 中国证券投资基金业协会-信息公示-私募基金管理人公示-私募基金管理人分类公示

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称  | 类型  | 描述  |
|-----|-----|-----|
| -   | -   | -   |

输出参数

| 名称                    | 类型     | 描述  |
|-----------------------|--------|-----|
| 私募基金管理人名称             | object | -   |
| 法定代表人/执行事务合伙人(委派代表)姓名 | object | -   |
| 机构类型                  | object | -   |
| 登记编号                  | object | -   |
| 注册地                   | object | -   |
| 办公地                   | object | -   |
| 成立时间                  | object | -   |
| 登记时间                  | object | -   |
| 在管基金数量                | int64  | -   |
| 会员类型                  | object | -   |
| 是否有提示信息               | object | -   |
| 是否有诚信信息               | object | -   |

接口示例

```python
import akshare as ak

amac_manager_classify_info_df = ak.amac_manager_classify_info()
print(amac_manager_classify_info_df)
```

数据示例

```
        私募基金管理人名称 法定代表人/执行事务合伙人(委派代表)姓名  ... 是否有提示信息 是否有诚信信息
0      平安道远投资管理（上海）有限公司                    王博  ...       是       否
1        上海重阳投资管理股份有限公司                    王庆  ...       否       否
2          上海景林资产管理有限公司                   高云程  ...       是       否
3        富舜资产管理（上海）有限公司                    周楠  ...       是       否
4            深圳民森投资有限公司                    蔡明  ...       否       否
                 ...                   ...  ...     ...     ...
21087  汉领（上海）私募基金管理有限公司                   夏明晨  ...       是       否
21088    青岛亿洋创业投资管理有限公司                   陆游龙  ...       是       否
21089    广州山岳私募基金管理有限公司                    柯声  ...       是       否
21090   东莞市生技私募基金管理有限公司                    肖丹  ...       是       否
21091  湖北农发创业投资基金管理有限公司                    熊赟  ...       是       否
[21092 rows x 12 columns]
```

##### 证券公司私募基金子公司管理人信息公示

接口: amac_member_sub_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/member/index.html?primaryInvestType=private

描述: 中国证券投资基金业协会-信息公示-私募基金管理人公示-证券公司私募基金子公司管理人信息公示

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称       | 类型     | 描述 |
|----------|--------|----|
| 机构（会员）名称 | object | -  |
| 会员代表     | object | -  |
| 会员类型     | object | -  |
| 会员编号     | object | -  |
| 入会时间     | object | -  |
| 公司类型     | object | -  |

接口示例

```python
import akshare as ak

amac_member_sub_info_df = ak.amac_member_sub_info()
print(amac_member_sub_info_df)
```

数据示例

```
          机构（会员）名称 会员代表  会员类型          会员编号        入会时间            公司类型
0         天相投资顾问有限公司  林义相  联席会员  LX1800000144  2012-06-06            其他机构
1         国泰基金管理有限公司  周向勇  普通会员  PT0100000001  2012-06-06        公募基金管理公司
2       南方基金管理股份有限公司  杨小松  普通会员  PT0100000002  2012-06-06        公募基金管理公司
3         华夏基金管理有限公司  李一梅  普通会员  PT0100000003  2012-06-06        公募基金管理公司
4         华安基金管理有限公司  张霄岭  普通会员  PT0100000004  2012-06-06        公募基金管理公司
              ...  ...   ...           ...         ...             ...
4858  南通乐洵私募基金管理有限公司  胡爱文  观察会员  GC1900033127  2024-03-25     私募证券投资基金管理人
4859  上海瀛赐私募基金管理有限公司   黄振  观察会员  GC1900033128  2024-03-25     私募证券投资基金管理人
4860  合肥高新资本创业投资有限公司  吴玉麟  观察会员  GC1900033129  2024-03-25  私募股权、创业投资基金管理人
4861    上海涌见资产管理有限公司   张阳  观察会员  GC1900033130  2024-03-25     私募证券投资基金管理人
4862    深圳布谷资本管理有限公司  林三秀  观察会员  GC1900033131  2024-03-25     私募证券投资基金管理人
[4863 rows x 6 columns]
```

#### 基金产品

##### 私募基金管理人基金产品

接口: amac_fund_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/fund/index.html

描述: 中国证券投资基金业协会-信息公示-基金产品公示-私募基金管理人基金产品

限量: 单次返回指定页码之间的所有历史数据, 其中与每页 100 条的目标网站对应; 默认返回所有数据

输入参数

| 名称         | 类型  | 描述                    |
|------------|-----|-----------------------|
| start_page | str | start_page='1'; 开始页码  |
| end_page   | str | end_page="2000"; 结束页码 |

输出参数

| 名称        | 类型     | 描述 |
|-----------|--------|----|
| 基金名称      | object | -  |
| 私募基金管理人名称 | object | -  |
| 私募基金管理人类型 | object | -  |
| 运行状态      | object | -  |
| 备案时间      | object | -  |
| 建立时间      | object | -  |
| 托管人名称     | object | -  |

接口示例

```python
import akshare as ak

amac_fund_info_df = ak.amac_fund_info(start_page="1", end_page='100')
print(amac_fund_info_df)
```

数据示例

```
                          基金名称           私募基金管理人名称  ...        建立时间           托管人名称
0               长安万丰贯富4号资产管理计划      上海万丰友方投资管理有限公司  ...  2013-09-22  上海浦东发展银行股份有限公司
1              红塔红土基金—翼虎量化对冲二期       深圳市翼虎投资管理有限公司  ...  2013-02-08      上海银行股份有限公司
2             万家正行季季加利专项资产管理计划    歌斐诺宝（上海）资产管理有限公司  ...  2013-03-11      兴业银行股份有限公司
3           指财通基金-耀之债期1号资产管理计划  上海耀之私募基金管理中心（有限合伙）  ...  2013-11-06    中国光大银行股份有限公司
4     万家共赢歌斐诺宝精选组合3号三期专项资产管理计划    歌斐诺宝（上海）资产管理有限公司  ...  2014-01-13      宁波银行股份有限公司
                        ...                 ...  ...         ...             ...
9995          景泰复利回报第十五期证券投资基金     深圳市景泰利丰投资发展有限公司  ...  2015-04-23      交通银行股份有限公司
9996       浙商证券-望正诚朴1号私募证券投资基金        深圳望正资产管理有限公司  ...  2015-05-19      交通银行股份有限公司
9997                  持赢复利1期基金      南京持赢私募基金管理有限公司  ...  2015-05-01      南京银行股份有限公司
9998              惠正创富私募证券投资基金      广东惠正私募基金管理有限公司  ...  2015-05-27      招商证券股份有限公司
9999        恒天财富稳增金狮1号灵活策略对冲基金        恒天中岩投资管理有限公司  ...  2015-05-20      中信证券股份有限公司
[10000 rows x 7 columns]
```

##### 证券公司集合资管产品公示

接口: amac_securities_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/securities/index.html

描述: 中国证券投资基金业协会-信息公示-基金产品公示-证券公司集合资管产品公示

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称    | 类型     | 描述 |
|-------|--------|----|
| 产品名称  | object | -  |
| 产品编码  | object | -  |
| 管理人名称 | object | -  |
| 成立日期  | object | -  |
| 到期时间  | object | -  |
| 投资类型  | object | -  |
| 是否分级  | object | -  |
| 托管人名称 | object | -  |
| 备案日期  | object | -  |
| 运作状态  | object | -  |

接口示例

```python
import akshare as ak

amac_securities_info_df = ak.amac_securities_info()
print(amac_securities_info_df)
```

数据示例

```
                                  产品名称    产品编码  ...        备案日期  运作状态
0      华泰拉普拉斯家园1号科创板员工持股集合资产管理计划  SAHB48  ...  2024-04-03  正在运作
1             国泰君安君享兴盈1号集合资产管理计划  SAJN14  ...  2024-04-02  正在运作
2          方正证券满盈12M003号集合资产管理计划  SAHT72  ...  2024-04-02  正在运作
3             光证资管渝选增强1号集合资产管理计划  SAJM87  ...  2024-04-03  正在运作
4            华源证券安鑫周周盈3号集合资产管理计划  SAJN58  ...  2024-04-02  正在运作
                          ...     ...  ...         ...   ...
20286           申银万国宝鼎1期集合资产管理计划  S00792  ...  2013-05-07  正在运作
20287       东方红-先锋2号（展期）集合资产管理计划  S00052  ...  2013-05-07  正在运作
20288           光证资管添盈1号集合资产管理计划  S08647  ...  2013-08-20  正在运作
20289               中金一号集合资产管理计划  S00773  ...  2013-07-01  提前清算
20290            东方红先锋1号集合资产管理计划  S00844  ...  2013-05-07  正在运作
[20291 rows x 10 columns]
```

##### 证券公司直投基金

接口: amac_aoin_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/aoin/product/index.html

描述: 中国证券投资基金业协会-信息公示-基金产品公示-证券公司直投基金

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称    | 类型     | 描述 |
|-------|--------|----|
| 产品编码  | object | -  |
| 产品名称  | object | -  |
| 直投子公司 | object | -  |
| 管理机构  | object | -  |
| 设立日期  | object | -  |

接口示例

```python
import akshare as ak

amac_aoin_info_df = ak.amac_aoin_info()
print(amac_aoin_info_df)
```

数据示例

```
       产品编码                             产品名称  ...                  管理机构       设立日期
0    S32077            深圳市远盛发展一期股权投资企业（有限合伙）  ...         深圳市远盛投资管理有限公司 2012-12-26
1    S32105             新疆华融天泽鼎鑫投资合伙企业（有限合伙）  ...            华融天泽投资有限公司 2013-03-14
2    S32073               新疆广发信德广电夹层投资有限合伙企业  ...      新疆广发信德稳胜投资管理有限公司 2013-03-25
3    S32644             吉林省国家新材料产业创业投资有限责任公司  ...      北京一创吉星创业投资管理有限公司 2013-05-24
4    S32067                 赣州致发投资合伙企业（有限合伙）  ...        江西致远发展投资管理有限公司 2013-07-09
..      ...                              ...  ...                   ...        ...
219  S32563             桂银柳江新型城镇化城市发展契约型私募基金  ...        贵州兴黔财富资本管理有限公司 2017-06-30
220  S32630                       兴黔一号私募投资基金  ...        贵州兴黔财富资本管理有限公司 2017-07-13
221  S32557                 南宁交轨投资合伙企业（有限合伙）  ...        贵州兴黔财富资本管理有限公司 2017-10-25
222  S32565                南宁桂耀城投资合伙企业（有限合伙）  ...        贵州兴黔财富资本管理有限公司 2017-11-27
223  S32582  深圳润信新观象战略新兴产业私募股权投资基金合伙企业（有限合伙）  ...  深圳市润信新观象股权投资基金管理有限公司 2018-04-24
[224 rows x 5 columns]
```

##### 证券公司私募投资基金

接口: amac_fund_sub_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/subfund/index.html

描述: 中国证券投资基金业协会-信息公示-基金产品公示-证券公司私募投资基金

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称        | 类型     | 描述 |
|-----------|--------|----|
| 产品编码      | object | -  |
| 产品名称      | object | -  |
| 私募基金管理人名称 | object | -  |
| 托管人名称     | object | -  |
| 成立日期      | object | -  |
| 备案日期      | object | -  |

接口示例

```python
import akshare as ak

amac_fund_sub_info_df = ak.amac_fund_sub_info()
print(amac_fund_sub_info_df)
```

数据示例

```
       产品编码                        产品名称  ...       成立日期       备案日期
0     S32080          甘肃现代农业产业创业投资基金有限公司  ... 2012-12-25 2013-10-23
1     SD6315      中信并购投资基金（深圳）合伙企业（有限合伙）  ... 2012-11-15 2014-04-09
2     SD1670              中国－比利时直接股权投资基金  ... 2004-10-18 2014-04-17
3     SD1807      中投长春国家光电信息创业投资基金(有限合伙）  ... 2013-08-30 2014-04-21
4     SD2445      无锡国联领翔中小企业成长投资中心（有限合伙）  ... 2013-12-31 2014-04-22
      ...                         ...  ...        ...        ...
1687  SAGN06    中金辰盛（武汉）创业投资基金合伙企业（有限合伙）  ... 2024-01-12 2024-03-22
1688  SAHR12       温州大罗山瓯财股权投资合伙企业（有限合伙）  ... 2023-05-22 2024-03-22
1689  SAGB78   广州知城琶洲信德产业投资基金合伙企业 （有限合伙）  ... 2024-01-11 2024-03-25
1690  SAHY41  重庆荣昌创新发展私募股权投资基金合伙企业（有限合伙）  ... 2024-03-06 2024-04-03
1691  SAJJ25      广州智源和鑫创业投资基金合伙企业（有限合伙）  ... 2024-03-05 2024-04-03
[1692 rows x 6 columns]
```

##### 基金公司及子公司集合资管产品公示

接口: amac_fund_account_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/fund/account/index.html

描述: 中国证券投资基金业协会-信息公示-基金产品公示-基金公司及子公司集合资管产品公示

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称    | 类型     | 描述 |
|-------|--------|----|
| 成立日期  | object | -  |
| 产品编码  | object | -  |
| 产品名称  | object | -  |
| 管理人名称 | object | -  |

接口示例

```python
import akshare as ak

amac_fund_account_info_df = ak.amac_fund_account_info()
print(amac_fund_account_info_df)
```

数据示例

```
         成立日期    产品编码                         产品名称           管理人名称
0     2024-04-02  SAHT40          建信尊享吉康一年13号集合资产管理计划    建信基金管理有限责任公司
1     2024-04-01  SAJA72  华夏资本-AU9999龙腾宁惠跃享6号集合资产管理计划      华夏资本管理有限公司
2     2024-03-29  SAJL52            创金合信创力20号集合资产管理计划    创金合信基金管理有限公司
3     2024-03-29  SAJD21          招商财富-丰利联动1号集合资产管理计划    招商财富资产管理有限公司
4     2024-03-29  SACX99             创金合信聚睿6号集合资产管理计划    创金合信基金管理有限公司
          ...     ...                          ...             ...
38244        NaT  S93786              千石资本-天演5期资产管理计划  北京千石创富资本管理有限公司
38245        NaT  ST3713        汇添富资本-添添富理财7天专项资产管理计划     汇添富资本管理有限公司
38246        NaT  S88308         金元惠理江阴首府花园1号专项资产管理计划  上海金元百利资产管理有限公司
38247        NaT  S92026          中银资产-信利系列5号专项资产管理计划      中银资产管理有限公司
38248        NaT  S88283         金元惠理延安保障房12号专项资产管理计划  上海金元百利资产管理有限公司
[38249 rows x 4 columns]
```

##### 资产支持专项计划

接口: amac_fund_abs

目标地址: https://gs.amac.org.cn/amac-infodisc/res/fund/abs/index.html

描述: 中国证券投资基金业协会-信息公示-产品公示-资产支持专项计划

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称     | 类型     | 描述 |
|--------|--------|----|
| 编号     | int64  | -  |
| 备案编号   | object | -  |
| 专项计划全称 | object | -  |
| 管理人    | object | -  |
| 托管人    | object | -  |
| 成立日期   | object | -  |
| 预期到期时间 | object | -  |
| 备案通过时间 | object | -  |

接口示例

```python
import akshare as ak

amac_fund_abs_df = ak.amac_fund_abs()
print(amac_fund_abs_df)
```

数据示例

```
      编号  备案编号  ...   预期到期时间  备案通过时间
0        1  S29340  ...  2018-02-15  2015-04-23
1        2  S33309  ...  2020-01-22  2015-04-23
2        3  S33578  ...  2020-04-14  2015-05-07
3        4  S33490  ...  2020-04-13  2015-05-07
4        5  S34510  ...  2022-03-25  2015-05-07
    ...     ...  ...         ...         ...
8335  8336  S37011  ...  2020-05-19  2015-06-07
8336  8337  S38847  ...  2018-05-17  2015-06-07
8337  8338  S39153  ...  2018-03-07  2015-06-07
8338  8339  S38598  ...  2017-05-18  2015-06-07
8339  8340  S37663  ...  2016-08-21  2015-06-07
[8340 rows x 8 columns]
```

##### 期货公司集合资管产品公示

接口: amac_futures_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/pof/futures/index.html

描述: 中国证券投资基金业协会-信息公示-基金产品公示-期货公司集合资管产品公示

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称    | 类型     | 描述 |
|-------|--------|----|
| 产品名称  | object | -  |
| 产品编码  | object | -  |
| 管理人名称 | object | -  |
| 托管人名称 | object | -  |
| 成立日期  | object | -  |
| 投资类型  | object | -  |
| 是否分级  | object | -  |
| 备案日期  | object | -  |
| 到期日   | object | -  |
| 运作状态  | object | -  |

接口示例

```python
import akshare as ak

amac_futures_info_df = ak.amac_futures_info()
print(amac_futures_info_df)
```

数据示例

```
              产品名称    产品编码       管理人名称  ...        备案日期         到期日  运作状态
0          大越期货高益集合资产管理计划  SAGG91  大越期货股份有限公司  ...  2024-04-03  2034-03-25  正在运作
1        大地期货新辰一号集合资产管理计划  SAHK47    大地期货有限公司  ...  2024-03-28  2029-03-26  正在运作
2        冠通资管兆享7号集合资产管理计划  SAHR85  冠通期货股份有限公司  ...  2024-04-03  2029-03-24  正在运作
3        盛达期货鑫鼎1号集合资产管理计划  SAHX81    盛达期货有限公司  ...  2024-04-01  2030-03-21  正在运作
4        华鑫期货鑫诚一号集合资产管理计划  SAFX88    华鑫期货有限公司  ...  2024-03-26  2039-03-18  正在运作
                   ...     ...         ...  ...         ...         ...   ...
9643       浙商期货春晓1号资产管理计划  S24005    浙商期货有限公司  ...  2015-05-21  2016-01-06  正常清算
9644      浙商多策略精选2号资产管理计划  S24001    浙商期货有限公司  ...  2015-05-12  2015-12-24  正常清算
9645       新湖资管稳健1号资产管理计划  S24002  新湖期货股份有限公司  ...  2015-06-01  2034-12-23  正在运作
9646  海证期货巨杉净值线1号集合资产管理计划  S94010    海证期货有限公司  ...  2014-06-03  2033-09-04  正在运作
9647      美尔雅-北极星1号资产管理计划  S30147    正信期货有限公司  ...  2015-06-04  2016-04-20  正常清算
[9648 rows x 10 columns]
```

#### 诚信信息

##### 已注销私募基金管理人名单

接口: amac_manager_cancelled_info

目标地址: https://gs.amac.org.cn/amac-infodisc/res/cancelled/manager/index.html

描述: 中国证券投资基金业协会-信息公示-诚信信息-已注销私募基金管理人名单

限量: 单次返回当前时刻所有历史数据

输入参数

| 名称 | 类型 | 描述 |
|----|----|----|
| -  | -  | -  |

输出参数

| 名称       | 类型     | 描述 |
|----------|--------|----|
| 管理人名称    | object | -  |
| 统一社会信用代码 | object | -  |
| 登记时间     | object | -  |
| 注销时间     | object | -  |
| 注销类型     | object | -  |

接口示例

```python
import akshare as ak

amac_manager_cancelled_info_df = ak.amac_manager_cancelled_info()
print(amac_manager_cancelled_info_df)
```

数据示例

```
           管理人名称            统一社会信用代码        登记时间        注销时间  注销类型
0        北京国民信和投资基金有限公司          05559209-0  2014-05-26  2015-04-07   100
1            湖南海盟投资有限公司          68501913-3  2014-05-26  2015-04-07   100
2      广元友利股权投资基金管理有限公司          07144608-5  2014-11-26  2015-04-07   100
3        上海骏福股权投资基金有限公司          06784881-5  2014-06-04  2015-04-07   100
4        上海清科凯盛投资管理有限公司          59312920-4  2014-04-23  2015-04-07   100
                 ...                 ...         ...         ...   ...
22267      上海津尧资产管理有限公司          34224529-4  2015-07-30  2024-04-02   100
22268     深圳市清江基金管理有限公司  91440300335206596E  2017-07-12  2024-04-02   100
22269      苏州宝时投资管理有限公司          31419103-0  2014-11-19  2024-04-03   100
22270     深圳市禾瑞股权投资有限公司  91440300MA5D9XA002  2017-01-23  2024-04-03   100
22271  中楚私募基金管理（海南）有限公司  91460200MAA95MYA9Q  2023-04-03  2024-04-04   200
[22272 rows x 5 columns]
```
