# Awesome Engineering Strategy [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> 🎉 How to design and execute engineering strategies for tech leadership.

Engineering Strategy is a composition of resources such books, posts, templates, learning materials, and open engineering strategies made by the community and companies.

Contributions are welcome! Check out the contribution guidelines for adding items to the list.

## Contents

- [Books](#books)
- [Posts](#posts)
- [Videos](#videos)
- [Methods](#methods)
- [Courses and Workshops](#courses-and-workshops)
- [Templates](#templates)
- [Supporting Material](#supporting-material)
- [Open Engineering Strategies](#open-engineering-strategies)
- [Communities](#communities)
- [Podcasts](#podcasts)

## Books

- [Strategic Monoliths and Microservices: Driving Innovation Using Purposeful Architecture](https://www.goodreads.com/book/show/55782292-strategic-monoliths-and-microservices) - A set of strategic patterns on addressing business capabilities with a monolith and microservices approach.
- [Technology Strategy Patterns: Architecture as Strategy](https://www.goodreads.com/book/show/42414767-technology-strategy-patterns) - A set of business tools and patterns from an engineering point of view.
- [Staff Engineer: Leadership Beyond the Management Track](https://www.goodreads.com/book/show/56481725-staff-engineer) - How is the role of the staff engineer and how this role addresses the engineering strategy.
- [Reaching Cloud Velocity: A Leader's Guide to Success in the AWS Cloud](https://www.goodreads.com/book/show/53503300-reaching-cloud-velocity) - A high-level book on business strategy, people, culture, data and architecture and how this drives cloud velocity.
- [UN Global Platform Handbook on Information Technology Strategy](https://www.goodreads.com/book/show/55047345-un-global-platform-handbook-on-information-technology-strategy) - A set of wardley maps on IT. Bringing situational awareness to different contexts.
- [Good Strategy Bad Strategy: The Difference and Why It Matters](https://www.goodreads.com/en/book/show/11721966) - Understand the core components of a strategy.
- [The Value Flywheel Effect: Power the Future and Accelerate Your Organization to the Modern Cloud](https://www.goodreads.com/book/show/61167316-the-value-flywheel-effect?ac=1&from_search=true&qid=donxleC2tR&rank=1) - Using Wardley Mapping and other sensemaking approaches to help organizations anticipate market changes and user needs.
- [Team Topologies: Organizing Business and Technology Teams for Fast Flow](https://www.goodreads.com/book/show/44135420-team-topologies) - Team Topologies is a practical, step-by-step, adaptive model for organizational design and team interaction based on four fundamental team types and three team interaction patterns.
- [Thinking in Systems](https://www.goodreads.com/book/show/3828902-thinkingow-in-systems) - An essential introduction into system thinking. It helps the reader to understand the fundamentals and introduces several system traps and how to overcome them.
- [Domain-Driven Design: Tackling Complexity in the Heart of Software](https://www.goodreads.com/book/show/179133.Domain_Driven_Design) - Strategic patterns to understand complex domains and how to model them based on the impact on the business competitive advantage.
- [Implementing Domain-Driven Design](https://www.goodreads.com/book/show/15756865-implementing-domain-driven-design) - An implementation approach to DDD from strategic patterns to tactical patterns with code examples.
- [Domain-Driven Design Distilled](https://www.goodreads.com/book/show/28602719-domain-driven-design-distilled) - An accessible book to learn the main concepts of Domain-Driven Design.
- [Wardley Maps](https://medium.com/wardleymaps/on-being-lost-2ef5f05eb1ec) - A deep explanation of the origin of Wardley Maps up to the full understanding of how to do strategy which it is adaptive to the environment. 
- [Architecture Modernization. Socio-technical alignment of software, strategy, and structure](https://www.manning.com/books/architecture-modernization) - Concrete tools, techniques, and processes to align software architecture with your business domains, organizational design, team topologies, and corporate strategy.
- [Effective Platform Engineering](https://www.manning.com/books/effective-platform-engineering) - A book about designing, building, deploying, and scaling a custom Internal Development Platforms (IDP).

## Posts

- [Designing an Engineering Strategy Post Series](https://learnings.aleixmorgadas.dev/p/designing-an-engineering-strategy) - How to build an engineering strategy from 0.
- [Engineering strategy](https://lethain.com/engineering-strategy/) - What's an engineering strategy.
- [Defining a Tech Strategy](https://sarahtaraporewalla.com/agile/design/architecture/Defining-a-Tech-Strategy) - A high-level guideline on defining a tech strategy.
- [Tech Strategy: You Need it, But What is it?](https://medium.com/nick-tune-tech-strategy-blog/tech-strategy-you-need-it-but-what-is-it-af292421e422) - In-depth reflection of what is a tech strategy. 
- [🗺🧭 Using Wardley Mapping to understand why Google made G. Appointments to compete in the Calendly market](https://learnings.aleixmorgadas.dev/p/-using-wardley-mapping-to-understand) - Using wardley mapping to understand google appointments.
- [What is a Strategy? Why do you need one in Tech?](https://www.linkedin.com/pulse/what-strategy-why-do-you-need-one-tech-rui-felgueiras) - Introduction to what is a strategy for tech.
- [Delivering on an Architecture Strategy](https://blog.thepete.net/blog/2019/12/09/delivering-on-an-architecture-strategy/) - Describes strategic architectural initiatives, a framework which allowing product peeps and techies to make progress on big technical improvements via aligned autonomy.
- [ADR: Deep Dive into Architecture Decision Records](https://okorkmaz.medium.com/adr-deep-dive-into-architecture-decision-records-8c110ce7d74e) - Introduces what an architecture decision record is, describes the terminology, how to document the finalized architecture, and focuses on the best practices by presenting real scenerio.
- [Strategy glossary](https://alexewerlof.substack.com/p/strategy-glossary) - Building a common language for vision, mission, goals, objectives, roadmap, plans, milestones, policies.
- [Strategy basics](https://alexewerlof.substack.com/p/strategy-basics) - First in a series of posts about strategy why, how and what.
- [Writing an engineering strategy](https://lethain.com/eng-strategies/) - A guide on how to write and document an engineering strategy.
- [Architecture Modernization Enabling Teams (AMET)](https://esilva.net/articles/architecture-modernization-enabling-team) - Explains how AMET coordinates and upskills all teams and stakeholders in the modernization initiative.
- [When and when *not* to do an engineering strategy](https://learnings.aleixmorgadas.dev/p/when-and-when-not-to-do-an-engineering) - Using Cynefin Framework, it shares in which domains designing an engineering strategy makes more sense compared to just execute.
- [Emergent Platform and Evolution in Sociotechnical Systems](https://esilva.net/articles/emergent-platforms) - How platforms emerge from business challenges and the different types of teams like enabling and platform teams collaborate with stream-aligned teams to create the space and opportunities for platforms to evolve.
- [Interim Platform Teams](https://learnings.aleixmorgadas.dev/p/interim-platform-team) - When a stream-aligned team starts supporting internal customers and acting as an interim platform team. How to deliver a great internal experience while delivering features for external clients.
- [Creating an integrated business and technology strategy](https://martinfowler.com/articles/creating-integrated-tech-strategy.html) - Eleven prevalent strategic directions that organisations traverse with examples.
- [Solving the Engineering Strategy crisis](https://lethain.com/solving-the-engineering-strategy-crisis/) - A unified theory of Engineering strategy, with a particular emphasis on how you can drive strategy.
- [Engineering Strategy is a Fractal](https://learnings.aleixmorgadas.dev/p/engineering-strategy-is-a-fractal) - How to apply organization engineering strategy to the local context while keeping aligned with organization goals.
- [Engineering strategy notes](https://lethain.com/strategy-notes/) - A collection of links on the topic gathered.
- [Engineering strategy is more similar to poker than to chess](https://learnings.aleixmorgadas.dev/p/engineering-strategy-is-more-similar) - A comparison of chess and poker games and how they relate to engineering strategy.
- [The outcome of the strategy becomes culture](https://learnings.aleixmorgadas.dev/p/the-outcome-of-the-strategy-becomes) - Culture guides and constrains your strategy. Using strategy to influence your culture.
- [What's your engineering strategy?](https://www.linkedin.com/pulse/whats-your-engineering-strategy-pt-1-pat-cullen-cwjqe/) - Multi-part strategy guide with specific templates you can deploy rapidly in your organization.
- [Combining Engineering Strategy with the North Star Framework ⭐](https://learnings.aleixmorgadas.dev/p/combining-engineering-strategy-with) - How to combine an engineering strategy with the north star framework to be guided by actionable metrics.
- [Engineering strategy beyond good and best practices](https://learnings.aleixmorgadas.dev/p/engineering-strategy-beyond-good) - How only investing on good and best engineering practices won't position your company ahead of the competition that makes context specific decisions.
- [You need to understand the business to design a good engineering strategy](https://learnings.aleixmorgadas.dev/p/you-need-to-understand-the-business) - A set of relevant aspects of the business that help people to have a broader understanding to improve their engineering strategy with a set of questions to ask to the domain experts.
- [Basal Cost of software](https://www.eferro.net/2021/02/basal-cost-of-software.html) - How the basal cost, composed of direct impact on team capacity of the added complexity and the cost of the  development or evolution of other features, affects the existing systems and teams to deliver value.
- [Dealing with teams with competing priorities and needs](https://learnings.aleixmorgadas.dev/p/dealing-with-teams-with-competing) - An engineering strategy example of how to deal with teams with competing priorities.

## Videos

- [Experimentation and Evolution with Wardley Maps](https://www.youtube.com/watch?v=gAh7rK2F9pk) - How Cat has used Wardley Maps to inform her always evolving strategy for the modernization of Ticketmaster’s core ticketing platform not only in terms of technical capabilities and architecture but also process maturity, organizational design, and more.
- [Crossing the River by Feeling the Stones](https://www.youtube.com/watch?v=oZZKjxeg5W0) - Simon Wardley examines the issue of situational awareness and explains how it applies to technology.
- [Complex Adaptive Systems](https://www.youtube.com/watch?v=l4-vpegxYPg) - How to understand and categorize domains into ordered, complicated, complex, and chaotic, and how to navigate them.
- [Systems are communication structures](https://www.youtube.com/watch?v=U_0B-aY_L0c) - Understand how communication within an organization creates patterns that repeat themselves and scale up to the organization.
- [Whole Work: Sociotechnicity & DevOps](https://www.youtube.com/watch?v=WtfncGAeXWU) - How to understand the present to design a better present that will create better futures from a system thinking perspective.

## Methods

- [User Needs Mapping](https://userneedsmapping.com/) - An approach combining the essentials of Wardley Mapping with Team Topologies with a strong focus on user needs.

## Courses and Workshops

- [Pragmatic Wardley Mapping](https://learn.hiredthought.com/p/wardley-mapping) - An online course to introduce people into Wardley Mapping.
- [Implementing Domain-Driven Design](https://kalele.io/training/iddd/) - Hands-on exercises show you how to use DDD strategic and tactical design in your implementations.
- [Fast Flow of Change](https://kalele.io/fast-flow-of-change/) - Combining Wardley Mapping, DDD & Team Topologies, this workshop will help you to design for adaptability.
- [Engineering Strategy Workshop](https://aleixmorgadas.dev/workshops/engineering-strategy) - Introduction to engineering strategy theory and components.
- [Strategy for Technical Leaders Masterclass](https://ruthmalan.com/Bredemeyer/Strategy_Masterclass_Overview.htm) - This masterclass builds on our work with software, system and enterprise architects and product, program and executive managers including CTOs and CIOs.

## Templates

- [Engineering Strategy Notion Template](https://aleixmorgadas.notion.site/Engineering-Strategy-Template-910ad428d3d14c5a9aef4a4c32c4a8ba) - A template with the core elements of an engineering strategy, the high-stake problem, the understanding phase, the direction, and coherent actions.

## Supporting material

- [Context mapping](https://github.com/ddd-crew/context-mapping) - Visualize the contract between bounded contexts and teams with a collection of patterns.
- [Core domain charts](https://github.com/ddd-crew/core-domain-charts) - Help you to visualise the strategic importance of each (sub)domain or business capability in your architecture allowing you to make business model-aligned architectural decisions.

## Open Engineering Strategies

> Open Engineering Strategies section aims to provide a relevant set of public available Engineering Strategies so we can learn from each other.

- [Community Startup](https://learnings.aleixmorgadas.dev/p/community-startup-engineering-strategy?s=w) - Prove product market fit with an MVP.
- [GitLab Strategy](https://about.gitlab.com/company/strategy/) - Complete GitLab three-year strategy. Containing direction, customer focus, and team dynamics.
- [Flutter in 2022 Strategy](https://flutter.dev/go/strategy-2022) - Flutter annual strategy document for 2022.
- [Gitpod Strategy](https://gitpod.notion.site/Gitpod-s-Direction-be35d064c0704fbda61c542b84e07ef6) - Gitpod purpose, vision, and strategy.
- [Qatium Product Market Fit](https://learnings.aleixmorgadas.dev/p/post-product-market-fit-open-engineering) - An engineering strategy when the product verifies product market fit and the engineering isn't evolving the practices to match the new product needs.
- [Mobile onboarding evolution at Flo Health](https://learnings.aleixmorgadas.dev/p/mobile-onboarding-evolution-at-flo) - An engineering strategy to enable fast experimentation during the onboarding for a B2C application.

## Communities

- [Engineering Strategy on Discord](https://discord.gg/mebRYrNamF) - Discord community focused on Engineering Strategy.

## Podcasts

- [Engineering Strategy Podcast](https://open.spotify.com/show/2o8lWLvV9O0P2Gf9J6xzLo?si=049c9a2c90924aa7) - Engineering strategy interviews to tech leaders in English and Spanish by Aleix Morgadas.
- [Tech Lead Journal](https://techleadjournal.dev/) - A podcast by Henry Suryawirawan where experienced technical leaders share the often undefined, beyond-the-code skills that shaped their journeys.
