# Awesome Omarchy [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of awesome Omarchy themes, resources, and tools for the modern Arch Linux/Hyprland setup.

[Omarchy](https://omarchy.org/) is an opinionated Arch Linux/Hyprland configuration that transforms a fresh Arch installation into a fully-configured, beautiful, and modern desktop environment with a single command.

## Contents

- [Official Resources](#official-resources)
- [Alternative Implementations](#alternative-implementations)
- [Themes](#themes)
- [Development Tools](#development-tools)
- [Related Projects](#related-projects)
- [Alternative Curated Lists](#alternative-curated-lists)
- [Community Resources](#community-resources)
- [Articles and Tutorials](#articles-and-tutorials)

## Official Resources

- [Omarchy](https://github.com/basecamp/omarchy) - The main Omarchy project by Basecamp.
- [Omarchy Documentation](https://learn.omacom.io/2/the-omarchy-manual) - Official website with installation guides and documentation.

## Alternative Implementations

- [armarchy](https://github.com/nilszeilon/armarchy) - ARM architecture-optimized fork of Omarchy.
- [deckarchy](https://github.com/aorumbayev/deckarchy) - Steam Deck hardware fixes and optimizations for Omarchy installation.
- [Fedpunk](https://github.com/hinriksnaer/Fedpunk) - Omarchy-based desktop configuration and modular theming engine for Fedora.
- [hyprwhspr](https://github.com/goodroot/hyprwhspr) - Native speech-to-text for Arch / Omarchy - Fast, accurate and easy system-wide Whisper dictation.
- [Okimarchy](https://github.com/cristian-fleischer/okimarchy) - An Omarchy fork that adds support for niri window manager alongside Hyprland, with runtime switching and unified theming.
- [omadora](https://github.com/elpritchos/omadora) - Minimal Fedora install based on Omarchy.
- [omarchy-cachyos](https://github.com/lentra0/omarchy-cachyos) - Opinionated CachyOS/Hyprland Setup.
- [omarchy-nix](https://github.com/henrysipp/omarchy-nix) - NixOS version of Omarchy with declarative configuration.
- [omarchy-on-cachyos](https://github.com/mroboff/omarchy-on-cachyos) - Installation script for Omarchy on top of CachyOS.
- [omarchy-titus](https://github.com/ChrisTitusTech/omarchy-titus) - Chris Titus Tech's customized version of Omarchy.
- [typecraft-dev/omarchy-supplement](https://github.com/typecraft-dev/omarchy-supplement) - Additional packages, dotfiles, and overrides to be used after installing Omarchy.
- [harilvfs/omarchy](https://github.com/harilvfs/omarchy) - Opinionated Arch/Hyprland Setup.
- [omarchy-hub](https://github.com/deepakness/omarchy-hub) - A comprehensive resource library for Omarchy Linux.

## Themes

- [aetheria](https://github.com/JJDizz1L/aetheria) - Ethereal and modern theme with balanced aesthetics.
- [omarchy-aamis-theme](https://github.com/vyrx-dev/omarchy-aamis-theme) - Near‑black canvas, creamy text.
- [omarchy-alabaster-theme](https://github.com/grierson/omarchy-alabaster-theme) - Alabaster theme with clean, minimalist design.
- [omarchy-akane-theme](https://github.com/Grenish/omarchy-akane-theme) - Akane theme with Japanese-inspired colors.
- [omarchy-agentuity.theme](https://github.com/rblalock/omarchy-agentuity.theme) - Agentuity-inspired theme with professional color palette.
- [omarchy-all-hallows-eve-theme](https://github.com/guilhermetk/omarchy-all-hallows-eve-theme) - Dark Halloween-inspired theme with spooky aesthetics.
- [omarchy-amberbyte-theme](https://github.com/tahfizhabib/omarchy-amberbyte-theme) - Modern, animated, and minimal theme with amber accents.
- [omarchy-ash-theme](https://github.com/bjarneo/omarchy-ash-theme) - Subtle ash-gray color scheme.
- [omarchy-aura-theme](https://github.com/bjarneo/omarchy-aura-theme) - Aura theme providing visually appealing configuration set.
- [omarchy-ayaka-theme](https://github.com/abhijeet-swami/omarchy-ayaka-theme) - Minimalist theme with glass-like blur effects and vibrant accents.
- [omarchy-ayu-mirage-theme](https://github.com/fdidron/omarchy-ayumirage) - Ayu Mirage color scheme adaptation with balanced contrast.
- [omarchy-azure-glow-theme](https://github.com/Hydradevx/omarchy-azure-glow-theme) - Azure blue theme with glowing accents.
- [omarchy-bauhaus-theme](https://github.com/somerocketeer/omarchy-bauhaus-theme) - Minimalist theme inspired by Bauhaus design principles.
- [omarchy-batou-theme](https://github.com/HANCORE-linux/omarchy-batou-theme) - Moody theme inspired by Batou's car and iconic opening scene aesthetics.
- [omarchy-blackgold-theme](https://github.com/HANCORE-linux/omarchy-blackgold-theme) - Sleek black-and-gold theme with luxurious aesthetics.
- [omarchy-blackmoney-theme](https://github.com/HANCORE-linux/omarchy-blackmoney-theme) - Bold midnight theme with rich green-gold accents.
- [omarchy-blackturq-theme](https://github.com/HANCORE-linux/omarchy-blackturq-theme) - Black turquoise theme based on Evo80 keyboard color pattern.
- [omarchy-blueridge-dark-theme](https://github.com/hipsterusername/omarchy-blueridge-dark-theme) - Dark theme inspired by mountain ridge aesthetics.
- [omarchy-cobalt2-theme](https://github.com/hoblin/omarchy-cobalt2-theme) - Cobalt2 theme inspired by the iconic VSCode theme.
- [omarchy-crimson-gold-theme](https://github.com/knappkevin/omarchy-crimson-gold-theme) - Luxurious crimson and gold color combination.
- [omarchy-doom-theme](https://github.com/AX200M/omarchy-doom-theme) - Material theme inspired by MF DOOM wallpaper.
- [omarchy-dracula-theme](https://github.com/catlee/omarchy-dracula-theme) - Popular Dracula theme adaptation.
- [omarchy-delorean-theme](https://github.com/jbnunn/omarchy-delorean-theme) - Retro-inspired time traveler's theme.
- [omarchy-ember-n-ash-theme](https://github.com/Hydradevx/omarchy-ember-n-ash-theme) - Warm ember orange and ash gray color combination.
- [omarchy-elysian-theme](https://github.com/bjarneo/omarchy-elysian-theme) - Mythical forest theme with golden-green light and high-contrast workspace.
- [omarchy-everblush-theme](https://github.com/Swarnim114/omarchy-everblush-theme) - Everblush color scheme adaptation.
- [omarchy-evergarden-theme](https://github.com/celsobenedetti/omarchy-evergarden) - Evergarden theme with lush greens and soft pastels.
- [omarchy-felix-theme](https://github.com/TyRichards/omarchy-felix-theme) - Clean theme with balanced colors and modern design.
- [omarchy-fiery-ocean-theme](https://github.com/bjarneo/omarchy-fiery-ocean-theme) - Fiery Ocean theme with vibrant aquatic colors.
- [omarchy-flexoki-dark-theme](https://github.com/euandeas/omarchy-flexoki-dark-theme) - Flexoki color palette adaptation.
- [omarchy-flexoki-light-theme](https://github.com/euandeas/omarchy-flexoki-light-theme) - Light version of Flexoki color palette.
- [omarchy-forest-green-theme](https://github.com/abhijeet-swami/omarchy-forest-green-theme) - Nature-inspired forest green color scheme.
- [omarchy-futurism-theme](https://github.com/bjarneo/omarchy-futurism-theme) - Futuristic theme with modern aesthetics.
- [omarchy-gold-rush-theme](https://github.com/tahayvr/omarchy-gold-rush-theme) - Luxurious gold-themed color scheme.
- [omarchy-gtk-theme](https://github.com/bjarneo/omarchy-gtk-theme) - Universal GTK styling to match Omarchy across applications.
- [omarchy-green-garden-theme](https://github.com/kalk-ak/omarchy-green-garden-theme) - Fresh and calming theme inspired by nature with vibrant yet soothing green tones.
- [omarchy-harbor-theme](https://github.com/HANCORE-linux/omarchy-harbor-theme) - Calm, paper-light color scheme with cool ink accents inspired by Nordic tones.
- [omarchy-harbordark-theme](https://github.com/HANCORE-linux/omarchy-harbordark-theme) - Dark version of Harbor theme with deep tones and cool accents.
- [omarchy-hollow-knight-theme](https://github.com/bjarneo/omarchy-hollow-knight-theme) - Hollow Knight inspired theme with gaming aesthetics.
- [omarchy-hook-theme-set-ex](https://github.com/imbypass/omarchy-hook-theme-set-ex) - Modular interpretation of the Omarchy theme-set hook.
- [omarchy-inkypinky-theme](https://github.com/HANCORE-linux/omarchy-inkypinky-theme) - Bold meets blush in a swirl of creative elegance.
- [omarchy-kimiko-theme](https://github.com/krymzonn/omarchy-kimiko-theme) - Elegant theme with Japanese-inspired aesthetics.
- [omarchy-mars-theme](https://github.com/steve-lohmeyer/omarchy-mars-theme) - Mars-inspired red theme.
- [omarchy-mechanoonna-theme](https://github.com/HANCORE-linux/omarchy-mechanoonna-theme) - Mecha no Onna (メカの女) the "Metal Woman" theme.
- [omarchy-matte-black](https://github.com/tahayvr/omarchy-matte-black) - Sleek matte black theme for minimalists.
- [omarchy-midnight-theme](https://github.com/JaxonWright/omarchy-midnight-theme) - Dark midnight theme optimized for OLED displays.
- [omarchy-milkmatcha-light-theme](https://github.com/hipsterusername/omarchy-milkmatcha-light-theme) - Light theme with soft matcha green and creamy colors.
- [omarchy-monochrome-theme](https://github.com/Swarnim114/omarchy-monochrome-theme) - Clean monochrome design.
- [omarchy-moodpeak-theme](https://github.com/HANCORE-linux/omarchy-moodpeak-theme) - Mood-lifting theme designed to pull you back to peak focus.
- [omarchy-nes-theme](https://github.com/bjarneo/omarchy-nes-theme) - Retro NES theme with nostalgic gaming aesthetics.
- [omarchy-nagai-twilight-theme](https://github.com/somerocketeer/omarchy-nagai-twilight-theme) - Twilight-inspired theme with elegant color transitions.
- [omarchy-one-dark-pro-theme](https://github.com/sc0ttman/omarchy-one-dark-pro) - One Dark Pro color scheme adaptation.
- [omarchy-osaka-jade-theme](https://github.com/Justikun/omarchy-osaka-jade-theme) - Elegant jade-colored theme inspired by Osaka aesthetics.
- [omarchy-purplewave-theme](https://github.com/dotsilva/omarchy-purplewave-theme) - Purple wave-inspired theme with elegant purple tones.
- [omarchy-retropc-theme](https://github.com/rondilley/omarchy-retropc-theme) - Nostalgic retro PC theme with vintage computing aesthetics.
- [omarchy-retro-fallout-theme](https://github.com/zdravkodanailov7/omarchy-retro-fallout-theme) - Post-apocalyptic theme with Vault-inspired colors and Fallout-themed styling.
- [omarchy-rose-pine-dark](https://github.com/guilhermetk/omarchy-rose-pine-dark) - Rose Pine inspired dark theme.
- [omarchy-serenity-theme](https://github.com/bjarneo/omarchy-serenity-theme) - Serenity theme with calm and peaceful color scheme.
- [omarchy-shadesofjade-theme](https://github.com/HANCORE-linux/omarchy-shadesofjade-theme) - Serene green-toned theme.
- [omarchy-snow-theme](https://github.com/bjarneo/omarchy-snow-theme) - Snow theme with clean winter-inspired aesthetics.
- [omarchy-solarized-light-theme](https://github.com/dfrico/omarchy-solarized-light-theme) - Light version of Solarized color scheme.
- [omarchy-solarized-osaka-theme](https://github.com/motorsss/omarchy-solarizedosaka-theme) - Solarized theme with Osaka-inspired modifications.
- [omarchy-solarized-theme](https://github.com/Gazler/omarchy-solarized-theme) - Classic Solarized color scheme adaptation.
- [omarchy-space-monkey-theme](https://github.com/TyRichards/omarchy-space-monkey-theme) - Space-inspired theme with cosmic elements.
- [omarchy-spectra-theme](https://github.com/abhijeet-swami/omarchy-spectra-theme) - Blur and transparency theme that adapts to any wallpaper.
- [omarchy-sunset-drive-theme](https://github.com/tahayvr/omarchy-sunset-drive-theme) - Sunset-inspired theme with warm gradients.
- [omarchy-synthwave84-theme](https://github.com/omacom-io/omarchy-synthwave84-theme) - Synthwave 84 inspired theme with retro aesthetics.
- [omarchy-thegreek-theme](https://github.com/HANCORE-linux/omarchy-thegreek-theme) - Sleek, strategic spy theme blending classic espionage with modern intrigue.
- [omarchy-velocity-theme](https://github.com/perfektnacht/omarchy-velocity-theme) - Dynamic theme with speed-inspired design elements.
- [omarchy-velvetnight-theme](https://github.com/HANCORE-linux/omarchy-velvetnight-theme) - Dark, night-inspired theme with soft contrasts and subtle glimmers.
- [omarchy-vesper-theme](https://github.com/thmoee/omarchy-vesper-theme) - Dark theme with warm vesper-orange highlights.
- [omarchy-vhs80-theme](https://github.com/tahayvr/omarchy-vhs80-theme) - Retro VHS-inspired theme with 80s aesthetics and neon colors.
- [omarchy-void-theme](https://github.com/vyrx-dev/omarchy-void-theme.git) - Low-contrast purple theme with soft accents for a calm UI.
- [omarchy-wasteland-theme](https://github.com/perfektnacht/omarchy-wasteland-theme) - Post-apocalyptic wasteland-inspired color scheme.
- [omarchy-whitegold-theme](https://github.com/HANCORE-linux/omarchy-whitegold-theme) - Light and elegance intertwined with gold accents.
- [omarchy-waveform-dark-theme](https://github.com/hipsterusername/omarchy-waveform-dark-theme) - Dark theme with waveform-inspired design patterns.
- [omarchy-motivator-theme](https://github.com/rondilley/omarchy-motivator-theme) - Omarchy Theme for maximum motivation.
- [omarchy-archriot-theme](https://github.com/CyphrRiot/omarchy-archriot-theme) - ArchRiot theme for Omarchy by CyphrRiot.
- [omarchy-arc-blueberry](https://github.com/vale-c/omarchy-arc-blueberry) - Arc Blueberry inspired colors tailored for Omarchy.
- [omarchy-ayu-dark-theme](https://github.com/fdidron/omarchy-ayu-dark-theme) - Omarchy Ayu Dark Theme.
- [omarchy-ayu-light-theme](https://github.com/fdidron/omarchy-ayu-light-theme) - Omarchy Ayu Light Theme.
- [omarchy-github-light-theme](https://github.com/ryanyogan/omarchy-github-light-theme) - GitHub Light theme adaptation.
- [omarchy-night-owl-theme](https://github.com/maxberggren/omarchy-night-owl-theme) - Dark blue night owl theme for Omarchy.
- [omarchy-catppuccin-mocha-theme](https://github.com/KidDogDad/omarchy-catppuccin-mocha-theme) - Catppuccin Mocha theme for Omarchy.
- [omarchy-kanagawa-dragon-theme](https://github.com/MrTrigger/omarchy-kanagawa-dragon-theme) - Kanagawa Dragon theme adaptation.
- [omarchy-monokai-dark-theme](https://github.com/ericrswanny/omarchy-monokai-dark-theme) - Monokai inspired dark theme.
- [omarchy-monokai-theme](https://github.com/bjarneo/omarchy-monokai-theme) - High-contrast Monokai Pro inspired variant.
- [omarchy-obsidian-theme](https://github.com/Hydradevx/omarchy-obsidian-theme) - Obsidian-inspired dark theme.
- [omarchy-rose-pine-dawn-theme](https://github.com/ryanyogan/omarchy-rose-pine-dawn-theme) - Rose Pine Dawn light theme.
- [omarchy-rose-pine](https://github.com/guilhermetk/omarchy-rose-pine) - Rose Pine theme for Omarchy.
- [omarchy-anonymous-theme](https://github.com/j4v3l/omarchy-anonymous-theme) - Minimalist monochrome modern theme.
- [omarchy-firesky-theme](https://github.com/bjarneo/omarchy-firesky-theme) - Fire-lit sky inspired theme for deep focus.
- [omarchy-wood-theme](https://github.com/bjarneo/omarchy-wood-theme) - Natural wood-inspired theme.
- [omarchy-pulsar-theme](https://github.com/bjarneo/omarchy-pulsar-theme) - Vibrant, cosmic-inspired dark theme for Omarchy that captures the brilliant energy of neutron stars.
- [omarchy-pina-theme](https://github.com/bjarneo/omarchy-pina-theme) - Tropical pineapple-inspired palette with warm accents.
- [pink-blood-omarchy-theme](https://github.com/ITSZXY/pink-blood-omarchy-theme) - Bold pink-themed design.
- [omarchy-reverie-theme](https://github.com/bjarneo/omarchy-reverie-theme) - Simple, elegant, dark theme for Omarchy designed for deep focus.
- [omarchy-sakura-theme](https://github.com/bjarneo/omarchy-sakura-theme) - Elegant, high-contrast theme inspired by the delicate beauty of cherry blossoms.
- [omarchy-sapphire-theme](https://github.com/HANCORE-linux/omarchy-sapphire-theme) - Vivid blue theme with rich accents.
- [omarchy-fireside-theme](https://github.com/bjarneo/omarchy-fireside-theme) - Warm, cozy theme inspired by the gentle glow of a crackling fire.
- [omarchy-frost-theme](https://github.com/bjarneo/omarchy-frost-theme) - Simple, elegant theme inspired by the serene beauty of frost patterns.
- [omarchy-pure-latin-theme](https://github.com/daurydicaprio/omarchy-pure-latin-theme) - Custom theme for Omarchy Linux.
- [omarchy-tycho](https://github.com/leonardobetti/omarchy-tycho) - Minimalist pastel theme inspired by musician Tycho's aesthetics.
- [omarchy-c64-theme](https://github.com/scar45/omarchy-c64-theme) - C64-inspired retro theme for Omarchy.
- [F1-omarchy](https://github.com/999Gabriel/F1-omarchy) - Formula 1 inspired Omarchy layout with racing telemetry flair.
- [dracula/omarchy](https://github.com/dracula/omarchy) - Official Dracula theme for Omarchy.

## Development Tools

- [awesome-omarchy-tui](https://github.com/aorumbayev/awesome-omarchy-tui) - Terminal UI for browsing awesome-omarchy repository content.
- [omarchy-ai](https://github.com/mitkox/omarchy-ai) - AI-powered enhancements and tools for Omarchy.
- [omarchy-iso](https://github.com/omacom-io/omarchy-iso) - Custom ISO builder for Omarchy installations.
- [omarchy-box](https://github.com/dylanbr/omarchy-box) - Containerized Omarchy environment.
- [omarchy-chromium](https://github.com/omacom-io/omarchy-chromium) - Chromium browser integration and optimizations for Omarchy.
- [omarchy-configurator](https://github.com/omacom-io/omarchy-configurator) - Configuration management tool for Omarchy.
- [omarchy-installer](https://github.com/omacom-io/omarchy-installer) - Enhanced installation utilities and scripts for Omarchy setup.
- [omarchy-themes-generator](https://github.com/hipsterusername/omarchy-themes-generator) - Tool for generating custom Omarchy themes.
- [omarchy-theme-generator](https://github.com/maxberggren/omarchy-theme-generator) - Alternative theme generation utility.
- [aether](https://github.com/bjarneo/aether) - Desktop theming toolkit that streamlines crafting Omarchy themes.
- [tema](https://github.com/bjarneo/tema) - Modern Omarchy theming UI with live previews and presets.
- [omarchy-tmux](https://github.com/joaofelipegalvao/omarchy-tmux) - Tmux status bar themes styled to match Omarchy.
- [omarchy-migrate](https://github.com/CyphrRiot/Migrate) - Stunningly beautiful terminal backup and restore tool written in Pure Go.
- [Neovim-theme-switcher](https://github.com/HectorBjernersjo/Neovim-theme-switcher) - Lightweight theme switcher for Neovim compatible with Omarchy.
- [omarchy-material-waybar](https://github.com/thatmechguy/omarchy-material-waybar) - Material design style Waybar configuration for Hyprland.
- [omarchy-monitor-settings](https://github.com/ryanyogan/omarchy-monitor-settings) - Omarchy Monitor Settings TUI.
- [Pacsea](https://github.com/Firstp1ck/Pacsea) - Rust TUI for browsing and queueing pacman/AUR packages, inspired by Omarchy's installer.
- [omarchy-waybar](https://github.com/timmo001/omarchy-waybar) - Omarchy Waybar configuration and customizations.
- [waybar-themes](https://github.com/HANCORE-linux/waybar-themes) - Collection of Waybar themes with various styles and combinations for Omarchy.
- [omarchy-hypr](https://github.com/timmo001/omarchy-hypr) - Omarchy Hyprland configuration files and settings.
- [OMARCHY-VM-UTM](https://github.com/hjanuschka/OMARCHY-VM-UTM) - OMARCHY VM for UTM - Pre-configured Arch Linux virtual machine.
- [omarchy-workspace-mover](https://github.com/jonashan/omarchy-workspace-mover) - A Omarchy plugin for moving workspaces between monitors.
- [omarchy-wireguard-vpn-toggle](https://github.com/JacobusXIII/omarchy-wireguard-vpn-toggle) - WireGuard VPN toggle for Omarchy's Waybar.
- [omazed](https://github.com/APS6/omazed) - Live theme switching for Zed editor in Omarchy.
- [flutter_omarchy](https://github.com/aloisdeniel/flutter_omarchy) - Develop Flutter apps for Omarchy.
- [omarchy-pkgs](https://github.com/omacom-io/omarchy-pkgs) - Official Omarchy packages and utilities.
- [omarchy-cheat-sheet](https://github.com/acrogenesis/omarchy-cheat-sheet) - Quick reference guide for Omarchy commands and shortcuts.
- [omarchy-theme-builder](https://github.com/gitcoder89431/omarchy-theme-builder) - Interactive, real-time theme builder for Omarchy.
- [omarchy-theme-builder](https://github.com/jg-k/omarchy-theme-builder) - Advanced theme building tool for Omarchy.
- [FW12Rotate](https://github.com/2disbetter/FW12Rotate) - Framework 12 rotation application specifically for Omarchy Linux.
- [JaimeStill/omarchy-theme-generator](https://github.com/JaimeStill/omarchy-theme-generator) - Generate Omarchy themes based on images.
- [omarchist](https://github.com/tahayvr/omarchist) - GUI app for Omarchy with visual theme designer built with Tauri/Rust/Svelte.
- [omarchy-enhanced-bindings](https://github.com/nemuiyarou/omarchy-enhanced-bindings) - Enhanced keyboard bindings for Omarchy.
- [Adsovetzky-Omarchy-s-Waybar](https://github.com/adsovetzky/Adsovetzky-Omarchy-s-Waybar) - Custom Waybar configurations for Omarchy.
- [omarchy-gui](https://github.com/amanat361/omarchy-gui) - GUI tools for Omarchy configuration.
- [hyprmon](https://github.com/erans/hyprmon) - TUI monitor configuration tool for Hyprland with visual layout, drag-and-drop, and profile management.
- [hyprmarker](https://github.com/devmobasa/hyprmarker) - ZoomIt-inspired annotation overlay tailored for Hyprland/Omarchy.
- [omarchy-cleaner](https://github.com/maxart/omarchy-cleaner) - Quickly and easily remove pre-installed apps and webapps.
- [clipboard-manager](https://github.com/Grenish/clipboard-manager) - Windows-like clipboard manager for Omarchy.
- [edit](https://github.com/mirarr-app/editt) - Beautiful image viewer and editor with Omarchy styling support.
- [omarchy-speech-to-text](https://github.com/michabbb/omarchy-speech-to-text) - Whisper-backed speech-to-text integrations for Omarchy.
- [omarchy-steam-gaming-mode](https://github.com/cephalization/omarchy-steam-gaming-mode) - Steam Deck-like gaming experience for Omarchy.
- [live-wallpaper-for-omarchy-linux](https://github.com/daurydicaprio/live-wallpaper-for-omarchy-linux) - A robust script to manage and cycle through live video wallpapers on Omarchy/Hyprland.
- [omarchy-calculator](https://github.com/aloisdeniel/omarchy_calculator) - Official Omarchy calculator application built with Flutter.
- [manual-nas-backup-tool](https://github.com/daurydicaprio/manual-nas-backup-tool) - A simple script to make incremental copies, encrypted or not.
- [omarchy-monitor-toggle](https://github.com/daurydicaprio/omarchy-monitor-toggle) - Tools for automating monitor power management within Omarchy.
- [hyprBluetooth](https://github.com/magudb/hyprBluetooth) - Bluetoothctl-powered TUI for quickly pairing devices on Omarchy.
- [omarchpods](https://github.com/tomycostantino/omarchpods) - TUI for monitoring AirPods and other Bluetooth headphones with battery status and device info.
- [wayscriber](https://github.com/devmobasa/wayscriber) - Instant on-screen annotations and markup for Wayland, ZoomIt-inspired.

## Related Projects

- [j5onrf/dots](https://github.com/j5onrf/dots) - Hyprland dotfiles with Waybar and ML4W inspired by Omarchy aesthetics.
- [CyphrRiot/ArchRiot](https://github.com/CyphrRiot/ArchRiot) - A curated Arch Linux experience inspired by Omarchy's philosophy.
- [dougburks/ohmydebn](https://github.com/dougburks/ohmydebn) - A debonair Debian + Cinnamon setup inspired by Omarchy.
- [alibaghernejad/waybar-privacy-dots](https://github.com/alibaghernejad/waybar-privacy-dots) - Privacy-first module for your Waybar status bar.
- [omarchy-site](https://github.com/omacom-io/omarchy-site) - Official Omarchy website source code.
- [omarchy-mirror](https://github.com/omacom-io/omarchy-mirror) - Dedicated mirror of Arch repositories for Omarchy hosted on Cloudflare R2.
- [marcelohmdias/dotfiles](https://github.com/marcelohmdias/dotfiles) - Personal dotfiles and post-install setup based on Omarchy.
- [pixincreate/configs](https://github.com/pixincreate/configs) - Cross-platform dotfiles and setup scripts with Omarchy/Omaforge profiles.
- [jehrhardt/dotfiles](https://github.com/jehrhardt/dotfiles) - Dotfiles based on Omarchy.
- [sheikhlimon/dotfiles](https://github.com/sheikhlimon/dotfiles) - Personal Omarchy dotfiles configuration.
- [donotfeedthevirus/dotfiles](https://github.com/donotfeedthevirus/dotfiles) - Curated Omarchy dotfiles for Hyprland, Kitty, Neovim, and Tmux.

## Alternative Curated Lists

- [Wheel-Smith/awesome-omarchy](https://github.com/Wheel-Smith/awesome-omarchy) - Alternative curated list of Omarchy resources with explicit focus on theme resources with screenshot previews.
- [Alexx2/omarchy-themes](https://github.com/Alexx2/omarchy-themes) - Personal collection of Omarchy themes.

## Community Resources

- [GitHub Discussions](https://github.com/basecamp/omarchy/discussions) - Official community discussions and support.
- [Omarchy on Raspberry Pi 5](https://github.com/basecamp/omarchy/discussions/642) - Community discussion on running Omarchy on Raspberry Pi 5.
- [Omarchy on 11 inch MacBook Air](https://seanabrahams.com/linux/archlinux/macbook/omarchy/2025/08/07/omarchy-macbook-air.html) - Technical guide for installing Omarchy on a 2014 MacBook Air with WiFi configuration.
- [GitHub Issues](https://github.com/basecamp/omarchy/issues) - Bug reports and feature requests.
- [omarchy-theme Topic](https://github.com/topics/omarchy-theme) - Browse all repositories tagged with omarchy-theme.

## Articles and Tutorials

- [All-in on Omarchy at 37signals](https://world.hey.com/dhh/all-in-on-omarchy-at-37signals-68162450) - DHH's announcement about 37signals adopting Omarchy company-wide.
- [My Journey from macOS to Arch Linux with Omarchy](https://www.ssp.sh/blog/macbook-to-arch-linux-omarchy/) - Sean Abrahams' detailed experience switching from a MacBook Pro to Linux with Omarchy.
- [Why I Switched to Omarchy (and Why You Might Too)](https://medium.com/@prathamgundikere/why-i-switched-to-omarchy-and-why-you-might-too-617d84ac63ce) - Medium article about discovering and adopting Omarchy.
- [This One Command Turned My Arch Install Into a Beautiful Hyprland Setup](https://news.itsfoss.com/omarchy/) - It's FOSS review of Omarchy installation and features.
- [Installing Omarchy on Arch - iFixit Repair Guide](https://www.ifixit.com/Guide/Installing+Omarchy+on+Arch/190367) - Step-by-step installation guide on iFixit.

- [Installing Omarchy via Arch Linux on macOS](https://deepakness.com/raw/installing-arch-omarchy-on-mac/) - Guide for installing on Mac hardware.
- [Configuring Omarchy on Beelink](https://www.dennisokeeffe.com/blog/2025-07-17-configuring-arch-linux-omarchy-via-mac) - Configuration guide for Beelink mini PCs.

## Contributing

Contributions are welcome! Please see our [Contributing Guide](CONTRIBUTING.md) for details on how to submit themes, tools, or other resources.
