#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import unittest

from pyspark.sql.tests.test_dataframe import DataFrameTestsMixin
from pyspark.testing.connectutils import ReusedConnectTestCase


class DataFrameParityTests(DataFrameTestsMixin, ReusedConnectTestCase):
    def test_help_command(self):
        df = self.spark.createDataFrame(data=[{"foo": "bar"}, {"foo": "baz"}])
        super().check_help_command(df)

    @unittest.skip("Spark Connect does not support RDD but the tests depend on them.")
    def test_toDF_with_schema_string(self):
        super().test_toDF_with_schema_string()

    @unittest.skip("This test is dedicated for classic mode.")
    def test_query_execution_unsupported_in_classic(self):
        pass


if __name__ == "__main__":
    from pyspark.testing import main

    main()
