## Contributing

:sparkles: We are very glad to see you in this section! :sparkles:

Before you go ahead you should know that your contributions will be published under
the terms of the [`CC0` license](https://creativecommons.org/publicdomain/zero/1.0/).

Have you just found a spelling error? Need to fix indentation?
Send us a pull request! :sparkles:

You have discovered something cool, but don't know exactly if it suits the
awesome definition? :+1: Submit a pull request to the [inbox](inbox.md)!
We'll consider your addition and format it for you! :smiley:

:boom: If you know something pretty cool, it suits the awesome definition, works for you
and seems to be useful for the community please add it to the [main list](README.md).
In this case please ensure your pull request adheres to the following guidelines:

- Use one commit per addition (several commits per PR are OK).
- Add everything to the bottom of the relevant category.
- If required introduce new categories or improve the existing categorization.
- Use the following format: `- [title](link) - Distinguishing Description. <sup>[additional links]</sup>`
- Name the libraries exactly how they are required from the Ruby program, not
  after the Readme's title, e.g. `treat`, not `Treat`, since you do `require "treat"`.
- Break down long lines, check your spelling, capitalization, and punctuation.
- Provide a useful titles and comments for your Pull Request (not `Changed readme.md`),
  mention the originator in the commit message if possible, e.g. `Added the neuroevo lib by @giuse.`
- Add the topic `rubyml` to your repository or open an issue and
  kindly ask the originator of the project to do so (if applicable for your submission).

Sometimes we will ask you to edit your Pull Request before it is included.
This is normally due to spelling errors or because your PR didn't match
these guidelines.

[Here][change-pr] is a write up on how to change a Pull Request and
the different ways you can do that.

:+1: Thank you for your suggestions!

[change-pr]: https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md
