## We want to ensure high quality of the packages. Make sure that you've checked the boxes below before sending a pull request.

- [ ] I have read the [Contribution Guidelines](https://github.com/avelino/awesome-go/blob/main/CONTRIBUTING.md#contribution-guidelines)
- [ ] I have read the [Maintainers Note](https://github.com/avelino/awesome-go/blob/main/CONTRIBUTING.md#maintainers)
- [ ] I have read the [Quality Standards](https://github.com/avelino/awesome-go/blob/main/CONTRIBUTING.md#quality-standards)

_Not every repository (project) will require every option, but most projects should. Check the Contribution Guidelines for details._

- [ ] The repo documentation has a pkg.go.dev link.
- [ ] The repo documentation has a coverage service link.
- [ ] The repo documentation has a goreportcard link.
- [ ] The repo has a version-numbered release and a go.mod file.
- [ ] The repo has a continuous integration process that automatically runs tests that must pass before new pull requests are merged.
- [ ] Continuous integration is used to attempt to catch issues prior to releasing this package to end-users.

## Please provide some links to your package to ease the review

- [ ] forge link (github.com, gitlab.com, etc):
- [ ] pkg.go.dev:
- [ ] goreportcard.com:
- [ ] coverage service link ([codecov](https://codecov.io/), [coveralls](https://coveralls.io/), etc.):

## Pull Request content

- [ ] The package has been added to the list in alphabetical order.
- [ ] The package has an appropriate description with correct grammar.
- [ ] As far as I know, the package has not been listed here before.

## Category quality

_Note that new categories can be added only when there are 3 packages or more._

Packages added a long time ago might not meet the current guidelines anymore. It would be very helpful if you could check 3-5 packages above and below your submission to ensure that they also still meet the Quality Standards.

Please delete one of the following lines:

- [ ] The packages around my addition still meet the Quality Standards.
- [ ] I removed the following packages around my addition: (please give a short reason for each removal)

Thanks for your PR, you're awesome! :sunglasses:
