<div id="top" align="center">

<a href="#">
    <img width=333 height=auto src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/awesome/shades/400x200.png"></a>

<h1>Awesome Userscripts</h1>

<!-- Shields -->

<a href="https://github.com/sindresorhus/awesome">
    <img height=31 alt="Awesome" src="https://img.shields.io/badge/Awesome-fc60a9.svg?logo=awesomelists&logoColor=white&labelColor=464646&style=for-the-badge"></a>
<a href="#license">
    <img height=31 alt="Awesome" src="https://img.shields.io/badge/License-CC0_1.0-orange.svg?logo=internetarchive&logoColor=white&labelColor=464646&style=for-the-badge"></a>
<a href="https://github.com/awesome-scripts/awesome-userscripts/blob/master/CONTRIBUTING.md">
    <img height=31 alt="PRs Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?logo=github&logoColor=white&labelColor=464646&style=for-the-badge"></a>

<h3>A curated list of Awesome Userscripts.</h3>

Userscripts can improve your browsing experience, and open a lot of possibilities to make the sites you visit better by adding features, making them easier to use, or taking out the annoying bits.

</div>

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/rainbow-blue-to-red.png">

# Contents

- [Compatibility](#compatibility)
- [Scripts](#scripts)
  - [Ad blocking](#-ad-blocking)
  - [Amazon](#-amazon)
  - [Brave](#-brave)
  - [ChatGPT](#-chatgpt)
  - [Discord](#-discord)
  - [Display](#-display)
  - [DuckDuckGo](#-duckduckgo)
  - [GitHub](#-github)
  - [Google](#-google)
  - [Just Eat (UK)](#-just-eat-uk)
  - [Links](#-links)
  - [Media](#-media)
  - [Navigation](#-navigation)
  - [Passwords](#-passwords)
  - [Privacy](#-privacy)
  - [Quora](#-quora)
  - [Reddit](#-reddit)
  - [Stremio](#-stremio)
  - [Text-to-speech](#-text-to-speech)
  - [Translation](#-translation)
  - [Xbox](#-xbox)
  - [YouTube](#-youtube)
- [Tutorials](#tutorials)
- [Community](#community)
- [Additional Catalogues](#additional-catalogues)
- [Contributing](#contributing)
- [License](#license)

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Compatibility

Userscripts can be used w/ the following browsers:

<table>
    <thead><th>Browser</th><th>Userscript manager</th><th>Install browser</th></thead>
    <tbody align="center">
        <tr> <!-- CHROME/CHROMIUM desktop -->
            <td> <!-- Browser -->
                <a href="https://www.chrome.com" title="Chrome">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/chrome/icon16.png"
                         width=16 alt="[Install]"></a>
                Chrome, dev builds or Chromium-based browsers (Windows, macOS, Linux)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://chromewebstore.google.com/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo"
                   title="Install Tampermonkey for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png"></a>
                <a href="https://chromewebstore.google.com/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo"
                   title="Install Tampermonkey for Chrome">
                        Tampermonkey</a><sup>1</sup>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        ScriptCat</a>
                or
                <a href="https://chromewebstore.google.com/detail/orangemonkey/ekmeppjgajofkpiofbebgcbohbmfldaf"
                   title="Install OrangeMonkey for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/orangemonkey/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/orangemonkey/ekmeppjgajofkpiofbebgcbohbmfldaf"
                   title="Install OrangeMonkey for Chrome">
                        OrangeMonkey</a><sup>1,2</sup>
            </td>
            <td> <!-- Install browser -->
                <a href="https://www.chrome.com" title="Chrome">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/chrome/icon16.png"
                         width=16 alt="[Chrome]"></a>
                <a href="https://www.google.com/chrome/beta/" title="Chrome Beta">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/chrome/beta/icon16.svg"
                         width=16 alt="[Chrome Beta]"></a>
                <a href="https://www.google.com/chrome/dev/" title="Chrome Dev">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/chrome/dev/icon16.svg"
                         width=16 alt="[Chrome Dev]"></a>
                <a href="https://www.google.com/chrome/canary/" title="Chrome Canary">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/chrome/canary/icon16.svg"
                         width=16 alt="[Chrome Canary]"></a>
                <a href="https://www.opera.com" title="Opera">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/opera/icon16.png"
                         width=16 alt="[Opera]"></a><sup>3</sup>
                <a href="https://www.opera.com/gx" title="Opera GX">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/opera/gx/icon16.png"
                         width=16 alt="[Opera GX]"></a><sup>3</sup>
                <a href="https://www.opera.com/air" title="Opera Air">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/opera/air/icon16.png"
                         width=16 alt="[Opera Air]"></a><sup>3</sup>
                <a href="https://brave.com" title="Brave">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/brave/icon16.png"
                         width=16 alt="[Brave]"></a>
                <a href="https://vivaldi.com" title="Vivaldi">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/vivaldi/icon16.png"
                         width=16 alt="[Vivaldi]"></a>
                <a href="https://ghostbrowser.com" title="Ghost Browser">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/ghost/icon16.png"
                         width=16 alt="[Ghost Browser]"></a>
                <a href="https://whale.naver.com" title="Whale">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/whale/tiled/icon16.png"
                         width=16 alt="[Whale]"></a>
            </td>
        </tr>
        <tr> <!-- SAFARI -->
            <td> <!-- Browser -->
                <a href="https://www.apple.com/safari/" title="Safari">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/safari/icon16.png"
                         width=16 alt="[Install]"></a>
                Safari (macOS, iOS, iPadOS, visionOS)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://apps.apple.com/app/stay-for-safari/id1591620171"
                   title="Install Stay for Safari">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/stay/icon16.png"></a>
                <a href="https://apps.apple.com/app/stay-for-safari/id1591620171"
                   title="Install Stay for Safari">
                        Stay</a>
                or
                <a href="https://apps.apple.com/app/userscripts/id1463298887"
                   title="Install Userscripts for Safari">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/userscripts/icon16.png"></a>
                <a href="https://apps.apple.com/app/userscripts/id1463298887"
                   title="Install Userscripts for Safari">
                        Userscripts</a>
            </td>
            <td> <!-- Install browser -->
                <a href="https://www.apple.com/safari/" title="Safari">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/safari/icon16.png"
                         width=16 alt="[Safari]"></a>
            </td>
        </tr>
        <tr> <!-- EDGE desktop -->
            <td> <!-- Browser -->
                <a href="https://www.microsoft.com/edge" title="Edge">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/icon16.png"
                         width=16 alt="[Install]"></a>
                Edge or dev builds (Windows, macOS, Linux)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://microsoftedge.microsoft.com/addons/detail/tampermonkey/iikmkjmpaadaobahmlepeloendndfphd"
                   title="Install Tampermonkey for Edge">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png"></a>
                <a href="https://microsoftedge.microsoft.com/addons/detail/tampermonkey/iikmkjmpaadaobahmlepeloendndfphd"
                   title="Install Tampermonkey for Edge">
                        Tampermonkey</a><sup>1</sup>
                <a href="https://microsoftedge.microsoft.com/addons/detail/violentmonkey/eeagobfjdenkkddmbclomhiblgggliao"
                   title="Install Violentmonkey for Edge">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/violentmonkey/icon25.png"></a>
                <a href="https://microsoftedge.microsoft.com/addons/detail/violentmonkey/eeagobfjdenkkddmbclomhiblgggliao"
                   title="Install Violentmonkey for Edge">
                        Violentmonkey</a><sup>2</sup>
                <a href="https://microsoftedge.microsoft.com/addons/detail/scriptcat/liilgpjgabokdklappibcjfablkpcekh"
                   title="Install ScriptCat for Edge">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://microsoftedge.microsoft.com/addons/detail/scriptcat/liilgpjgabokdklappibcjfablkpcekh"
                   title="Install ScriptCat for Edge">
                        ScriptCat</a>
                or
                <a href="https://chromewebstore.google.com/detail/orangemonkey/ekmeppjgajofkpiofbebgcbohbmfldaf"
                   title="Install OrangeMonkey for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/orangemonkey/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/orangemonkey/ekmeppjgajofkpiofbebgcbohbmfldaf"
                   title="Install OrangeMonkey for Chrome">
                        OrangeMonkey</a><sup>1,2</sup>
            </td>
            <td> <!-- Install browser -->
                <a href="https://www.microsoft.com/edge/download" title="Edge">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/icon16.png"
                         width=16 alt="[Edge]"></a>
                <a href="https://www.microsoft.com/edge/download/insider" title="Edge Beta">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/beta/icon16.png"
                         width=16 alt="[Edge Beta]"></a>
                <a href="https://www.microsoft.com/edge/download/insider" title="Edge Dev">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/dev/icon16.png"
                         width=16 alt="[Edge Dev]"></a>
                <a href="https://www.microsoft.com/edge/download/insider" title="Edge Canary">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/canary/icon16.png"
                         width=16 alt="[Edge Canary]"></a>
            </td>
        </tr>
        <tr> <!-- EDGE Android -->
            <td> <!-- Browser -->
                <a href="https://play.google.com/store/apps/details?id=com.microsoft.emmx" title="Edge for Android">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/icon16.png"
                         width=16 alt="[Install]"></a>
                Edge or dev builds (Android)
            </td>
            <td> <!-- Userscript manager -->
                <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png">
                    Tampermonkey
                <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/violentmonkey/icon25.png">
                    Violentmonkey
                or
                <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png">
                    ScriptCat
                <i>(install from ≡ > Extensions)</i>
            </td>
            <td> <!-- Install browser -->
                <a href="https://play.google.com/store/apps/details?id=com.microsoft.emmx"
                   title="Edge for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/icon16.png"
                             width=16 alt="[Edge for Android]"></a>
                <a href="https://play.google.com/store/apps/details?id=com.microsoft.emmx.beta"
                   title="Edge Beta for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/beta/icon16.png"
                             width=16 alt="[Edge Beta for Android]"></a>
                <a href="https://play.google.com/store/apps/details?id=com.microsoft.emmx.dev"
                   title="Edge Dev for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/dev/icon16.png"
                             width=16 alt="[Edge Dev for Android]"></a>
                <a href="https://play.google.com/store/apps/details?id=com.microsoft.emmx.canary"
                   title="Edge Canary for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/edge/canary/icon16.png"
                             width=16 alt="[Edge Canary for Android]"></a>
            </td>
        </tr>
        <tr> <!-- FIREFOX/GECKO desktop -->
            <td> <!-- Browser -->
                <a href="https://www.firefox.com" title="Firefox">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/icon16.png"
                         width=16 alt="[Install]"></a>
                Firefox, dev builds or Gecko-based browsers (Windows, macOS, Linux)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://addons.mozilla.org/firefox/addon/tampermonkey/"
                   title="Install Tampermonkey for Firefox">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png"></a>
                <a href="https://addons.mozilla.org/firefox/addon/tampermonkey/"
                   title="Install Tampermonkey for Firefox">
                        Tampermonkey</a>
                <a href="https://addons.mozilla.org/firefox/addon/violentmonkey/"
                   title="Install Violentmonkey for Firefox">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/violentmonkey/icon25.png"></a>
                <a href="https://addons.mozilla.org/firefox/addon/violentmonkey/"
                   title="Install Violentmonkey for Firefox">
                        Violentmonkey</a><sup>2</sup>
                or
                <a href="https://addons.mozilla.org/firefox/addon/scriptcat/"
                   title="Install ScriptCat for Firefox">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://addons.mozilla.org/firefox/addon/scriptcat/"
                   title="Install ScriptCat for Firefox">
                        ScriptCat</a>
            </td>
            <td> <!-- Install browser -->
                <a href="https://www.firefox.com" title="Firefox">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/icon16.png"
                         width=16 alt="[Firefox]"></a>
                <a href="https://download.mozilla.org/?product=firefox-beta-stub" title="Firefox Beta">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/beta/icon16.png"
                         width=16 alt="[Firefox Beta]"></a>
                <a href="https://download.mozilla.org/?product=firefox-nightly-stub" title="Firefox Nightly">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/nightly/icon16.png"
                         width=16 alt="[Firefox Nightly]"></a>
                <a href="https://www.waterfox.net" title="Waterfox">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/waterfox/icon16.png"
                         width=16 alt="[Waterfox]"></a>
                <a href="https://librewolf.net" title="LibreWolf">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/librewolf/icon16.svg"
                         width=16 alt="[LibreWolf]"></a>
            </td>
        </tr>
        <tr> <!-- FIREFOX/GECKO Android -->
            <td> <!-- Browser -->
                <a href="https://play.google.com/store/apps/details?id=org.mozilla.firefox" title="Firefox for Android">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/icon16.png"
                         width=16 alt="[Install]"></a>
                Firefox, dev builds or Gecko-based browsers (Android)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://addons.mozilla.org/firefox/addon/tampermonkey/"
                   title="Install Tampermonkey for Firefox">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png"></a>
                <a href="https://addons.mozilla.org/firefox/addon/tampermonkey/"
                   title="Install Tampermonkey for Firefox">
                        Tampermonkey</a>
                <a href="https://addons.mozilla.org/firefox/addon/violentmonkey/"
                   title="Install Violentmonkey for Firefox">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/violentmonkey/icon25.png"></a>
                <a href="https://addons.mozilla.org/firefox/addon/violentmonkey/"
                   title="Install Violentmonkey for Firefox">
                        Violentmonkey</a><sup>2</sup>
                or
                <a href="https://addons.mozilla.org/firefox/addon/scriptcat/"
                   title="Install ScriptCat for Firefox">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://addons.mozilla.org/firefox/addon/scriptcat/"
                   title="Install ScriptCat for Firefox">
                        ScriptCat</a>
            </td>
            <td> <!-- Install browser -->
                <a href="https://play.google.com/store/apps/details?id=org.mozilla.firefox"
                   title="Firefox for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/icon16.png"
                             width=16 alt="[Firefox for Android]"></a>
                <a href="https://play.google.com/store/apps/details?id=org.mozilla.firefox_beta"
                   title="Firefox Beta for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/beta/icon16.png"
                             width=16 alt="[Firefox Beta for Android]"></a>
                <a href="https://play.google.com/store/apps/details?id=org.mozilla.fenix"
                   title="Firefox Nightly for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/firefox/nightly/icon16.png"
                             width=16 alt="[Firefox Nightly for Android]"></a>
                <a href="https://play.google.com/store/apps/details?id=net.waterfox.android.release"
                   title="Waterfox for Android">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/waterfox/icon16.png"
                             width=16 alt="[Waterfox for Android]"></a>
                <a href="https://f-droid.org/packages/org.mozilla.fennec_fdroid/"
                   title="Fennec">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/fennec/icon16.png"
                             width=16 alt="[Fennec]"></a>
                <a href="https://github.com/fork-maintainers/iceraven-browser/releases"
                   title="Iceraven">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/iceraven/icon16.png"
                             width=16 alt="[Iceraven]"></a>
                <a href="https://gitlab.com/ironfox-oss/IronFox/-/releases"
                   title="IronFox">
                        <img src="https://assets.aiwebextensions.com/images/icons/browsers/ironfox/icon16.png"
                             width=16 alt="[IronFox]"></a>
            </td>
        </tr>
        <tr> <!-- QQ BROWSER desktop -->
            <td> <!-- Browser -->
                <a href="https://browser.qq.com" title="QQ Browser">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/qq/gradient-bg/bluer/icon16.png"
                         width=16 alt="[Install]"></a>
                QQ Browser (Windows, macOS)
            </td>
            <td> <!-- Userscript manager -->
                Not required <i>(Tampermonkey & Violentmonkey pre-installed)</i>
            </td>
            <td> <!-- Install browser -->
                <a href="https://browser.qq.com" title="QQ Browser">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/qq/gradient-bg/bluer/icon16.png"
                         width=16 alt="[QQ Browser]"></a>
            </td>
        </tr>
        <tr> <!-- MISES mobile -->
            <td> <!-- Browser -->
                <a href="https://www.mises.site" title="Mises">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/mises/icon16.png"
                         width=16 alt="[Install]"></a>
                Mises (Android, iOS, iPadOS)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://chromewebstore.google.com/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo"
                   title="Install Tampermonkey for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png"></a>
                <a href="https://chromewebstore.google.com/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo"
                   title="Install Tampermonkey for Chrome">
                        Tampermonkey</a><sup>1</sup>
                or
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        ScriptCat</a>
            </td>
            <td> <!-- Install browser -->
                <details>
                    <summary>Show QR code</summary>
                    <a href="https://www.mises.site/download" title="Download Mises">
                        <img src="https://assets.aiwebextensions.com/images/qr-codes/browsers/mises/download-page/with-icon/purple.png"
                             width=125 alt="[Download Mises]"></a>
                </detail>
            </td>
        </tr>
        <tr> <!-- LEMUR Android/iOS -->
            <td> <!-- Browser -->
                <a href="https://www.lemurbrowser.com" title="Lemur">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/lemur/icon16.png"
                         width=16 alt="[Install]"></a>
                Lemur (Android, iOS)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        ScriptCat</a>
            </td>
            <td> <!-- Install browser -->
                <details>
                    <summary>Show QR code</summary>
                    <a href="https://www.lemurbrowser.com" title="Lemur">
                        <img src="https://assets.aiwebextensions.com/images/qr-codes/browsers/lemur/homepage/with-icon/teal.png"
                             width=125 alt="[Lemur]"></a>
                </details>
            </td>
        </tr>
        <tr> <!-- QUETTA mobile -->
            <td> <!-- Browser -->
                <a href="https://www.quetta.net" title="Quetta">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/quetta/circled/icon16.png"
                         width=16 alt="[Install]"></a>
                Quetta (Android, iOS, iPadOS)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        ScriptCat</a>
            </td>
            <td> <!-- Install browser -->
                <details>
                    <summary>Show QR code</summary>
                    <a href="https://www.quetta.net" title="Quetta">
                        <img src="https://assets.aiwebextensions.com/images/qr-codes/browsers/quetta/homepage/with-icon/red.png"
                             width=125 alt="[Quetta]"></a>
                </detail>
            </td>
        </tr>
        <tr> <!-- ORION iOS/iPadOS -->
            <td> <!-- Browser -->
                <a href="https://apps.apple.com/app/orion-browser-by-kagi/id1484498200" title="Orion">
                    <img src="https://assets.aiwebextensions.com/images/icons/browsers/orion/icon16.png"
                         width=16 alt="[Install]"></a>
                Orion (iOS, iPadOS)
            </td>
            <td> <!-- Userscript manager -->
                <a href="https://chromewebstore.google.com/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo"
                   title="Install Tampermonkey for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/tampermonkey/icon28.png"></a>
                <a href="https://chromewebstore.google.com/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo"
                   title="Install Tampermonkey for Chrome">
                        Tampermonkey</a><sup>1</sup>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/scriptcat/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/scriptcat/ndcooeababalnlpkfedmmbbbgkljhpjf"
                   title="Install ScriptCat for Chrome">
                        ScriptCat</a>
                or
                <a href="https://chromewebstore.google.com/detail/orangemonkey/ekmeppjgajofkpiofbebgcbohbmfldaf"
                   title="Install OrangeMonkey for Chrome">
                        <img width=16 src="https://assets.aiwebextensions.com/images/icons/userscript-managers/orangemonkey/icon16.png"></a>
                <a href="https://chromewebstore.google.com/detail/orangemonkey/ekmeppjgajofkpiofbebgcbohbmfldaf"
                   title="Install OrangeMonkey for Chrome">
                        OrangeMonkey</a><sup>1,2</sup>
            </td>
            <td> <!-- Install browser -->
                <details>
                    <summary>Show QR code</summary>
                    <a href="https://apps.apple.com/app/orion-browser-by-kagi/id1484498200"
                       title="Orion on Apple App Store">
                            <img src="https://assets.aiwebextensions.com/images/qr-codes/browsers/orion/apple-app-store/with-icon/purple.png"
                                 width=125 alt="[Orion on Apple App Store]"></a>
                </details>
            </td>
        </tr>
    </tbody>
</table>
<h5>
    <i>1. If you are installing Tampermonkey or OrangeMonkey for a Chromium browser, you must enable Developer Mode in chrome://extensions for userscripts to function</i><br><br>
    <i>2. Violentmonkey & OrangeMonkey do not support Streaming Mode in AmazonGPT + BraveGPT + DuckDuckGPT + GoogleGPT</i><br><br>
    <i>3. If you are installing a userscript manager for an Opera browser, you must allow it access to search page results in opera://extensions for search page userscripts to function</i>
</h5>

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Scripts

> [!TIP]  
> To show screenshots/links, click the ▸ or userscript descriptions.

### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/cancel/white/icon32.png"><img height=14 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/cancel/black/icon32.png"></picture> Ad blocking

<details> <!-- AdGuard Extra -->
    <summary><a href="https://github.com/AdguardTeam/AdGuardExtra">AdGuard Extra</a> - Fight ad blocking circumvention attempts.</summary><br>
    <blockquote>
        <a href="https://github.com/AdguardTeam/AdGuardExtra">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@5d22849/assets/images/screenshots/scripts/adguard-extra.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://userscripts.adtidy.org/release/adguard-extra/1.0/adguard-extra.user.js">
            Install Stable Build</a> /
        💾 <a href="https://userscripts.adtidy.org/beta/adguard-extra/1.0/adguard-extra.user.js">
            Install Beta Build</a> /
        📖 <a href="https://github.com/AdguardTeam/AdGuardExtra/#readme">
            Readme</a> /
        📢 <a href="https://github.com/AdguardTeam/AdGuardExtra/issues">
            Discuss</a> /
        🐛 <a href="https://github.com/AdguardTeam/AdGuardExtra/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- AdsBypasser -->
    <summary><a href="https://adsbypasser.github.io">AdsBypasser</a> - Bypass Ads, Popups and count-down ads.</summary><br>
    <blockquote>
        <a href="https://adsbypasser.github.io">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/adsbypasser.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://adsbypasser.github.io/releases/adsbypasser.full.es7.user.js">
            Install Full Edition</a> /
        💾 <a href="https://adsbypasser.github.io/releases/adsbypasser.lite.es7.user.js">
            Install Lite Edition</a> /
        📖 <a href="https://github.com/adsbypasser/adsbypasser/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adsbypasser/adsbypasser/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adsbypasser/adsbypasser/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Block Quora Poe -->
    <summary><a href="https://github.com/adamlui/userscripts/blob/master/block-quora-poe/#readme">Block Quora Poe</a> - Blocks low-quality AI + Promoted/Sponsored answers from Quora.</summary><br>
    <blockquote>
        <a href="https://github.com/adamlui/userscripts/blob/master/block-quora-poe/#readme">
            <img width=511 src="https://cdn.jsdelivr.net/gh/adamlui/userscripts@a1eefef/block-quora-poe/assets/images/screenshots/demo.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/adamlui/userscripts/master/block-quora-poe/block-quora-poe.user.js">
            Install</a> /
        📖 <a href="https://github.com/adamlui/userscripts/blob/master/block-quora-poe/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- ChatGPT Widescreen -->
    <summary><a href="https://www.chatgptwidescreen.com">ChatGPT Widescreen</a> - Enhances ChatGPT with wide/full/tall-screen + spamblock modes. Also works on poe.com!</summary><br>
    <blockquote>
        <a href="https://www.chatgptwidescreen.com">
            <img width=600 src="https://assets.chatgptwidescreen.com/images/tiles/marquee/tile-625x250.png?v=0ba78c7"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptwidescreen.com">
            Install</a> /
        📖 <a href="https://docs.chatgptwidescreen.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-widescreen/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-widescreen/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Simple Sponsor Skipper -->
    <summary><a href="https://greasyfork.org/scripts/453320-simple-sponsor-skipper">Simple Sponsor Skipper</a> - Skips annoying intros, sponsors and filler using the SponsorBlock API. Compatible w/ YouTube, Invidious, CloudTube & Odysee.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/453320-simple-sponsor-skipper">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/screenshots/scripts/simple-sponsor-skipper.png?v=96092ef"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://codeberg.org/mthsk/userscripts/raw/branch/master/simple-sponsor-skipper/simple-sponsor-skipper.user.js">
            Install</a> /
        📖 <a href="https://greasyfork.org/scripts/453320-simple-sponsor-skipper">
            Readme</a> /
        📢 <a href="https://codeberg.org/mthsk/userscripts/issues">
            Discuss</a> /
        🐛 <a href="https://codeberg.org/mthsk/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- YouTube Classic -->
    <summary><a href="https://www.ytclassic.com">YouTube Classic</a> - Reverts YouTube to its classic design (unround corners, restore dislikes + remove/redirect Shorts) + block thumbnail/masthead ads.</summary><br>
    <blockquote>
        <a href="https://www.ytclassic.com">
            <img width=511 src="https://assets.ytclassic.com/images/screenshots/youtube-classic-ui.png?v=6de3a93"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.ytclassic.com">
            Install</a> /
        📖 <a href="https://docs.ytclassic.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/youtube-classic/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/youtube-classic/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/amazon/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/amazon/icon32.png"></picture> Amazon

<details> <!-- AmazonGPT -->
    <summary><a href="https://amazongpt.kudoai.com">AmazonGPT</a> - Adds AI chat & product/category summaries to Amazon shopping, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://amazongpt.kudoai.com">
            <img width=511 src="https://amazongpt.kudoai.com/assets/images/screenshots/desktop/mice-md-reply-darkmode.png?v=80bceab"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/KudoAI/amazongpt/main/greasemonkey/amazongpt.user.js">
            Install</a> /
        📖 <a href="https://github.com/KudoAI/amazongpt/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/amazongpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/amazongpt/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/brave/white/icon32.png"><img height=16 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/brave/icon32.png"></picture> Brave

<details> <!-- BraveGPT -->
    <summary><a href="https://www.bravegpt.com">BraveGPT</a> - Adds AI chat & search summaries to Brave Search, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://www.bravegpt.com">
            <img width=511 src="https://assets.bravegpt.com/images/screenshots/desktop/bitcoin-query/darkmode.png?v=a0dd1de"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.bravegpt.com">
            Install</a> /
        📖 <a href="https://docs.bravegpt.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/bravegpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/bravegpt/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/chatgpt/white-on-black/icon50.png"><img height=21 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/chatgpt/black-on-white/icon50.png"></picture> ChatGPT

<details> <!-- AmazonGPT -->
    <summary><a href="https://amazongpt.kudoai.com">AmazonGPT</a> - Adds AI chat & product/category summaries to Amazon shopping, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://amazongpt.kudoai.com">
            <img width=511 src="https://amazongpt.kudoai.com/assets/images/screenshots/desktop/mice-md-reply-darkmode.png?v=80bceab"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/KudoAI/amazongpt/main/greasemonkey/amazongpt.user.js">
            Install</a> /
        📖 <a href="https://github.com/KudoAI/amazongpt/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/amazongpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/amazongpt/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Autoclear ChatGPT History -->
    <summary><a href="https://www.autoclearchatgpt.com">Autoclear ChatGPT History</a> - Auto-clears chat history when visiting chatgpt.com for maximum privacy.</summary><br>
    <blockquote>
        <a href="https://www.autoclearchatgpt.com">
            <img width=511 src="https://assets.autoclearchatgpt.com/images/screenshots/demo.png?v=4f5c5fa"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.autoclearchatgpt.com">
            Install</a> /
        📖 <a href="https://docs.autoclearchatgpt.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/autoclear-chatgpt-history/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/autoclear-chatgpt-history/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- BraveGPT -->
    <summary><a href="https://www.bravegpt.com">BraveGPT</a> - Adds AI chat & search summaries to Brave Search, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://www.bravegpt.com">
            <img width=511 src="https://assets.bravegpt.com/images/screenshots/desktop/bitcoin-query/darkmode.png?v=a0dd1de"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.bravegpt.com">
            Install</a> /
        📖 <a href="https://docs.bravegpt.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/bravegpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/bravegpt/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- ChatGPT Auto-Continue -->
    <summary><a href="https://www.chatgptautocontinue.com">ChatGPT Auto-Continue</a> - Automatically continue generating answers when ChatGPT responses get cut-off.</summary><br>
    <blockquote>
        <a href="https://www.chatgptautocontinue.com">
            <img width=600 src="https://assets.chatgptautocontinue.com/images/tiles/marquee/tile625x250.png?v=eb96a05"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptautocontinue.com">
            Install</a> /
        📖 <a href="https://docs.chatgptautocontinue.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-auto-continue/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-auto-continue/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- ChatGPT Auto Refresh -->
    <summary><a href="https://www.chatgptautorefresh.com">ChatGPT Auto Refresh</a> - Auto-sends background requests to keep sessions fresh & prevent Cloudflare checks + network errors.</summary><br>
    <blockquote>
        <a href="https://www.chatgptautorefresh.com">
            <img width=600 src="https://assets.chatgptautorefresh.com/images/screenshots/gm-toggle%2Bnotification.png?v=1406eb7"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptautorefresh.com">
            Install</a> /
        📖 <a href="https://docs.chatgptautorefresh.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-auto-refresh/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-auto-refresh/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- ChatGPT Auto-Talk -->
    <summary><a href="https://www.chatgptautotalk.com">ChatGPT Auto-Talk</a> - Automatically play ChatGPT responses.</summary><br>
    <blockquote>
        <a href="https://www.chatgptautotalk.com">
            <img width=300 src="https://assets.chatgptautotalk.com/images/screenshots/auto-talk-sidebar-toggle-enabled.png?v=4ff7545"></a>
        <a href="https://www.chatgptautotalk.com">
            <img width=300 src="https://assets.chatgptautotalk.com/images/screenshots/auto-talk-on-notif.png?v=4ff7545"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptautotalk.com">
            Install</a> /
        📖 <a href="https://docs.chatgptautotalk.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-auto-talk/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-auto-talk/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- ChatGPT Infinity -->
    <summary><a href="https://www.chatgptinfinity.com">ChatGPT Infinity</a> - Generate endless answers from all-knowing ChatGPT (on any topic!)</summary><br>
    <blockquote>
        <a href="https://www.chatgptinfinity.com">
            <img width=600 src="https://assets.chatgptinfinity.com/images/tiles/marquee/tile-625x250.png?v=4a7bac9"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptinfinity.com">
            Install</a> /
        📖 <a href="https://docs.chatgptinfinity.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-infinity/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-infinity/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- ChatGPT Widescreen -->
    <summary><a href="https://www.chatgptwidescreen.com">ChatGPT Widescreen</a> - Enhances ChatGPT with wide/full/tall-screen + spamblock modes. Also works on poe.com!</summary><br>
    <blockquote>
        <a href="https://www.chatgptwidescreen.com">
            <img width=600 src="https://assets.chatgptwidescreen.com/images/tiles/marquee/tile-625x250.png?v=91656d3"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptwidescreen.com">
            Install</a> /
        📖 <a href="https://docs.chatgptwidescreen.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-widescreen/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-widescreen/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- DuckDuckGPT -->
    <summary><a href="https://www.duckduckgpt.com">DuckDuckGPT</a> - Adds AI chat & search summaries to DuckDuckGo, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://www.duckduckgpt.com">
            <img width=511 src="https://assets.ddgpt.com/images/screenshots/desktop/how-to-becum-rich-query/lightmode.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.ddgpt.com">
            Install</a> /
        📖 <a href="https://docs.ddgpt.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/duckduckgpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/duckduckgpt/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GoogleGPT -->
    <summary><a href="https://www.googlegpt.io">GoogleGPT</a> - Adds AI chat & search summaries to Google Search, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://www.googlegpt.io">
            <img width=511 src="https://assets.googlegpt.io/images/screenshots/desktop/javascript-arrays-query/darkmode.png?v=a363ecf"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.googlegpt.io">
            Install</a> /
        📖 <a href="https://docs.googlegpt.io/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/googlegpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/googlegpt/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/discord/white/icon256.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/discord/icon256.png"></picture> Discord

<details> <!-- Undiscord -->
    <summary><a href="https://victornpb.github.io/undiscord/">Undiscord</a> - Delete all messages in a Discord channel or DM.</summary><br>
    <blockquote>
        <a href="https://victornpb.github.io/undiscord/">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@14311cb/assets/images/screenshots/scripts/undiscord.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/406540/Undiscord.user.js">
            Install</a> /
        📖 <a href="https://victornpb.github.io/undiscord/">
            Readme</a> /
        📢 <a href="https://github.com/victornpb/undiscord/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/victornpb/undiscord/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@438649d/assets/images/icons/symbols/display/white/icon256.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@438649d/assets/images/icons/symbols/display/black/icon256.png"></picture> Display

<details> <!-- Night Mode -->
    <summary><a href="https://greasyfork.org/scripts/424595-night-mode">Night Mode</a> - Adds a transparent dark layer depending on the time of the day to any website to make it less bright.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/424595-night-mode">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@438649d/assets/images/screenshots/scripts/night-mode.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/424595/Night%20Mode.user.js">
            Install</a> /
        📖 <a href="https://greasyfork.org/scripts/424595-night-mode">
            Readme</a> /
        📢 <a href="https://greasyfork.org/scripts/424595-night-mode/feedback">
            Discuss</a> /
        🐛 <a href="https://greasyfork.org/scripts/424595-night-mode/feedback">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/duckduckgo/white/icon32.png"><img height=18 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/duckduckgo/icon32.png"></picture> DuckDuckGo

<details> <!-- DuckDuckGPT -->
    <summary><a href="https://www.duckduckgpt.com">DuckDuckGPT</a> - Adds AI chat & search summaries to DuckDuckGo, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://www.duckduckgpt.com">
            <img width=511 src="https://assets.ddgpt.com/images/screenshots/desktop/how-to-becum-rich-query/lightmode.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.ddgpt.com">
            Install</a> /
        📖 <a href="https://docs.ddgpt.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/duckduckgpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/duckduckgpt/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/github/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/github/black/icon32.png"></picture> GitHub

<details> <!-- GitHub Commit Labels -->
    <summary><a href="https://github.com/nazdridoy/github-commit-labels">GitHub Commit Labels</a> - Add beautiful labels to conventional commits on GitHub.</summary><br>
    <blockquote>
        <a href="https://github.com/nazdridoy/github-commit-labels">
            <img width=600 src="https://cdn.jsdelivr.net/gh/nazdridoy/github-commit-labels@fa5457b/previews/commit-history.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/526153/GitHub%20Commit%20Labels.user.js">
            Install</a> /
        📖 <a href="https://github.com/nazdridoy/github-commit-labels/#readme">
            Readme</a> /
        📢 <a href="https://github.com/nazdridoy/github-commit-labels/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/nazdridoy/github-commit-labels/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GitHub Make Tooltips -->
    <summary><a href="https://greasyfork.org/scripts/22194">GitHub Make Tooltips</a> - Convert all titles into GitHub tooltips.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/22194">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/github-make-tooltips.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/22194/GitHub%20Make%20Tooltips.user.js">
            Install</a> /
        📖 <a href="https://greasyfork.org/en/scripts/22194-github-make-tooltips">
            Readme</a> /
        📢 <a href="https://greasyfork.org/en/scripts/22194-github-make-tooltips/feedback">
            Discuss</a> /
        🐛 <a href="https://greasyfork.org/en/scripts/22194-github-make-tooltips/feedback">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GitHub sort content -->
    <summary><a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-sort-content">GitHub sort content</a> - Sort lists and tables on GitHub.</summary><br>
    <blockquote>
        <a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-sort-content">
            <img width=411 src="https://cdn.jsdelivr.net/gh/Mottie/GitHub-userscripts@575e466/images/github-sort-content-table.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/Mottie/GitHub-userscripts/master/github-sort-content.user.js">
            Install</a> /
        📖 <a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-sort-content">
            Readme</a> /
        📢 <a href="https://github.com/Mottie/GitHub-userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/Mottie/GitHub-userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GitHub Star History -->
    <summary><a href="https://github.com/adamlui/github-star-history">GitHub Star History</a> - Adds star history chart to every repo's sidebar.</summary><br>
    <blockquote>
        <a href="https://github.com/adamlui/github-star-history">
            <img width=555 src="https://cdn.jsdelivr.net/gh/adamlui/github-star-history@c7bbf09/assets/images/screenshots/star-history-in-sidebar.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/adamlui/github-star-history/main/greasemonkey/github-star-history.user.js">
            Install</a> /
        📖 <a href="https://github.com/adamlui/github-star-history/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/github-star-history/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/github-star-history/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GitHub static time -->
    <summary><a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-static-time">GitHub static time</a> - Convert time ago into a time format of your choice.</summary><br>
    <blockquote>
        <a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-static-time">
            <img width=600 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/github-static-time.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/Mottie/GitHub-userscripts/master/github-static-time.user.js">
            Install</a> /
        📖 <a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-static-time">
            Readme</a> /
        📢 <a href="https://github.com/Mottie/GitHub-userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/Mottie/GitHub-userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GitHub toggle wiki sidebar -->
    <summary><a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-toggle-wiki-sidebar">GitHub toggle wiki sidebar</a> - Toggle wiki sidebar view.</summary><br>
    <blockquote>
        <a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-toggle-wiki-sidebar">
            <img width=600 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/github-toggle-wiki-sidebar.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/Mottie/GitHub-userscripts/master/github-toggle-wiki-sidebar.user.js">
            Install</a> /
        📖 <a href="https://github.com/Mottie/GitHub-userscripts/wiki/GitHub-toggle-wiki-sidebar">
            Readme</a> /
        📢 <a href="https://github.com/Mottie/GitHub-userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/Mottie/GitHub-userscripts/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/google/white/icon32.png"><img height=20 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/google/icon32.png"></picture> Google

<details> <!-- Classic Google Tabs -->
    <summary><a href="https://github.com/Kirlovon/classic-google-tabs">Classic Google Tabs</a> - Brings back the "Maps" tab and removes the "AI Mode" tab in Google Search.</summary><br>
    <blockquote>
        <a href="https://github.com/Kirlovon/classic-google-tabs">
            <img src="https://github.com/Kirlovon/classic-google-tabs/raw/main/assets/poster.webp"></a>
        <p>This is a simple Userscript that reworks Google Search navigation tabs by removing the "AI Mode" tab, restoring the "Maps" tab, and optionally removing the "Short videos" tab.</p>
    </blockquote>
    <blockquote>
        💾 <a href="https://github.com/Kirlovon/classic-google-tabs/raw/refs/heads/main/classic-google-tabs.user.js">
            Install</a> /
        📖 <a href="https://github.com/Kirlovon/classic-google-tabs/blob/main/README.md">
            Readme</a> /
        🐛 <a href="https://github.com/Kirlovon/classic-google-tabs/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Don't track me Google -->
    <summary><a href="https://github.com/Rob--W/dont-track-me-google">Don't track me Google</a> - Removes link conversion in Google Search/Maps links.</summary><br>
    <blockquote>
        <a href="https://github.com/Rob--W/dont-track-me-google">
            <img width=511 src="https://cdn.jsdelivr.net/gh/Rob--W/dont-track-me-google@a73ab8b/screenshot.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/428243/Don%27t%20track%20me%20Google.user.js">
            Install</a> /
        📖 <a href="https://github.com/Rob--W/dont-track-me-google/#readme">
            Readme</a> /
        📢 <a href="https://github.com/Rob--W/dont-track-me-google/issues">
            Discuss</a> /
        🐛 <a href="https://github.com/Rob--W/dont-track-me-google/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Endless Google -->
    <summary><a href="https://openuserjs.org/scripts/tumpio/Endless_Google">Endless Google</a> - Load more results automatically and endlessly.</summary><br>
    <blockquote>
        <a href="https://openuserjs.org/scripts/tumpio/Endless_Google">
            <img width=600 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/endless-google.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://openuserjs.org/install/tumpio/Endless_Google.user.js">
            Install</a> /
        📖 <a href="https://openuserjs.org/scripts/tumpio/Endless_Google">
            Readme</a> /
        📢 <a href="https://github.com/tumpio/gmscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/tumpio/gmscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- GoogleGPT -->
    <summary><a href="https://www.googlegpt.io">GoogleGPT</a> - Adds AI chat & search summaries to Google Search, powered by the latest LLMs.</summary><br>
    <blockquote>
        <a href="https://www.googlegpt.io">
            <img width=511 src="https://assets.googlegpt.io/images/screenshots/desktop/javascript-arrays-query/darkmode.png?v=a363ecf"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.googlegpt.io">
            Install</a> /
        📖 <a href="https://docs.googlegpt.io/#readme">
            Readme</a> /
        📢 <a href="https://github.com/KudoAI/googlegpt/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/KudoAI/googlegpt/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Share Google Slides controls -->
    <summary><a href="https://github.com/LostInBrittany/share-google-slides-control">Share Google Slides controls</a> - Remotely share the control of a Google Slides presentation.</summary><br>
    <blockquote>
        <a href="https://github.com/LostInBrittany/share-google-slides-control">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/share-google-slides-controls.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://github.com/LostInBrittany/share-google-slides-control/raw/refs/heads/main/userscript/shared-google-slides-control.user.js">
            Install</a> /
        📖 <a href="https://github.com/LostInBrittany/share-google-slides-control/#readme">
            Readme</a> /
        📢 <a href="https://github.com/LostInBrittany/share-google-slides-control/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/LostInBrittany/share-google-slides-control/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/just-eat/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/just-eat/icon32.png"></picture> Just Eat (UK)

<details> <!-- Just Eat Userscript -->
    <summary><a href="https://github.com/S4N-T0S/JustEat-userscript">Just Eat Userscript</a> - Adds dark mode and advanced filters to Just Eat UK.</summary><br>
    <blockquote>
        <a href="https://github.com/S4N-T0S/JustEat-userscript">
            <img width=511 src="https://cdn.jsdelivr.net/gh/S4N-T0S/JustEat-userscript@7905e8b/example.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://github.com/S4N-T0S/JustEat-userscript/raw/refs/heads/main/JustEat.user.js">
            Install</a> /
        📖 <a href="https://github.com/S4N-T0S/JustEat-userscript/#readme">
            Readme</a> /
        📢 <a href="https://github.com/S4N-T0S/JustEat-userscript/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/S4N-T0S/JustEat-userscript/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/link/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/link/black/icon32.png"></picture> Links

<details> <!-- Don't track me Google -->
    <summary><a href="https://github.com/Rob--W/dont-track-me-google">Don't track me Google</a> - Removes link conversion in Google Search/Maps links.</summary><br>
    <blockquote>
        <a href="https://github.com/Rob--W/dont-track-me-google">
            <img width=511 src="https://cdn.jsdelivr.net/gh/Rob--W/dont-track-me-google@a73ab8b/screenshot.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/428243/Don%27t%20track%20me%20Google.user.js">
            Install</a> /
        📖 <a href="https://github.com/Rob--W/dont-track-me-google/#readme">
            Readme</a> /
        📢 <a href="https://github.com/Rob--W/dont-track-me-google/issues">
            Discuss</a> /
        🐛 <a href="https://github.com/Rob--W/dont-track-me-google/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Linkify Plus Plus -->
    <summary><a href="https://github.com/eight04/linkify-plus-plus">Linkify Plus Plus</a> - Turn plain text URLs into links.</summary><br>
    <blockquote>
        <a href="https://github.com/eight04/linkify-plus-plus">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/linkify-plus-plus.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/4255/Linkify%20Plus%20Plus.user.js">
            Install</a> /
        📖 <a href="https://github.com/eight04/linkify-plus-plus/#readme">
            Readme</a> /
        📢 <a href="https://github.com/eight04/linkify-plus-plus/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/eight04/linkify-plus-plus/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Select text inside a link like Opera -->
    <summary><a href="https://github.com/eight04/select-text-inside-a-link-like-opera">Select text inside a link like Opera</a> - Disable link dragging and select text.</summary><br>
    <blockquote>
        <a href="https://github.com/eight04/select-text-inside-a-link-like-opera">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/select-text-inside-a-link-like-opera.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/789/Select%20text%20inside%20a%20link%20like%20Opera.user.js">
            Install</a> /
        📖 <a href="https://github.com/eight04/select-text-inside-a-link-like-opera/#readme">
            Readme</a> /
        📢 <a href="https://github.com/eight04/select-text-inside-a-link-like-opera/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/eight04/select-text-inside-a-link-like-opera/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/play/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/play/black/icon32.png"></picture> Media

<details> <!-- Double-click Image Downloader -->
    <summary><a href="https://greasyfork.org/scripts/469594-double-click-image-downloader">Double-click Image Downloader</a> - Double-click images to download them.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/469594-double-click-image-downloader">
            <img width=115 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@7ab5796/assets/images/screenshots/scripts/double-click-image-downloader/double-click-img.gif"></a>
        <a href="https://greasyfork.org/scripts/469594-double-click-image-downloader">
            <img width=313 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@7ab5796/assets/images/screenshots/scripts/double-click-image-downloader/download-notif.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/469594/Double-click%20Image%20Downloader.user.js">
            Install</a> /
        📖 <a href="https://greasyfork.org/scripts/469594-double-click-image-downloader">
            Readme</a> /
        📢 <a href="https://greasyfork.org/scripts/469594-double-click-image-downloader/feedback">
            Discuss</a> /
        🐛 <a href="https://greasyfork.org/scripts/469594-double-click-image-downloader/feedback">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Image Max URL -->
    <summary><a href="https://github.com/qsniyg/maxurl">Image Max URL</a> - Finds larger or original versions of images/videos for thousands of supported websites, including a customizable image popup feature.</summary><br>
    <blockquote>
        <a href="https://github.com/qsniyg/maxurl">
            <img width=511 src="https://i.imgur.com/cGtifHN.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://github.com/qsniyg/maxurl/blob/master/userscript_smaller.user.js?raw=true">
            Install Stable Build</a> /
        💾 <a href="https://github.com/qsniyg/maxurl/blob/master/userscript.user.js?raw=true">
            Install Dev Build</a> /
        📖 <a href="https://github.com/qsniyg/maxurl/#readme">
            Readme</a> /
        📢 <a href="https://github.com/qsniyg/maxurl/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/qsniyg/maxurl/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Mouseover Popup Image Viewer -->
    <summary><a href="https://github.com/tophf/mpiv">Mouseover Popup Image Viewer</a> - An updated fork of MPIV, maintained by one of Violentmonkey's developers.</summary><br>
    <blockquote>
        <a href="https://github.com/tophf/mpiv">
            <img width=311 src="https://i.imgur.com/A7hplWg.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/394820/Mouseover%20Popup%20Image%20Viewer.user.js">
            Install</a> /
        📖 <a href="https://github.com/tophf/mpiv/#readme">
            Readme</a> /
        📢 <a href="https://github.com/tophf/mpiv/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/tophf/mpiv/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Picviewer CE+ -->
    <summary><a href="https://greasyfork.org/scripts/24204-picviewer-ce">Picviewer CE+</a> - Powerful picture viewing tool which can popup/scale/rotate/batch save pictures automatically.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/24204-picviewer-ce">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/picviewer-ce+.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/24204/Picviewer%20CE%2B.user.js">
            Install</a> /
        📖 <a href="https://github.com/hoothin/UserScripts/tree/master/Picviewer%20CE%2B/#readme">
            Readme</a> /
        📢 <a href="https://github.com/hoothin/UserScripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/hoothin/UserScripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Show and reload broken images -->
    <summary><a href="https://greasyfork.org/scripts/790-show-and-reload-broken-images">Show and reload broken images</a> - Show and reload broken images, even when it contains "alt" tag.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/790-show-and-reload-broken-images">
            <img width=411 src="https://i.imgur.com/EwrhEpi.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/790/Show%20and%20reload%20broken%20images.user.js">
            Install</a> /
        📖 <a href="https://github.com/eight04/show-and-reload-broken-images/#readme">
            Readme</a> /
        📢 <a href="https://github.com/eight04/show-and-reload-broken-images/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/eight04/show-and-reload-broken-images/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/nav/white/icon32.png"><img height=12 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/nav/black/icon32.png"></picture> Navigation

<details> <!-- Endless Google -->
    <summary><a href="https://openuserjs.org/scripts/tumpio/Endless_Google">Endless Google</a> - Load more results automatically and endlessly.</summary><br>
    <blockquote>
        <a href="https://openuserjs.org/scripts/tumpio/Endless_Google">
            <img width=600 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/endless-google.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://openuserjs.org/install/tumpio/Endless_Google.user.js">
            Install</a> /
        📖 <a href="https://openuserjs.org/scripts/tumpio/Endless_Google">
            Readme</a> /
        📢 <a href="https://github.com/tumpio/gmscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/tumpio/gmscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Pagetual -->
    <summary><a href="https://pagetual.hoothin.com">Pagetual</a> - Add seamless infinite scrolling to thousands of sites.</summary><br>
    <blockquote>
        <a href="https://pagetual.hoothin.com">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@04d117d/assets/images/screenshots/scripts/pagetual.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/438684/Pagetual.user.js">
            Install</a> /
        📖 <a href="https://pagetual.hoothin.com/infinite-scrolling-auto-page.html">
            Readme</a> /
        📢 <a href="https://github.com/hoothin/UserScripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/hoothin/UserScripts/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/password/white/icon32.png"><img height=15 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/password/black/icon32.png"></picture> Passwords

<details> <!-- Show Password onMouseOver -->
    <summary><a href="https://greasyfork.org/scripts/32-show-password-onmouseover">Show Password onMouseOver</a> - Show password when mouseover on password field.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/32-show-password-onmouseover">
            <img width=311 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/show-password-onmouseover.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/32/Show%20Password%20onMouseOver.user.js">
            Install</a> /
        📢 <a href="https://greasyfork.org/scripts/32-show-password-onmouseover/feedback#post-discussion">
            Discuss</a> /
        🐛 <a href="https://greasyfork.org/scripts/32-show-password-onmouseover/feedback#post-discussion">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/incognito/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/incognito/black/icon32.png"></picture> Privacy

<details> <!-- Autoclear ChatGPT History -->
    <summary><a href="https://www.autoclearchatgpt.com">Autoclear ChatGPT History</a> - Auto-clears chat history when visiting chatgpt.com for maximum privacy.</summary><br>
    <blockquote>
        <a href="https://www.autoclearchatgpt.com">
            <img width=511 src="https://assets.autoclearchatgpt.com/images/screenshots/demo.png?v=4f5c5fa"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.autoclearchatgpt.com">
            Install</a> /
        📖 <a href="https://docs.autoclearchatgpt.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/autoclear-chatgpt-history/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/autoclear-chatgpt-history/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Don't track me Google -->
    <summary><a href="https://github.com/Rob--W/dont-track-me-google">Don't track me Google</a> - Removes link conversion in Google Search/Maps links.</summary><br>
    <blockquote>
        <a href="https://github.com/Rob--W/dont-track-me-google">
            <img width=511 src="https://cdn.jsdelivr.net/gh/Rob--W/dont-track-me-google@a73ab8b/screenshot.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/428243/Don%27t%20track%20me%20Google.user.js">
            Install</a> /
        📖 <a href="https://github.com/Rob--W/dont-track-me-google/#readme">
            Readme</a> /
        📢 <a href="https://github.com/Rob--W/dont-track-me-google/issues">
            Discuss</a> /
        🐛 <a href="https://github.com/Rob--W/dont-track-me-google/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Undiscord -->
    <summary><a href="https://victornpb.github.io/undiscord/">Undiscord</a> - Delete all messages in a Discord channel or DM.</summary><br>
    <blockquote>
        <a href="https://victornpb.github.io/undiscord/">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@14311cb/assets/images/screenshots/scripts/undiscord.gif"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/406540/Undiscord.user.js">
            Install</a> /
        📖 <a href="https://victornpb.github.io/undiscord/">
            Readme</a> /
        📢 <a href="https://github.com/victornpb/undiscord/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/victornpb/undiscord/issues">
            Report bug</a>
    </blockquote>
</details>

### <img height=19 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@4594000/assets/images/icons/sites/quora/icon32.png"> Quora

<details> <!-- Block Quora Poe -->
    <summary><a href="https://github.com/adamlui/userscripts/blob/master/block-quora-poe/#readme">Block Quora Poe</a> - Blocks low-quality AI + Promoted/Sponsored answers from Quora.</summary><br>
    <blockquote>
        <a href="https://github.com/adamlui/userscripts/blob/master/block-quora-poe/#readme">
            <img width=511 src="https://cdn.jsdelivr.net/gh/adamlui/userscripts@a1eefef/block-quora-poe/assets/images/screenshots/demo.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/adamlui/userscripts/master/block-quora-poe/block-quora-poe.user.js">
            Install</a> /
        📖 <a href="https://github.com/adamlui/userscripts/blob/master/block-quora-poe/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

### <img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@66d5192/assets/images/icons/sites/reddit/icon32.png"> Reddit

<details> <!-- Reddit Tab Icons & Title Prefix -->
    <summary><a href="https://github.com/sinazadeh/userscripts/blob/main/Reddit_Tab_Icons_Title_Prefix.readme.md">Reddit Tab Icons & Title Prefix</a> - Adds subreddit icons to Reddit tabs and prefixes the tab title with the subreddit name (e.g., `r/SubredditName`) for easier tab identification and navigation.</summary><br>
    <blockquote>
        <a href="https://github.com/sinazadeh/userscripts/blob/main/Reddit_Tab_Icons_Title_Prefix.readme.md">
            <img src="https://github.com/user-attachments/assets/5c1d4f50-45f4-4ee2-a3ee-08fd4acbc5a1"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/sinazadeh/userscripts/refs/heads/main/Reddit_Tab_Icons_Title_Prefix.user.js">
            Install</a> /
        📖 <a href="https://github.com/sinazadeh/userscripts/blob/main/Reddit_Tab_Icons_Title_Prefix.readme.md">
            Readme</a> /
        📢 <a href="https://github.com/sinazadeh/userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/sinazadeh/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

### <img height=19 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@ec34eea/assets/images/icons/sites/stremio/icon32.png"> Stremio

<details> <!-- Google Search: Stremio Links -->
    <summary><a href="https://github.com/sinazadeh/userscripts/blob/main/Google_Search_Stremio_Links.readme.md">Google Search: Stremio Links</a> - Adds convenient "Watch on Stremio" buttons (App & Web) next to IMDb links in Google search results.</summary><br>
    <blockquote>
        <a href="https://github.com/sinazadeh/userscripts/blob/main/Google_Search_Stremio_Links.readme.md">
            <img src="https://github.com/user-attachments/assets/106e9aeb-b649-4096-b3c6-ffc3ad23490f"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/sinazadeh/userscripts/refs/heads/main/Google_Search_Stremio_Links.user.js">
            Install</a> /
        📖 <a href="https://github.com/sinazadeh/userscripts/blob/main/Google_Search_Stremio_Links.readme.md">
            Readme</a> /
        📢 <a href="https://github.com/sinazadeh/userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/sinazadeh/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- Letterboxd Link Badges -->
    <summary><a href="https://github.com/sinazadeh/userscripts/blob/main/Letterboxd_Link_Badges.readme.md">Letterboxd Link Badges</a> Enhances Letterboxd film pages by replacing IMDb/TMDb text links with icons and adding direct "Watch on Stremio" badges.</summary><br>
    <blockquote>
        <a href="https://github.com/sinazadeh/userscripts/blob/main/Letterboxd_Link_Badges.readme.md">
            <img src="https://github.com/user-attachments/assets/c389af0c-6dd7-41d6-8695-d1bbfc7c5004"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/sinazadeh/userscripts/refs/heads/main/Letterboxd_Link_Badges.user.js">
            Install</a> /
        📖 <a href="https://github.com/sinazadeh/userscripts/blob/main/Letterboxd_Link_Badges.readme.md">
            Readme</a> /
        📢 <a href="https://github.com/sinazadeh/userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/sinazadeh/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/soundwaves/white/icon32.png"><img height=18 width=21 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/soundwaves/black/icon32.png"></picture> Text-to-speech

<details> <!-- ChatGPT Auto-Talk -->
    <summary><a href="https://www.chatgptautotalk.com">ChatGPT Auto-Talk</a> - Automatically play ChatGPT responses.</summary><br>
    <blockquote>
        <a href="https://www.chatgptautotalk.com">
            <img width=300 src="https://assets.chatgptautotalk.com/images/screenshots/auto-talk-sidebar-toggle-enabled.png?v=4ff7545"></a>
        <a href="https://www.chatgptautotalk.com">
            <img width=300 src="https://assets.chatgptautotalk.com/images/screenshots/auto-talk-on-notif.png?v=4ff7545"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptautotalk.com">
            Install</a> /
        📖 <a href="https://docs.chatgptautotalk.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-auto-talk/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-auto-talk/issues">
            Report bug</a>
    </blockquote>
</details>


### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/translate/white/icon32.png"><img height=16 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/symbols/translate/black/icon32.png"></picture> Translation

<details> <!-- Immersive Translate -->
    <summary><a href="https://immersivetranslate.com/">Immersive Translate</a> - Translates text on any page.</summary><br>
    <blockquote>
        <a href="https://immersivetranslate.com/">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/immersive-translate.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.chatgptautotalk.com">
            Install</a> /
        📖 <a href="https://docs.chatgptautotalk.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/chatgpt-auto-talk/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/chatgpt-auto-talk/issues">
            Report bug</a>
    </blockquote>
</details>


### <img height=16 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@5c23f68/assets/images/icons/sites/xbox/icon32.png"> Xbox

<details> <!-- Xbox PriceLens -->
<summary><a href="https://github.com/sinazadeh/userscripts/blob/main/Xbox_PriceLens.readme.md">Xbox PriceLens</a> - Add prices to Xbox game pages for every country.</summary><br>
    <blockquote>
        <a href="https://github.com/sinazadeh/userscripts/blob/main/Xbox_PriceLens.readme.md">
            <img alt="image" src="https://github.com/user-attachments/assets/0a187c6a-ffa4-44de-9e06-02b9837a4fd7" /></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://raw.githubusercontent.com/sinazadeh/userscripts/refs/heads/main/Xbox_PriceLens.user.js">
            Install</a> /
        📖 <a href="https://github.com/sinazadeh/userscripts/blob/main/Xbox_PriceLens.readme.md">
            Readme</a> /
        📢 <a href="https://github.com/sinazadeh/userscripts/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/sinazadeh/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

### <picture><source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/youtube/white/icon32.png"><img height=17 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@f11c95f/assets/images/icons/sites/youtube/icon32.png"></picture> YouTube

<details> <!-- Simple Sponsor Skipper -->
    <summary><a href="https://greasyfork.org/scripts/453320-simple-sponsor-skipper">Simple Sponsor Skipper</a> - Skips annoying intros, sponsors & filler using the SponsorBlock API. Compatible w/ YouTube, Invidious, CloudTube & Odysee.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/453320-simple-sponsor-skipper">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/screenshots/scripts/simple-sponsor-skipper.png?v=96092ef"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://codeberg.org/mthsk/userscripts/raw/branch/master/simple-sponsor-skipper/simple-sponsor-skipper.user.js">
            Install</a> /
        📖 <a href="https://greasyfork.org/scripts/453320-simple-sponsor-skipper">
            Readme</a> /
        📢 <a href="https://codeberg.org/mthsk/userscripts/issues">
            Discuss</a> /
        🐛 <a href="https://codeberg.org/mthsk/userscripts/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- YouTube Classic -->
    <summary><a href="https://www.ytclassic.com">YouTube Classic</a> - Reverts YouTube to its classic design (unround corners, restore dislikes + remove/redirect Shorts) + block thumbnail/masthead ads.</summary><br>
    <blockquote>
        <a href="https://www.ytclassic.com">
            <img width=511 src="https://assets.ytclassic.com/images/screenshots/youtube-classic-ui.png?v=6de3a93"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gm.ytclassic.com">
            Install</a> /
        📖 <a href="https://docs.ytclassic.com/#readme">
            Readme</a> /
        📢 <a href="https://github.com/adamlui/youtube-classic/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/adamlui/youtube-classic/issues">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- YouTube Commenter Names -->
    <summary><a href="https://gist.github.com/lumynou5/74bcbab54cd9d8fcd3c873fffbac5d3d">YouTube Commenter Names</a> - Make YouTube display the names of commenters instead of their handles.</summary><br>
    <blockquote>
        <a href="https://gist.github.com/lumynou5/74bcbab54cd9d8fcd3c873fffbac5d3d">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@00884ad/assets/images/screenshots/scripts/youtube-commenter-names.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://gist.github.com/lumynou5/74bcbab54cd9d8fcd3c873fffbac5d3d/raw/youtube-commenter-names.user.js">
            Install</a> /
        📢 <a href="https://gist.github.com/lumynou5/74bcbab54cd9d8fcd3c873fffbac5d3d">
            Discuss</a> /
        🐛 <a href="https://gist.github.com/lumynou5/74bcbab54cd9d8fcd3c873fffbac5d3d">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- YouTube Disable Autoplaying -->
    <summary><a href="https://gist.github.com/lumynou5/b036f405a0888bf9c3b9a3f560e36f3d">YouTube Disable Autoplaying</a> - Disable YouTube autoplaying everywhere.</summary><br>
    <blockquote>
        <p>This prevents playlists, shorts, and hovered videos on the home page from autoplaying.</p>
    </blockquote>
    <blockquote>
        💾 <a href="https://gist.github.com/lumynou5/b036f405a0888bf9c3b9a3f560e36f3d/raw/youtube-disable-autoplaying.user.js">
            Install</a> /
        📢 <a href="https://gist.github.com/lumynou5/b036f405a0888bf9c3b9a3f560e36f3d">
            Discuss</a> /
        🐛 <a href="https://gist.github.com/lumynou5/b036f405a0888bf9c3b9a3f560e36f3d">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- YouTube HD Premium -->
    <summary><a href="https://greasyfork.org/scripts/498145-youtube-hd-premium">YouTube HD Premium</a> - Automatically switches to your pre-selected resolution. Enables premium when possible.</summary><br>
    <blockquote>
        <a href="https://greasyfork.org/scripts/498145-youtube-hd-premium">
            <img width=511 src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@ac8f308/assets/images/screenshots/scripts/youtube-hd-premium.png"></a>
    </blockquote>
    <blockquote>
        💾 <a href="https://update.greasyfork.org/scripts/498145/Youtube%20HD%20Premium.user.js">
            Install</a> /
        📢 <a href="https://greasyfork.org/scripts/498145-youtube-hd-premium/feedback">
            Discuss</a> /
        🐛 <a href="https://greasyfork.org/scripts/498145-youtube-hd-premium/feedback">
            Report bug</a>
    </blockquote>
</details>

<details> <!-- YouTube Play All -->
    <summary><a href="https://github.com/RobertWesner/YouTube-Play-All">YouTube Play All</a> - Returns the classic "Play All" button for not just videos, but also shorts and livestreams.</summary><br>
    <blockquote>
        <a href="https://github.com/RobertWesner/YouTube-Play-All">
            <picture>
                <source type="image/png" media="(prefers-color-scheme: dark)" srcset="https://cdn.jsdelivr.net/gh/RobertWesner/YouTube-Play-All@213bbb8/readme/screenshot_dark.png">
                <img width=511 src="https://cdn.jsdelivr.net/gh/RobertWesner/YouTube-Play-All@213bbb8/readme/screenshot.png">
            </picture>
        </a>
    </blockquote>
    <blockquote>
        💾 <a href="https://github.com/RobertWesner/YouTube-Play-All/raw/main/script.user.js">
            Install</a> /
        📖 <a href="https://github.com/RobertWesner/YouTube-Play-All/#readme">
            Readme</a> /
        📢 <a href="https://github.com/RobertWesner/YouTube-Play-All/discussions">
            Discuss</a> /
        🐛 <a href="https://github.com/RobertWesner/YouTube-Play-All/issues">
            Report bug</a>
    </blockquote>
</details>

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Tutorials

  - [Greasemonkey Hacks](https://www.oreilly.com/library/view/greasemonkey-hacks/0596101651/pr05s02.html) - Complete wiki book on Userscripts.
  - [Greasemonkey Tutorial for Beginners](http://hayageek.com/greasemonkey-tutorial/) - How to create simple Userscripts and installing it using Greasemonkey.
  - [Video - GreaseMonkey Userscript Development](https://www.youtube.com/watch?v=hAeWOOJPp0o)

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Additional Catalogues

* [UserScripts Mirror](http://userscripts-mirror.org/) - Mirror of the original Userscripts.org repository (that is currently down).
* [Greasy Fork](https://greasyfork.org/)
* [OpenUserJS](https://openuserjs.org/)

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Community

* [Stack Overflow](https://stackoverflow.com/questions/tagged/userscripts)
* [`#greasemonkey` on Freenode](http://webchat.freenode.net/?channels=greasemonkey)
* [`r/userscripts` on Reddit](https://www.reddit.com/r/userscripts/)

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Contributing

Contributions are very welcome!

Please have a look at [CONTRIBUTING](https://github.com/awesome-scripts/awesome-userscripts/blob/master/CONTRIBUTING.md) for guidelines.

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## Top Contributors
![Top Contributors widget](https://embeddables.devactivity.com/orgs/awesome-scripts/a53c359f-f5a4-4f42-8542-4d0c78d27fad.svg)

<sup><sub>Check also our [Public Dashboard](https://app.devactivity.com/public/?organizationLogin=awesome-scripts) powered by [devActivity](https://devactivity.com/?ref=public_widget)</sub></sup>

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## License

[![CC0](http://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts@8e22f63/assets/images/badges/zero-1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, contributors have waived all copyright and related or neighboring rights to this work.

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/gradient-aqua.png">

## ⭐ Star History

<div align="center">

<a href="https://github.com/awesome-scripts/awesome-userscripts/stargazers">
    <picture>
        <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=awesome-scripts/awesome-userscripts&type=Timeline&theme=dark" />
        <img width=665 src="https://api.star-history.com/svg?repos=awesome-scripts/awesome-userscripts&type=Timeline" />
    </picture>
</a>

<br>

</div>

<img height=6px width="100%" src="https://cdn.jsdelivr.net/gh/awesome-scripts/awesome-userscripts/assets/images/separators/rainbow-blue-to-red.png">

[Back to top ↑](#top)
