<!--
  **********************************************************************
  ***                DO NOT MODIFY THIS FILE DIRECTLY                ***
  **********************************************************************
   The original copy of this file is in the beeware/.github repository.
   It will be automatically copied into other BeeWare repositories when
   the original is altered. Any changes should be made to the original.
  **********************************************************************
-->

# BeeWare Community Code of Conduct

## Our pledge <a name="our-pledge"></a>

We pledge to make our community welcoming, safe, and equitable for all.

We are committed to fostering an environment that respects and promotes the dignity, rights, and contributions of all individuals, regardless of characteristics including race, ethnicity, caste, color, age, physical characteristics, neurodiversity, disability, sex or gender, gender identity or expression, sexual orientation, language, philosophy or religion, national or social origin, socio-economic position, level of education, or other status. The same privileges of participation are extended to everyone who participates in good faith and in accordance with this Covenant.

The guidelines within and enforcement of the BeeWare Community Code of Conduct apply equally to everyone participating in the BeeWare community, including members of the Code of Conduct Response Team.

## Encouraged behaviors <a name="encouraged-behaviors"></a>

While acknowledging differences in social norms, we all strive to meet our community's expectations for positive behavior. We also understand that our words and actions may be interpreted differently than we intend based on culture, background, or native language.

With these considerations in mind, we agree to behave mindfully toward each other and act in ways that center our shared values, including:

  1. Respecting the **purpose of our community**, our activities, and our ways of gathering.
  2. Engaging **kindly and honestly** with others.
  3. Respecting **different viewpoints** and experiences.
  4. **Taking responsibility** for our actions and contributions.
  5. Gracefully giving and accepting **constructive feedback**.
  6. Committing to **repairing harm** when it occurs.
  7. Behaving in other ways that promote and sustain the **well-being of our community**.

## Restricted behaviors <a name="restricted-behaviors"></a>

We agree to restrict the following behaviors in our community. Instances, threats, and promotion of these behaviors are violations of this Code of Conduct.

  1. **Harassment.** Violating explicitly expressed boundaries or engaging in unnecessary personal attention after any clear request to stop.
  2. **Character attacks.** Making insulting, demeaning, or pejorative comments directed at a community member or group of people.
  3. **Stereotyping or discrimination.** Characterizing anyone’s personality or behavior on the basis of a personal identity or trait.
  4. **Sexualization.** Behaving in a way that would generally be considered inappropriately intimate in the context or purpose of the community.
  5. **Violating confidentiality.** Sharing or acting on someone's personal or private information without their permission.
  6. **Endangerment.** Causing, encouraging, or threatening violence or other harm toward any person or group.
  7. Behaving in other ways that **threaten the well-being** of our community.

### Other restrictions <a name="other-restrictions"></a>

  1. **Misleading identity.** Impersonating someone else for any reason, or pretending to be someone else to evade enforcement actions.
  2. **Misrepresenting project affiliation.** Speaking or acting in a way that implies an official affiliation with the BeeWare project, where one does not exist.
  3. **Failing to credit sources.** Not properly crediting the sources of content you contribute.
  4. **Promotional materials.** Sharing marketing or other commercial content in a way that is outside the norms of the community.
  5. **Excessive communication.** Disrespecting the time and space of others by engaging in an unacceptable volume of communication.
  6. **Unhelpful communication.** Offering opinions without relevant experience in the topic being discussed, entering into an ongoing discussion without first gaining familiarity with the history of the topic, or making contributions that are off-topic or otherwise distracting.
  7. **Irresponsible messaging.** Presenting content which includes, links, or describes other restricted behaviors without a relevant reason and appropriate prior warnings for consumers of that content.
  8. Other conduct that could reasonably be considered **unprofessional or inappropriate**.

## Reporting an issue <a name="reporting-an-issue"></a>

Tensions can occur between community members even when they are trying their best to collaborate. Not every conflict represents a code of conduct violation, and this Code of Conduct reinforces encouraged behaviors and norms that can help avoid conflicts and minimize harm. Reporting even minor issues is important, as they can be helpful in identifying patterns of behavior that may not be concerning in isolation, but when viewed collectively may be more significant.

When an incident does occur, it is important to report it promptly to the BeeWare Code of Conduct Response Team.

**If you believe you or anyone else is in physical danger, please notify appropriate law enforcement first.**

To report a possible violation, email the Team at [conduct@beeware.org](mailto:conduct@beeware.org). If necessary, you can reach out to individual team members. On the BeeWare Discord server, you can also direct message anyone on the Response Team, or, if appropriate, mention `@moderators` in a public channel. Team members can be reached by the following usernames on Discord or GitHub, or the provided email addresses:

  * Russell Keith-Magee (@freakboy3742; [russell@beeware.org](mailto:russell@beeware.org))
  * Kattni (@kattni; [kattni@beeware.org](mailto:kattni@beeware.org))
  * Katie McLaughlin (@glasnt; [katie@beeware.org](mailto:katie@beeware.org))
  * Philip James (@phildini; [philip@beeware.org](mailto:philip@beeware.org))
  * Charles Whittington (@HalfWhitt; [charles@beeware.org](mailto:charles@beeware.org))

The Response Team takes reports of violations seriously and will make every effort to respond in a timely manner. They will investigate all reports of code of conduct violations, reviewing messages, logs, and recordings, or interviewing witnesses and other participants. The Team will keep investigation and enforcement actions as transparent as possible while prioritizing safety and confidentiality. In order to honor these values, enforcement actions are carried out in private with the involved parties, but communicating to the whole community may be part of a mutually agreed upon resolution. If we determine that a public statement needs to be made, the identities of all victims and reporters will remain confidential unless those individuals instruct us otherwise.

In your report, please include:

  * **Your contact info** so we can get in touch with you if we need to follow up.
  * **Names (real, nicknames, or pseudonyms) of any individuals involved.** If there were other witnesses besides you, please try to include them as well.
  * **When and where the incident occurred.** Please be as specific as possible.
  * **Your account of what occurred.** If there is a publicly available record (e.g. a Discord or GitHub message) please include a link.
  * **Any extra context** you believe existed for the incident.
  * **If you believe this incident is ongoing.**
  * **If you believe any member of the Response Team has a conflict of interest** in adjudicating the incident.
  * **What, if any, corrective response** you believe would be appropriate.
  * **Any other information** you believe we should have.

Code of Conduct Response Team members are obligated to maintain confidentiality with regard to the reporter and details of an incident.

## The Response Team's report followup <a name="report-followup"></a>

You will receive a response acknowledging receipt of your report. We promise to acknowledge receipt within 24 hours (and will aim for much quicker than that).

The Response Team will immediately meet to review the incident and determine:

  * What happened.
  * Whether this event constitutes a code of conduct violation.
  * Who the reported person is.
  * Whether this is an ongoing situation, or if there is a threat to anyone's physical safety.
  * If this is determined to be an ongoing incident or a threat to physical safety, the Response Team's immediate priority will be to protect everyone involved. This means we may delay an official response until we believe that the situation has concluded and that everyone is physically safe.
  * If a member of the Response Team is one of the named parties, they will not be included in any discussions, and will not be provided with any confidential details from the reporter.

If anyone on the Response Team believes they have a conflict of interest in adjudicating on a reported issue, they will inform the other Response Team members, and recuse themselves from any discussion about the issue. Following this declaration, they will not be provided with any confidential details from the reporter.

We'll respond within one week to the person who filed the report with either a resolution or an explanation of why the situation is not yet resolved.

Once we've determined our final action, we'll contact the original reporter to let them know what action (if any) we'll be taking. We'll take into account feedback from the reporter on the appropriateness of our response, but we don't guarantee we'll act on it.

Finally, to maintain transparency in the reporting and enforcement process, whenever possible, the Response Team will make a public report of the incident on [The Buzz](https://beeware.org/news/buzz), the BeeWare blog. A public report may not be made if the specifics of the incident do not allow us to preserve anonymity, or if there is potential for ongoing harm.

## Enforcement: addressing and repairing harm <a name="enforcement"></a>

If an investigation by the Response Team finds that this Code of Conduct has been violated, the following enforcement ladder may be used to determine how best to repair harm, based on the incident's impact on the individuals involved and the community as a whole. Depending on the severity of a violation, lower rungs on the ladder may be skipped.

  1. Warning
     * Event: A violation involving a single incident or series of incidents.
     * Consequence: A private, written warning from the Response Team.
     * Repair: Examples of repair include a private written apology, acknowledgement of responsibility, and seeking clarification on expectations.

  2. Temporarily Limited Activities
     * Event: A repeated incidence of a violation that previously resulted in a warning, or the first incidence of a more serious violation.
     * Consequence: A private, written warning with a time-limited cooldown period designed to underscore the seriousness of the situation and give the community members involved time to process the incident. The cooldown period may be limited to particular communication channels or interactions with particular community members.
     * Repair: Examples of repair may include making an apology, using the cooldown period to reflect on actions and impact, and being thoughtful about re-entering community spaces after the period is over.

  3. Temporary Suspension
     * Event: A pattern of repeated violation which the Response Team has tried to address with warnings, or a single serious violation.
     * Consequence: A private written warning with conditions for return from suspension. In general, temporary suspensions give the person being suspended time to reflect upon their behavior and possible corrective actions. Suspensions will be based on where the violation occurs, and may be limited to the space in which the violation occurs. In the event of a more serious violation, the suspension may apply to all spaces.
     * Repair: Examples of repair include respecting the spirit of the suspension, meeting the specified conditions for return, and being thoughtful about how to reintegrate with the community when the suspension is lifted.

  4. Permanent Ban
     * Event: A pattern of repeated code of conduct violations that other steps on the ladder have failed to resolve, or a violation so serious that the Response Team determines there is no way to keep the community safe with this person as a member.
     * Consequence: Access to all community spaces, tools, and communication channels is removed. In general, permanent bans should be rarely used, should have strong reasoning behind them, and should only be resorted to if working through other remedies has failed to change the behavior.
     * Repair: There is no possible repair in cases of this severity.

This enforcement ladder is intended as a guideline. It does not limit the ability of Community Managers to use their discretion and judgment, in keeping with the best interests of our community.

## Scope <a name="scope"></a>

This Code of Conduct applies within all community spaces, including GitHub, the BeeWare Discord server, and in-person events, such as conferences, meetups, and sprints. It also applies when an individual is officially representing the community in public or other spaces. Examples of representing our community include using an official email address, posting via an official social media account, or acting as an appointed representative at an online or offline event.

Behavior outside of official BeeWare spaces may also be considered as supporting evidence for a report if that behavior establishes a pattern, or represents a potential risk to the BeeWare community.

This Code of Conduct operates in parallel to any Code of Conduct that is in effect in a given context (e.g., the Code of Conduct for a conference). If an incident occurs, we encourage reporting that incident to all relevant conduct groups. Known violations of other Codes of Conduct may be considered as supporting evidence for a report under this Code of Conduct. The BeeWare Code of Conduct Response Team will cooperate with other Code of Conduct teams, but will not disclose any identifying details without the prior consent of the reporting party.
## Attribution <a name="attribution"></a>

This Code of Conduct is adapted from the Contributor Covenant, version 3.0, permanently available at [https://www.contributor-covenant.org/version/3/0/](https://www.contributor-covenant.org/version/3/0/).

Contributor Covenant is stewarded by the Organization for Ethical Source and licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

For answers to common questions about Contributor Covenant, see the [FAQ](https://www.contributor-covenant.org/faq). [Translations](https://www.contributor-covenant.org/translations) are provided. There are [additional enforcement and community guideline resources](https://www.contributor-covenant.org/resources). The enforcement ladder was inspired by the work of [Mozilla’s code of conduct team](https://github.com/mozilla/inclusion).

## Changes <a name="changes"></a>

Major substantive changes are listed here; for a complete list of changes see the GitHub commit history.

  * **December 15, 2025:** Updated to adapt the Contributor Covenant, version 3.0, with some modifications for BeeWare-specific guidelines and procedures.

  * **July 4, 2016:** Added instructions and guidelines for reporting incidents.

  * **December 5, 2015:** Initial Code of Conduct adopted.
