# Toga

[![Python Versions](https://img.shields.io/pypi/pyversions/toga-core.svg)](https://pypi.python.org/pypi/toga-core)
[![BSD-3-Clause License](https://img.shields.io/pypi/l/toga-core.svg)](https://github.com/beeware/toga-core/blob/main/LICENSE)
[![Project status](https://img.shields.io/pypi/status/toga-core.svg)](https://pypi.python.org/pypi/toga-core)

A Python native, OS native GUI toolkit.

This package provides the core Toga API. In order to use Toga, you'll also need to install a backend that implements the core Toga API for that platform:

- **Android** [toga-android](https://pypi.org/project/toga-android)
- **iOS** [toga-iOS](https://pypi.org/project/toga-iOS)
- **Linux** [toga-gtk](https://pypi.org/project/toga-gtk)
- **macOS** [toga-cocoa](https://pypi.org/project/toga-cocoa)
- **Qt** [toga-textual](https://pypi.org/project/toga-qt)
- **Textual** [toga-textual](https://pypi.org/project/toga-textual)
- **Web** [toga-web](https://pypi.org/project/toga-web)
- **Windows** [toga-winforms](https://pypi.org/project/toga-winforms)

## Minimum requirements

  Each backend has specific requirements and pre-requisites. See the [platform documentation](https://toga.beeware.org/en/latest/reference/platforms/) for details.

## Quickstart

To get a demonstration of the capabilities of Toga, run the following:

    $ python -m pip install toga-demo
    $ toga-demo

This will pop up a GUI window with some sample widgets.

## Documentation

  Documentation for Toga can be found on [Read The Docs](https://toga.beeware.org).

## Community

Toga is part of the [BeeWare suite](https://beeware.org). You can talk to the community through:

- [@beeware@fosstodon.org on Mastodon](https://fosstodon.org/@beeware)
- [Discord](https://beeware.org/bee/chat/)
- The Toga [GitHub Discussions forum](https://github.com/beeware/toga/discussions)

We foster a welcoming and respectful community as described in our [BeeWare Community Code of Conduct](https://beeware.org/community/behavior/).

## Contributing

If you experience problems with Toga, [log them on GitHub](https://github.com/beeware/toga/issues).

  If you'd like to contribute to Toga development, our [contribution guide](https://toga.beeware.org/en/latest/how-to/contribute/) details how to set up a development environment, and other requirements we have as part of our contribution process.
