<!-- rumdl-disable-line MD041 -->

<!-- rumdl-disable MD007 -->

- [Tutorials](tutorial/index.md)
    - tutorial/*
- [How-to Guides](how-to/index.md)
    - [Contributing to Toga](how-to/contribute/index.md)
        - [First-time contributors](how-to/contribute/first-time-contributors.md)
        - What can I do?
            - [Fix an issue](how-to/contribute/what/fix-issue.md)
            - [Implement a new feature](how-to/contribute/what/implement-feature.md)
            - [Write documentation](how-to/contribute/what/write-docs.md)
            - [Triage an issue](how-to/contribute/what/triage.md)
            - [Review a pull request](how-to/contribute/what/review-pr.md)
            - [Propose a new feature](how-to/contribute/what/propose-feature.md)
            - [Use the tools](how-to/contribute/what/use-tools.md)
        - How do I contribute?
            - [Setting up a development environment](how-to/contribute/how/dev-environment.md)
            - [Reproducing an issue](how-to/contribute/how/reproduce-issue.md)
            - [Working from a branch](how-to/contribute/how/branches.md)
            - [Avoiding scope creep](how-to/contribute/how/scope-creep.md)
            - [Writing, running, and testing code](how-to/contribute/how/write-code.md)
            - [Building documentation](how-to/contribute/how/build-docs.md)
            - [Writing documentation](how-to/contribute/how/write-docs.md)
            - [Adding a change note](how-to/contribute/how/change-note.md)
            - [Submitting a pull request](how-to/contribute/how/submit-pr.md)
            - [Providing a review](how-to/contribute/how/review-pr.md)
            - [Submitting a new issue](how-to/contribute/how/new-issue.md)
            - [Proposing a new feature](how-to/contribute/how/propose-feature.md)
        - What happens next?
            - [Pull request review process](how-to/contribute/next/pr-review.md)
            - [Release process](how-to/contribute/next/release.md)
        - Style guides
            - [Code style guide](how-to/contribute/style/code-style-guide.md)
            - [Documentation style guide](how-to/contribute/style/docs-style-guide.md)
    - Internal How-to guides
        - [How to cut a Toga release](how-to/internal/release.md)
- [Topic guides](topics/index.md)
    - topics/*
- [Reference](reference/index.md)
    - [API reference](reference/api/index.md)
        - Application components
            <!-- Specify order of the window classes, then let rest be alphabetical -->
            - [App](reference/api/application/app.md)
            - [Window](reference/api/application/window.md)
            - [MainWindow](reference/api/application/mainwindow.md)
            - [DocumentWindow](reference/api/application/documentwindow.md)
            - reference/api/application/*
        - Widgets
            - reference/api/widgets/*
        - Container widgets
            - reference/api/containers/*
        - Style
            - reference/api/style/*
        - Data representation
            - [Color](reference/api/data-representation/color.md)
            - [Constants](reference/api/data-representation/constants.md)
            - [Document](reference/api/data-representation/document.md)
            - [Paths](reference/api/data-representation/paths.md)
            - [Source](reference/api/data-representation/source.md)
            - [ListSource](reference/api/data-representation/listsource.md)
            - [TreeSource](reference/api/data-representation/treesource.md)
            - [ValueSource](reference/api/data-representation/valuesource.md)
            - [Types](reference/api/data-representation/types.md)
            - [Validators](reference/api/data-representation/validators.md)
        - Resources
            - reference/api/resources/*
        - Hardware
            - reference/api/hardware/*
    - [Supported platforms](reference/platforms/index.md)
        - [macOS](reference/platforms/macOS.md)
        - [Windows](reference/platforms/windows.md)
        - [Linux](reference/platforms/linux/index.md)
            - [GTK](reference/platforms/linux/gtk.md)
            - [Qt](reference/platforms/linux/qt.md)
        - [Android](reference/platforms/android.md)
        - [iOS](reference/platforms/iOS.md)
        - [Web](reference/platforms/web.md)
        - [Terminal](reference/platforms/terminal.md)
        - [Testing](reference/platforms/testing.md)
- [About Toga](about/index.md)
    - [Why Toga?](about/philosophy.md)
    - [FAQ](about/faq.md)
    - [Success Stories](about/success.md)
    - [Release History](about/releases.md)
    - [Toga's Road Map](about/roadmap.md)
