# Toga

Toga is a Python native, OS native, cross-platform GUI toolkit. Toga consists of a library of base components with a shared interface to simplify platform-agnostic GUI development.

Toga is available on macOS, Windows, Linux (GTK or Qt), Android, iOS, for single-page web apps, and console apps.

/// tab | macOS

![/images/toga-demo-cocoa.png](/images/toga-demo-cocoa.png){ width="450" }

/// caption

///

<!-- TODO: Update alt text -->

///

/// tab | Linux (GTK)

![/images/toga-demo-gtk.png](/images/toga-demo-gtk.png){ width="450" }

/// caption

///

<!-- TODO: Update alt text -->

///

/// tab | Windows

![/images/toga-demo-winforms.png](/images/toga-demo-winforms.png){ width="450" }

/// caption

///

<!-- TODO: Update alt text -->

///

## [Tutorial](tutorial/index.md)

[A quick Toga demonstration](tutorial/get-started.md) and a [a hands-on introduction to Toga](tutorial/index.md).

## [How-to guides](how-to/index.md)

Guides and recipes for common problems and tasks, including how to [contribute to Toga](how-to/contribute/index.md).

## [Topic Guides](topics/index.md)

Deeper explorations of concepts and issues related to Toga usage.

## [Reference](reference/index.md)

Technical documentation such as [Toga's API](reference/api/index.md), details on [platform support](reference/platforms/index.md), and other detailed reference information (including [overall architectural details](topics/architecture.md)).

## [About Toga](about/index.md)

[Frequently asked questions](about/faq.md), [success stories](about/success.md), and other details about Toga as a project.

## Community

Toga is part of the [BeeWare suite](https://beeware.org). You can talk to the community through:

- [@beeware@fosstodon.org on Mastodon](https://fosstodon.org/@beeware)
- [Discord](https://beeware.org/bee/chat/)
- The Toga [GitHub Discussions forum](https://github.com/beeware/Toga/discussions)

### Code of Conduct

The BeeWare community has a strict [Code of Conduct](https://beeware.org/community/behavior/code-of-conduct/). All users and developers are expected to adhere to this code.

If you have any concerns about this code of conduct, or you wish to report a violation of this code, please contact [Code of Conduct Response Team](mailto:conduct@beeware.org).

### Contributing

If you experience problems with Toga, [log them on GitHub](https://github.com/beeware/toga/issues). If you want to contribute to Toga, you can read through the [Toga contribution guides](how-to/contribute/index.md).
