# Tutorials

/// note | Note

Is this the tutorial you're looking for?

If this is your first time using BeeWare, we suggestion you start with the [BeeWare tutorial](https://tutorial.beeware.org). This tutorial only covers BeeWare's GUI toolkit, Toga, and doesn't cover any of the details of getting your code running on specific hardware platforms. Once you've completed the BeeWare tutorial, this tutorial will introduce more details about Toga's capabilities as a GUI toolkit.

///

## A quick test drive

Before you run through the tutorial, [install a Toga app][get-started] to see what Toga looks like.

## Tutorial 0 - your first Toga app

In [Tutorial 0](tutorial-0.md), you will discover how to create a basic app and have a simple [`Button`][toga.Button] widget to click.

## Tutorial 1 - a slightly less toy example

In [Tutorial 1](tutorial-1.md), you will discover how to capture basic user input using the [`TextInput`][toga.TextInput] widget and control layout.

## Tutorial 2 - you put the box inside another box...

In [Tutorial 2](tutorial-2.md), you will discover how to use the [`SplitContainer`][toga.SplitContainer] widget to display some components, a toolbar and a table.

![images/tutorial-2.png](images/tutorial-2.png){ width="300" }

/// caption

///

<!-- TODO: Update alt text -->

## Tutorial 3 - let's build a browser!

In [Tutorial 3](tutorial-3.md), you will discover how to use the [`WebView`][toga.WebView] widget to display a simple browser.

![images/tutorial-3.png](images/tutorial-3.png){ width="300" }

/// caption

///

<!-- TODO: Update alt text -->

## Tutorial 4 - let's draw on a canvas!

In [Tutorial 4](tutorial-4.md), you will discover how to use the [`Canvas`][toga.Canvas] widget to draw lines and shapes on a canvas.

![images/tutorial-4.png](images/tutorial-4.png){ width="300" }

/// caption

///

<!-- TODO: Update alt text -->
