# toga-gtk

[![Python Versions](https://img.shields.io/pypi/pyversions/toga-gtk.svg)](https://pypi.python.org/pypi/toga-gtk)
[![BSD-3-Clause License](https://img.shields.io/pypi/l/toga-gtk.svg)](https://github.com/beeware/toga-gtk/blob/main/LICENSE)
[![Project status](https://img.shields.io/pypi/status/toga-gtk.svg)](https://pypi.python.org/pypi/toga-gtk)

A GTK backend for the [Toga widget toolkit](https://beeware.org/toga). It uses the GTK 3 API by default; GTK 4 support is experimental, and can be enabled by defining `TOGA_GTK=4` in your shell environment.

This package isn't much use by itself; it needs to be combined with [the core Toga library](https://pypi.python.org/pypi/toga-core).

For platform requirements, see the [GTK platform documentation](https://toga.beeware.org/en/latest/reference/platforms/linux/gtk#prerequisites).

For more details, see [Toga's documentation](https://toga.beeware.org), or the [Toga project on GitHub](https://github.com/beeware/toga).

## Community

Toga is part of the [BeeWare suite](https://beeware.org). You can talk to the community through:

- [@beeware@fosstodon.org on Mastodon](https://fosstodon.org/@beeware)
- [Discord](https://beeware.org/bee/chat/)
- The Toga [GitHub Discussions forum](https://github.com/beeware/toga/discussions)

We foster a welcoming and respectful community as described in our [BeeWare Community Code of Conduct](https://beeware.org/community/behavior/).

## Contributing

If you experience problems with Toga, [log them on GitHub](https://github.com/beeware/toga/issues).

If you'd like to contribute to Toga development, our [contribution guide](https://toga.beeware.org/en/latest/how-to/contribute/) details how to set up a development environment, and other requirements we have as part of our contribution process.
