# toga-positron

[![Python Versions](https://img.shields.io/pypi/pyversions/toga-positron.svg)](https://pypi.python.org/pypi/toga-positron)
[![BSD-3-Clause License](https://img.shields.io/pypi/l/toga-positron.svg)](https://github.com/beeware/toga-positron/blob/main/LICENSE)
[![Project status](https://img.shields.io/pypi/status/toga-positron.svg)](https://pypi.python.org/pypi/toga-positron)

A [Briefcase](https://github.com/beeware/briefcase) bootstrap for setting up
[Toga](https://github.com/beeware/toga) apps whose GUI generated by displaying web
content. (i.e., Electron-like apps... but more positive, because they're using Python!)

## Usage

Create a fresh virtual environment, then install `toga-positron`. This will install
Briefcase, plus the Positron bootstrap. You can then use the Briefcase wizard to create
a new Toga app:

    $ python -m venv venv
    $ source venv/bin/activate
    (venv) $ pip install toga-positron
    (venv) $ briefcase new

This will ask you a number of questions about the app you want to generate, such as the
app's name, the authors name, and the project license. You'll then be asked which GUI
framework you want to use:

    -- GUI framework -------------------------------------------------------------

    What GUI toolkit do you want to use for this project?

    Additional GUI bootstraps are available from the community.

    Check them out at https://beeware.org/bee/briefcase-bootstraps

    1) Toga
    2) PySide6                               (does not support iOS/Android/Web deployment)
    3) Pygame                                (does not support iOS/Android/Web deployment)
    4) Console                               (does not support iOS/Android/Web deployment)
    5) Toga Positron (Django server)         (does not support Web deployment)
    6) Toga Positron (Site-specific browser) (does not support Web deployment)
    7) Toga Positron (Static server)         (does not support Web deployment)
    8) None

    GUI framework [1]:

This provides 3 options for a Toga Positron-based app:

### Django server

An app that runs a Django web server in a background thread, and points the app's web
browser at the URL for that server. Some additional files (such as `urls.py` and
`settings.py`) will be generated by the app template.

The Django site that is generated is essentially identical to the default Django project
created by `startproject`, with some minor modifications to set app-specific paths and
ensure that static files will be served.

If you select this option, you will be asked for the initial path that you want to
display in the app window. The default value is `/admin/`, which will cause the Django
Admin login page (i.e., `http://127.0.0.1/admin/`) to be the initial URL loaded by the
app, but you can choose any other URL you want (including `/` to serve the root URL
of the Django site).

To run Django management commands, use::

    (venv) PYTHONPATH=src python src/manage.py <command> <args...>

The Django app will run on a SQLite3 database, stored in the user's data directory (the
location of this directory is platform specific). This database file will be created if
it doesn't exist, and migrations will be run on every app start.

If you need to start the database with some initial content (e.g., an initial user
login) you can use `manage.py` to create an initial database file. If there is a
`db.sqlite3` in the `src/<app name>/resources` folder when the app starts, and the
user doesn't already have a `db.sqlite3` file in their app data folder, the initial
database file will be copied into the user's data folder as a starting point.

To create an initial database, use `manage.py` - e.g.,:

    (venv) PYTHONPATH=src python src/manage.py migrate
    (venv) PYTHONPATH=src python src/manage.py createsuperuser

This will create an initial `db.sqlite3` file with a superuser account. All users
of the app will have this superuser account in their database.

### Site-specific browser

An app that behaves as a web browser that displays a single, externally served URL.

If you select this option, you will be asked for the URL that you want to display in the
app window. For example, if you nominate `https://github.com` as the site URL, you will
generate an app that, when started, loads the GitHub homepage.

### Static server

An app that runs a simple HTTP server on a background thread, and points the app's web
browser at the URL for that server. This is suitable for serving simple static HTML and
CSS content. The app will serve the contents of the app's `resources` folder (i.e.,
`src/<app name>/resources`) as the root URL. A placeholder `index.html` file is generated
in the resources folder as part of the template.

## Community

Toga Positron is part of the [BeeWare suite](https://beeware.org). You can talk to the
community through:

* [@beeware@fosstodon.org on Mastodon](https://fosstodon.org/@beeware)
* [Discord](https://beeware.org/bee/chat/)
* [The Toga GitHub Discussions forum](https://github.com/beeware/toga/discussions)

We foster a welcoming and respectful community as described in our
[BeeWare Community Code of Conduct](https://beeware.org/community/behavior/)

## Contributing

If you experience problems with Toga, [log them on
GitHub](https://github.com/beeware/toga/issues).

If you'd like to contribute to Toga development, our [contribution
guide](https://toga.beeware.org/en/latest/how-to/contribute/) details how
to set up a development environment, and other requirements we have as part of our
contribution process.
