from System.Drawing import ContentAlignment
from System.Windows.Forms import HorizontalAlignment

from toga.colors import rgb
from toga.style.pack import BOTTOM, CENTER, LEFT, RIGHT, TOP


def toga_color(color):
    return rgb(color.R, color.G, color.B, color.A / 255)


def toga_x_text_align(alignment):
    return {
        ContentAlignment.TopLeft: LEFT,
        ContentAlignment.MiddleLeft: LEFT,
        ContentAlignment.BottomLeft: LEFT,
        ContentAlignment.TopCenter: CENTER,
        ContentAlignment.MiddleCenter: CENTER,
        ContentAlignment.BottomCenter: CENTER,
        ContentAlignment.TopRight: RIGHT,
        ContentAlignment.MiddleRight: RIGHT,
        ContentAlignment.BottomRight: RIGHT,
        #
        HorizontalAlignment.Left: LEFT,
        HorizontalAlignment.Center: CENTER,
        HorizontalAlignment.Right: RIGHT,
    }[alignment]


def toga_y_text_align(alignment):
    return {
        ContentAlignment.TopLeft: TOP,
        ContentAlignment.TopCenter: TOP,
        ContentAlignment.TopRight: TOP,
        ContentAlignment.MiddleLeft: CENTER,
        ContentAlignment.MiddleCenter: CENTER,
        ContentAlignment.MiddleRight: CENTER,
        ContentAlignment.BottomLeft: BOTTOM,
        ContentAlignment.BottomCenter: BOTTOM,
        ContentAlignment.BottomRight: BOTTOM,
    }[alignment]
