import {Model} from "../../model"
import type * as p from "core/properties"

export namespace Styles {
  export type Attrs = p.AttrsOf<Props>
  export type Props = Model.Props & {
    align_content: p.Property<string | null>
    align_items: p.Property<string | null>
    align_self: p.Property<string | null>
    alignment_baseline: p.Property<string | null>
    all: p.Property<string | null>
    animation: p.Property<string | null>
    animation_delay: p.Property<string | null>
    animation_direction: p.Property<string | null>
    animation_duration: p.Property<string | null>
    animation_fill_mode: p.Property<string | null>
    animation_iteration_count: p.Property<string | null>
    animation_name: p.Property<string | null>
    animation_play_state: p.Property<string | null>
    animation_timing_function: p.Property<string | null>
    aspect_ratio: p.Property<string | null>
    backface_visibility: p.Property<string | null>
    background: p.Property<string | null>
    background_attachment: p.Property<string | null>
    background_clip: p.Property<string | null>
    background_color: p.Property<string | null>
    background_image: p.Property<string | null>
    background_origin: p.Property<string | null>
    background_position: p.Property<string | null>
    background_position_x: p.Property<string | null>
    background_position_y: p.Property<string | null>
    background_repeat: p.Property<string | null>
    background_size: p.Property<string | null>
    baseline_shift: p.Property<string | null>
    block_size: p.Property<string | null>
    border: p.Property<string | null>
    border_block_end: p.Property<string | null>
    border_block_end_color: p.Property<string | null>
    border_block_end_style: p.Property<string | null>
    border_block_end_width: p.Property<string | null>
    border_block_start: p.Property<string | null>
    border_block_start_color: p.Property<string | null>
    border_block_start_style: p.Property<string | null>
    border_block_start_width: p.Property<string | null>
    border_bottom: p.Property<string | null>
    border_bottom_color: p.Property<string | null>
    border_bottom_left_radius: p.Property<string | null>
    border_bottom_right_radius: p.Property<string | null>
    border_bottom_style: p.Property<string | null>
    border_bottom_width: p.Property<string | null>
    border_collapse: p.Property<string | null>
    border_color: p.Property<string | null>
    border_image: p.Property<string | null>
    border_image_outset: p.Property<string | null>
    border_image_repeat: p.Property<string | null>
    border_image_slice: p.Property<string | null>
    border_image_source: p.Property<string | null>
    border_image_width: p.Property<string | null>
    border_inline_end: p.Property<string | null>
    border_inline_end_color: p.Property<string | null>
    border_inline_end_style: p.Property<string | null>
    border_inline_end_width: p.Property<string | null>
    border_inline_start: p.Property<string | null>
    border_inline_start_color: p.Property<string | null>
    border_inline_start_style: p.Property<string | null>
    border_inline_start_width: p.Property<string | null>
    border_left: p.Property<string | null>
    border_left_color: p.Property<string | null>
    border_left_style: p.Property<string | null>
    border_left_width: p.Property<string | null>
    border_radius: p.Property<string | null>
    border_right: p.Property<string | null>
    border_right_color: p.Property<string | null>
    border_right_style: p.Property<string | null>
    border_right_width: p.Property<string | null>
    border_spacing: p.Property<string | null>
    border_style: p.Property<string | null>
    border_top: p.Property<string | null>
    border_top_color: p.Property<string | null>
    border_top_left_radius: p.Property<string | null>
    border_top_right_radius: p.Property<string | null>
    border_top_style: p.Property<string | null>
    border_top_width: p.Property<string | null>
    border_width: p.Property<string | null>
    bottom: p.Property<string | null>
    box_shadow: p.Property<string | null>
    box_sizing: p.Property<string | null>
    break_after: p.Property<string | null>
    break_before: p.Property<string | null>
    break_inside: p.Property<string | null>
    caption_side: p.Property<string | null>
    caret_color: p.Property<string | null>
    clear: p.Property<string | null>
    clip: p.Property<string | null>
    clip_path: p.Property<string | null>
    clip_rule: p.Property<string | null>
    color: p.Property<string | null>
    color_interpolation: p.Property<string | null>
    color_interpolation_filters: p.Property<string | null>
    column_count: p.Property<string | null>
    column_fill: p.Property<string | null>
    column_gap: p.Property<string | null>
    column_rule: p.Property<string | null>
    column_rule_color: p.Property<string | null>
    column_rule_style: p.Property<string | null>
    column_rule_width: p.Property<string | null>
    column_span: p.Property<string | null>
    column_width: p.Property<string | null>
    columns: p.Property<string | null>
    content: p.Property<string | null>
    counter_increment: p.Property<string | null>
    counter_reset: p.Property<string | null>
    cursor: p.Property<string | null>
    direction: p.Property<string | null>
    display: p.Property<string | null>
    dominant_baseline: p.Property<string | null>
    empty_cells: p.Property<string | null>
    fill: p.Property<string | null>
    fill_opacity: p.Property<string | null>
    fill_rule: p.Property<string | null>
    filter: p.Property<string | null>
    flex: p.Property<string | null>
    flex_basis: p.Property<string | null>
    flex_direction: p.Property<string | null>
    flex_flow: p.Property<string | null>
    flex_grow: p.Property<string | null>
    flex_shrink: p.Property<string | null>
    flex_wrap: p.Property<string | null>
    float: p.Property<string | null>
    flood_color: p.Property<string | null>
    flood_opacity: p.Property<string | null>
    font: p.Property<string | null>
    font_family: p.Property<string | null>
    font_feature_settings: p.Property<string | null>
    font_kerning: p.Property<string | null>
    font_size: p.Property<string | null>
    font_size_adjust: p.Property<string | null>
    font_stretch: p.Property<string | null>
    font_style: p.Property<string | null>
    font_synthesis: p.Property<string | null>
    font_variant: p.Property<string | null>
    font_variant_caps: p.Property<string | null>
    font_variant_east_asian: p.Property<string | null>
    font_variant_ligatures: p.Property<string | null>
    font_variant_numeric: p.Property<string | null>
    font_variant_position: p.Property<string | null>
    font_weight: p.Property<string | null>
    gap: p.Property<string | null>
    glyph_orientation_vertical: p.Property<string | null>
    grid: p.Property<string | null>
    grid_area: p.Property<string | null>
    grid_auto_columns: p.Property<string | null>
    grid_auto_flow: p.Property<string | null>
    grid_auto_rows: p.Property<string | null>
    grid_column: p.Property<string | null>
    grid_column_end: p.Property<string | null>
    grid_column_gap: p.Property<string | null>
    grid_column_start: p.Property<string | null>
    grid_gap: p.Property<string | null>
    grid_row: p.Property<string | null>
    grid_row_end: p.Property<string | null>
    grid_row_gap: p.Property<string | null>
    grid_row_start: p.Property<string | null>
    grid_template: p.Property<string | null>
    grid_template_areas: p.Property<string | null>
    grid_template_columns: p.Property<string | null>
    grid_template_rows: p.Property<string | null>
    height: p.Property<string | null>
    hyphens: p.Property<string | null>
    image_orientation: p.Property<string | null>
    image_rendering: p.Property<string | null>
    inline_size: p.Property<string | null>
    justify_content: p.Property<string | null>
    justify_items: p.Property<string | null>
    justify_self: p.Property<string | null>
    left: p.Property<string | null>
    letter_spacing: p.Property<string | null>
    lighting_color: p.Property<string | null>
    line_break: p.Property<string | null>
    line_height: p.Property<string | null>
    list_style: p.Property<string | null>
    list_style_image: p.Property<string | null>
    list_style_position: p.Property<string | null>
    list_style_type: p.Property<string | null>
    margin: p.Property<string | null>
    margin_block_end: p.Property<string | null>
    margin_block_start: p.Property<string | null>
    margin_bottom: p.Property<string | null>
    margin_inline_end: p.Property<string | null>
    margin_inline_start: p.Property<string | null>
    margin_left: p.Property<string | null>
    margin_right: p.Property<string | null>
    margin_top: p.Property<string | null>
    marker: p.Property<string | null>
    marker_end: p.Property<string | null>
    marker_mid: p.Property<string | null>
    marker_start: p.Property<string | null>
    mask: p.Property<string | null>
    mask_composite: p.Property<string | null>
    mask_image: p.Property<string | null>
    mask_position: p.Property<string | null>
    mask_repeat: p.Property<string | null>
    mask_size: p.Property<string | null>
    mask_type: p.Property<string | null>
    max_block_size: p.Property<string | null>
    max_height: p.Property<string | null>
    max_inline_size: p.Property<string | null>
    max_width: p.Property<string | null>
    min_block_size: p.Property<string | null>
    min_height: p.Property<string | null>
    min_inline_size: p.Property<string | null>
    min_width: p.Property<string | null>
    object_fit: p.Property<string | null>
    object_position: p.Property<string | null>
    opacity: p.Property<string | null>
    order: p.Property<string | null>
    orphans: p.Property<string | null>
    outline: p.Property<string | null>
    outline_color: p.Property<string | null>
    outline_offset: p.Property<string | null>
    outline_style: p.Property<string | null>
    outline_width: p.Property<string | null>
    overflow: p.Property<string | null>
    overflow_anchor: p.Property<string | null>
    overflow_wrap: p.Property<string | null>
    overflow_x: p.Property<string | null>
    overflow_y: p.Property<string | null>
    overscroll_behavior: p.Property<string | null>
    overscroll_behavior_block: p.Property<string | null>
    overscroll_behavior_inline: p.Property<string | null>
    overscroll_behavior_x: p.Property<string | null>
    overscroll_behavior_y: p.Property<string | null>
    padding: p.Property<string | null>
    padding_block_end: p.Property<string | null>
    padding_block_start: p.Property<string | null>
    padding_bottom: p.Property<string | null>
    padding_inline_end: p.Property<string | null>
    padding_inline_start: p.Property<string | null>
    padding_left: p.Property<string | null>
    padding_right: p.Property<string | null>
    padding_top: p.Property<string | null>
    page_break_after: p.Property<string | null>
    page_break_before: p.Property<string | null>
    page_break_inside: p.Property<string | null>
    paint_order: p.Property<string | null>
    perspective: p.Property<string | null>
    perspective_origin: p.Property<string | null>
    place_content: p.Property<string | null>
    place_items: p.Property<string | null>
    place_self: p.Property<string | null>
    pointer_events: p.Property<string | null>
    position: p.Property<string | null>
    quotes: p.Property<string | null>
    resize: p.Property<string | null>
    right: p.Property<string | null>
    rotate: p.Property<string | null>
    row_gap: p.Property<string | null>
    ruby_align: p.Property<string | null>
    ruby_position: p.Property<string | null>
    scale: p.Property<string | null>
    scroll_behavior: p.Property<string | null>
    shape_rendering: p.Property<string | null>
    stop_color: p.Property<string | null>
    stop_opacity: p.Property<string | null>
    stroke: p.Property<string | null>
    stroke_dasharray: p.Property<string | null>
    stroke_dashoffset: p.Property<string | null>
    stroke_linecap: p.Property<string | null>
    stroke_linejoin: p.Property<string | null>
    stroke_miterlimit: p.Property<string | null>
    stroke_opacity: p.Property<string | null>
    stroke_width: p.Property<string | null>
    tab_size: p.Property<string | null>
    table_layout: p.Property<string | null>
    text_align: p.Property<string | null>
    text_align_last: p.Property<string | null>
    text_anchor: p.Property<string | null>
    text_combine_upright: p.Property<string | null>
    text_decoration: p.Property<string | null>
    text_decoration_color: p.Property<string | null>
    text_decoration_line: p.Property<string | null>
    text_decoration_style: p.Property<string | null>
    text_emphasis: p.Property<string | null>
    text_emphasis_color: p.Property<string | null>
    text_emphasis_position: p.Property<string | null>
    text_emphasis_style: p.Property<string | null>
    text_indent: p.Property<string | null>
    text_justify: p.Property<string | null>
    text_orientation: p.Property<string | null>
    text_overflow: p.Property<string | null>
    text_rendering: p.Property<string | null>
    text_shadow: p.Property<string | null>
    text_transform: p.Property<string | null>
    text_underline_position: p.Property<string | null>
    top: p.Property<string | null>
    touch_action: p.Property<string | null>
    transform: p.Property<string | null>
    transform_box: p.Property<string | null>
    transform_origin: p.Property<string | null>
    transform_style: p.Property<string | null>
    transition: p.Property<string | null>
    transition_delay: p.Property<string | null>
    transition_duration: p.Property<string | null>
    transition_property: p.Property<string | null>
    transition_timing_function: p.Property<string | null>
    translate: p.Property<string | null>
    unicode_bidi: p.Property<string | null>
    user_select: p.Property<string | null>
    vertical_align: p.Property<string | null>
    visibility: p.Property<string | null>
    white_space: p.Property<string | null>
    widows: p.Property<string | null>
    width: p.Property<string | null>
    will_change: p.Property<string | null>
    word_break: p.Property<string | null>
    word_spacing: p.Property<string | null>
    word_wrap: p.Property<string | null>
    writing_mode: p.Property<string | null>
    z_index: p.Property<string | null>
  }
}

export interface Styles extends Styles.Attrs {}

export class Styles extends Model {
  declare properties: Styles.Props

  constructor(attrs?: Partial<Styles.Attrs>) {
    super(attrs)
  }

  static {
    this.define<Styles.Props>(({Str, Nullable}) => ({
      align_content: [ Nullable(Str), null ],
      align_items: [ Nullable(Str), null ],
      align_self: [ Nullable(Str), null ],
      alignment_baseline: [ Nullable(Str), null ],
      all: [ Nullable(Str), null ],
      animation: [ Nullable(Str), null ],
      animation_delay: [ Nullable(Str), null ],
      animation_direction: [ Nullable(Str), null ],
      animation_duration: [ Nullable(Str), null ],
      animation_fill_mode: [ Nullable(Str), null ],
      animation_iteration_count: [ Nullable(Str), null ],
      animation_name: [ Nullable(Str), null ],
      animation_play_state: [ Nullable(Str), null ],
      animation_timing_function: [ Nullable(Str), null ],
      aspect_ratio: [ Nullable(Str), null ],
      backface_visibility: [ Nullable(Str), null ],
      background: [ Nullable(Str), null ],
      background_attachment: [ Nullable(Str), null ],
      background_clip: [ Nullable(Str), null ],
      background_color: [ Nullable(Str), null ],
      background_image: [ Nullable(Str), null ],
      background_origin: [ Nullable(Str), null ],
      background_position: [ Nullable(Str), null ],
      background_position_x: [ Nullable(Str), null ],
      background_position_y: [ Nullable(Str), null ],
      background_repeat: [ Nullable(Str), null ],
      background_size: [ Nullable(Str), null ],
      baseline_shift: [ Nullable(Str), null ],
      block_size: [ Nullable(Str), null ],
      border: [ Nullable(Str), null ],
      border_block_end: [ Nullable(Str), null ],
      border_block_end_color: [ Nullable(Str), null ],
      border_block_end_style: [ Nullable(Str), null ],
      border_block_end_width: [ Nullable(Str), null ],
      border_block_start: [ Nullable(Str), null ],
      border_block_start_color: [ Nullable(Str), null ],
      border_block_start_style: [ Nullable(Str), null ],
      border_block_start_width: [ Nullable(Str), null ],
      border_bottom: [ Nullable(Str), null ],
      border_bottom_color: [ Nullable(Str), null ],
      border_bottom_left_radius: [ Nullable(Str), null ],
      border_bottom_right_radius: [ Nullable(Str), null ],
      border_bottom_style: [ Nullable(Str), null ],
      border_bottom_width: [ Nullable(Str), null ],
      border_collapse: [ Nullable(Str), null ],
      border_color: [ Nullable(Str), null ],
      border_image: [ Nullable(Str), null ],
      border_image_outset: [ Nullable(Str), null ],
      border_image_repeat: [ Nullable(Str), null ],
      border_image_slice: [ Nullable(Str), null ],
      border_image_source: [ Nullable(Str), null ],
      border_image_width: [ Nullable(Str), null ],
      border_inline_end: [ Nullable(Str), null ],
      border_inline_end_color: [ Nullable(Str), null ],
      border_inline_end_style: [ Nullable(Str), null ],
      border_inline_end_width: [ Nullable(Str), null ],
      border_inline_start: [ Nullable(Str), null ],
      border_inline_start_color: [ Nullable(Str), null ],
      border_inline_start_style: [ Nullable(Str), null ],
      border_inline_start_width: [ Nullable(Str), null ],
      border_left: [ Nullable(Str), null ],
      border_left_color: [ Nullable(Str), null ],
      border_left_style: [ Nullable(Str), null ],
      border_left_width: [ Nullable(Str), null ],
      border_radius: [ Nullable(Str), null ],
      border_right: [ Nullable(Str), null ],
      border_right_color: [ Nullable(Str), null ],
      border_right_style: [ Nullable(Str), null ],
      border_right_width: [ Nullable(Str), null ],
      border_spacing: [ Nullable(Str), null ],
      border_style: [ Nullable(Str), null ],
      border_top: [ Nullable(Str), null ],
      border_top_color: [ Nullable(Str), null ],
      border_top_left_radius: [ Nullable(Str), null ],
      border_top_right_radius: [ Nullable(Str), null ],
      border_top_style: [ Nullable(Str), null ],
      border_top_width: [ Nullable(Str), null ],
      border_width: [ Nullable(Str), null ],
      bottom: [ Nullable(Str), null ],
      box_shadow: [ Nullable(Str), null ],
      box_sizing: [ Nullable(Str), null ],
      break_after: [ Nullable(Str), null ],
      break_before: [ Nullable(Str), null ],
      break_inside: [ Nullable(Str), null ],
      caption_side: [ Nullable(Str), null ],
      caret_color: [ Nullable(Str), null ],
      clear: [ Nullable(Str), null ],
      clip: [ Nullable(Str), null ],
      clip_path: [ Nullable(Str), null ],
      clip_rule: [ Nullable(Str), null ],
      color: [ Nullable(Str), null ],
      color_interpolation: [ Nullable(Str), null ],
      color_interpolation_filters: [ Nullable(Str), null ],
      column_count: [ Nullable(Str), null ],
      column_fill: [ Nullable(Str), null ],
      column_gap: [ Nullable(Str), null ],
      column_rule: [ Nullable(Str), null ],
      column_rule_color: [ Nullable(Str), null ],
      column_rule_style: [ Nullable(Str), null ],
      column_rule_width: [ Nullable(Str), null ],
      column_span: [ Nullable(Str), null ],
      column_width: [ Nullable(Str), null ],
      columns: [ Nullable(Str), null ],
      content: [ Nullable(Str), null ],
      counter_increment: [ Nullable(Str), null ],
      counter_reset: [ Nullable(Str), null ],
      cursor: [ Nullable(Str), null ],
      direction: [ Nullable(Str), null ],
      display: [ Nullable(Str), null ],
      dominant_baseline: [ Nullable(Str), null ],
      empty_cells: [ Nullable(Str), null ],
      fill: [ Nullable(Str), null ],
      fill_opacity: [ Nullable(Str), null ],
      fill_rule: [ Nullable(Str), null ],
      filter: [ Nullable(Str), null ],
      flex: [ Nullable(Str), null ],
      flex_basis: [ Nullable(Str), null ],
      flex_direction: [ Nullable(Str), null ],
      flex_flow: [ Nullable(Str), null ],
      flex_grow: [ Nullable(Str), null ],
      flex_shrink: [ Nullable(Str), null ],
      flex_wrap: [ Nullable(Str), null ],
      float: [ Nullable(Str), null ],
      flood_color: [ Nullable(Str), null ],
      flood_opacity: [ Nullable(Str), null ],
      font: [ Nullable(Str), null ],
      font_family: [ Nullable(Str), null ],
      font_feature_settings: [ Nullable(Str), null ],
      font_kerning: [ Nullable(Str), null ],
      font_size: [ Nullable(Str), null ],
      font_size_adjust: [ Nullable(Str), null ],
      font_stretch: [ Nullable(Str), null ],
      font_style: [ Nullable(Str), null ],
      font_synthesis: [ Nullable(Str), null ],
      font_variant: [ Nullable(Str), null ],
      font_variant_caps: [ Nullable(Str), null ],
      font_variant_east_asian: [ Nullable(Str), null ],
      font_variant_ligatures: [ Nullable(Str), null ],
      font_variant_numeric: [ Nullable(Str), null ],
      font_variant_position: [ Nullable(Str), null ],
      font_weight: [ Nullable(Str), null ],
      gap: [ Nullable(Str), null ],
      glyph_orientation_vertical: [ Nullable(Str), null ],
      grid: [ Nullable(Str), null ],
      grid_area: [ Nullable(Str), null ],
      grid_auto_columns: [ Nullable(Str), null ],
      grid_auto_flow: [ Nullable(Str), null ],
      grid_auto_rows: [ Nullable(Str), null ],
      grid_column: [ Nullable(Str), null ],
      grid_column_end: [ Nullable(Str), null ],
      grid_column_gap: [ Nullable(Str), null ],
      grid_column_start: [ Nullable(Str), null ],
      grid_gap: [ Nullable(Str), null ],
      grid_row: [ Nullable(Str), null ],
      grid_row_end: [ Nullable(Str), null ],
      grid_row_gap: [ Nullable(Str), null ],
      grid_row_start: [ Nullable(Str), null ],
      grid_template: [ Nullable(Str), null ],
      grid_template_areas: [ Nullable(Str), null ],
      grid_template_columns: [ Nullable(Str), null ],
      grid_template_rows: [ Nullable(Str), null ],
      height: [ Nullable(Str), null ],
      hyphens: [ Nullable(Str), null ],
      image_orientation: [ Nullable(Str), null ],
      image_rendering: [ Nullable(Str), null ],
      inline_size: [ Nullable(Str), null ],
      justify_content: [ Nullable(Str), null ],
      justify_items: [ Nullable(Str), null ],
      justify_self: [ Nullable(Str), null ],
      left: [ Nullable(Str), null ],
      letter_spacing: [ Nullable(Str), null ],
      lighting_color: [ Nullable(Str), null ],
      line_break: [ Nullable(Str), null ],
      line_height: [ Nullable(Str), null ],
      list_style: [ Nullable(Str), null ],
      list_style_image: [ Nullable(Str), null ],
      list_style_position: [ Nullable(Str), null ],
      list_style_type: [ Nullable(Str), null ],
      margin: [ Nullable(Str), null ],
      margin_block_end: [ Nullable(Str), null ],
      margin_block_start: [ Nullable(Str), null ],
      margin_bottom: [ Nullable(Str), null ],
      margin_inline_end: [ Nullable(Str), null ],
      margin_inline_start: [ Nullable(Str), null ],
      margin_left: [ Nullable(Str), null ],
      margin_right: [ Nullable(Str), null ],
      margin_top: [ Nullable(Str), null ],
      marker: [ Nullable(Str), null ],
      marker_end: [ Nullable(Str), null ],
      marker_mid: [ Nullable(Str), null ],
      marker_start: [ Nullable(Str), null ],
      mask: [ Nullable(Str), null ],
      mask_composite: [ Nullable(Str), null ],
      mask_image: [ Nullable(Str), null ],
      mask_position: [ Nullable(Str), null ],
      mask_repeat: [ Nullable(Str), null ],
      mask_size: [ Nullable(Str), null ],
      mask_type: [ Nullable(Str), null ],
      max_block_size: [ Nullable(Str), null ],
      max_height: [ Nullable(Str), null ],
      max_inline_size: [ Nullable(Str), null ],
      max_width: [ Nullable(Str), null ],
      min_block_size: [ Nullable(Str), null ],
      min_height: [ Nullable(Str), null ],
      min_inline_size: [ Nullable(Str), null ],
      min_width: [ Nullable(Str), null ],
      object_fit: [ Nullable(Str), null ],
      object_position: [ Nullable(Str), null ],
      opacity: [ Nullable(Str), null ],
      order: [ Nullable(Str), null ],
      orphans: [ Nullable(Str), null ],
      outline: [ Nullable(Str), null ],
      outline_color: [ Nullable(Str), null ],
      outline_offset: [ Nullable(Str), null ],
      outline_style: [ Nullable(Str), null ],
      outline_width: [ Nullable(Str), null ],
      overflow: [ Nullable(Str), null ],
      overflow_anchor: [ Nullable(Str), null ],
      overflow_wrap: [ Nullable(Str), null ],
      overflow_x: [ Nullable(Str), null ],
      overflow_y: [ Nullable(Str), null ],
      overscroll_behavior: [ Nullable(Str), null ],
      overscroll_behavior_block: [ Nullable(Str), null ],
      overscroll_behavior_inline: [ Nullable(Str), null ],
      overscroll_behavior_x: [ Nullable(Str), null ],
      overscroll_behavior_y: [ Nullable(Str), null ],
      padding: [ Nullable(Str), null ],
      padding_block_end: [ Nullable(Str), null ],
      padding_block_start: [ Nullable(Str), null ],
      padding_bottom: [ Nullable(Str), null ],
      padding_inline_end: [ Nullable(Str), null ],
      padding_inline_start: [ Nullable(Str), null ],
      padding_left: [ Nullable(Str), null ],
      padding_right: [ Nullable(Str), null ],
      padding_top: [ Nullable(Str), null ],
      page_break_after: [ Nullable(Str), null ],
      page_break_before: [ Nullable(Str), null ],
      page_break_inside: [ Nullable(Str), null ],
      paint_order: [ Nullable(Str), null ],
      perspective: [ Nullable(Str), null ],
      perspective_origin: [ Nullable(Str), null ],
      place_content: [ Nullable(Str), null ],
      place_items: [ Nullable(Str), null ],
      place_self: [ Nullable(Str), null ],
      pointer_events: [ Nullable(Str), null ],
      position: [ Nullable(Str), null ],
      quotes: [ Nullable(Str), null ],
      resize: [ Nullable(Str), null ],
      right: [ Nullable(Str), null ],
      rotate: [ Nullable(Str), null ],
      row_gap: [ Nullable(Str), null ],
      ruby_align: [ Nullable(Str), null ],
      ruby_position: [ Nullable(Str), null ],
      scale: [ Nullable(Str), null ],
      scroll_behavior: [ Nullable(Str), null ],
      shape_rendering: [ Nullable(Str), null ],
      stop_color: [ Nullable(Str), null ],
      stop_opacity: [ Nullable(Str), null ],
      stroke: [ Nullable(Str), null ],
      stroke_dasharray: [ Nullable(Str), null ],
      stroke_dashoffset: [ Nullable(Str), null ],
      stroke_linecap: [ Nullable(Str), null ],
      stroke_linejoin: [ Nullable(Str), null ],
      stroke_miterlimit: [ Nullable(Str), null ],
      stroke_opacity: [ Nullable(Str), null ],
      stroke_width: [ Nullable(Str), null ],
      tab_size: [ Nullable(Str), null ],
      table_layout: [ Nullable(Str), null ],
      text_align: [ Nullable(Str), null ],
      text_align_last: [ Nullable(Str), null ],
      text_anchor: [ Nullable(Str), null ],
      text_combine_upright: [ Nullable(Str), null ],
      text_decoration: [ Nullable(Str), null ],
      text_decoration_color: [ Nullable(Str), null ],
      text_decoration_line: [ Nullable(Str), null ],
      text_decoration_style: [ Nullable(Str), null ],
      text_emphasis: [ Nullable(Str), null ],
      text_emphasis_color: [ Nullable(Str), null ],
      text_emphasis_position: [ Nullable(Str), null ],
      text_emphasis_style: [ Nullable(Str), null ],
      text_indent: [ Nullable(Str), null ],
      text_justify: [ Nullable(Str), null ],
      text_orientation: [ Nullable(Str), null ],
      text_overflow: [ Nullable(Str), null ],
      text_rendering: [ Nullable(Str), null ],
      text_shadow: [ Nullable(Str), null ],
      text_transform: [ Nullable(Str), null ],
      text_underline_position: [ Nullable(Str), null ],
      top: [ Nullable(Str), null ],
      touch_action: [ Nullable(Str), null ],
      transform: [ Nullable(Str), null ],
      transform_box: [ Nullable(Str), null ],
      transform_origin: [ Nullable(Str), null ],
      transform_style: [ Nullable(Str), null ],
      transition: [ Nullable(Str), null ],
      transition_delay: [ Nullable(Str), null ],
      transition_duration: [ Nullable(Str), null ],
      transition_property: [ Nullable(Str), null ],
      transition_timing_function: [ Nullable(Str), null ],
      translate: [ Nullable(Str), null ],
      unicode_bidi: [ Nullable(Str), null ],
      user_select: [ Nullable(Str), null ],
      vertical_align: [ Nullable(Str), null ],
      visibility: [ Nullable(Str), null ],
      white_space: [ Nullable(Str), null ],
      widows: [ Nullable(Str), null ],
      width: [ Nullable(Str), null ],
      will_change: [ Nullable(Str), null ],
      word_break: [ Nullable(Str), null ],
      word_spacing: [ Nullable(Str), null ],
      word_wrap: [ Nullable(Str), null ],
      writing_mode: [ Nullable(Str), null ],
      z_index: [ Nullable(Str), null ],
    }))
  }
}
