# Contributor Code of Conduct

## The Abridged Version

The Bokeh community has been fantastic since the project's start. A one-line summary
of this CoC is simply a reflection of the community values already evident in practice:

> Please be always kind and courteous. There's never a need to be mean or rude or disrespectful.

If you wish to bring something to the attention of the project team, please fill the form at
[conduct.bokeh.org](https://conduct.bokeh.org).

## The Longer Version

However, for the sake of decreasing any ambiguity, the details of this CoC are laid out explicitly
here.

### Our Pledge

We pledge to take responsibility for our own actions. If someone has been harmed
or offended, we will listen carefully and respectfully, and work to right the
wrong. In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

### Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

All of these serve to help make the project better, but also serve to make
the experience of participating in the project better as well.

Examples of unacceptable behavior by participants include:

* Sexist, racist, and other exclusionary language.
* The use of sexualized language or imagery and unwelcome sexual attention or
  advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment or intimidation
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior. Maintainers will seek input
from all parties following any reports in order to make final determinations,
and will encourage relevant individuals to right any harms committed to the
extent possible.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or otherwise harmful.

### Scope

This Code of Conduct applies both within project work spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

### Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by filling the form at [conduct.bokeh.org](https://conduct.bokeh.org). All
reports will be reviewed by the [Conduct Sub-committee](https://github.com/bokeh/bokeh/wiki/BEP-4:-Project-Roles#conduct-sub-committee) and investigated and any appropriate measures
will be taken. The project team commits to maintaining confidentiality
with regard to the reporter of an incident. Further details of specific
enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith will face temporary or permanent repercussions as determined by other
members of the project's leadership.

### Escalation

In the event it is necessary to make a report involving someone on the [Conduct Sub-committee](https://github.com/bokeh/bokeh/wiki/BEP-4:-Project-Roles#conduct-sub-committee) itself, please use the general [NumFocus CoC reporting form](https://numfocus.org/code-of-conduct).

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/

### Revisions

|Date| Change|
|------|---------------------------|
|2019-03-01 | Updated reporting email to conduct@bokeh.org |
|2020-05-03 | Link to conduct subcommittee and NF CoC form for escalation|
|2020-05-04 | Typos and minor word edits |
