# Bokeh Examples

## Examples in this repository

This directory contains many examples of different ways to use Bokeh. As Bokeh has been evolving
fast, it is important that you **ensure that the version of an example you're looking at matches
the version of Bokeh you are running**.

### [`advanced`](advanced/)
This folder contains examples of more advanced or complex Bokeh applications and use
cases, beyond the basic plotting and visualization examples that are included in the
examples folder.

### [`basic`](basic/)

Each example in the basic folder provides a clear and concise demonstration of how to
create a specific type of visualization using Bokeh. These examples are intended for users
who want to learn how to create basic visualizations using the library.

### [`interaction`](interaction/)

The examples in this directory are mini-tutorials that
demonstrate and explain some particular aspect of Bokeh capability
(such as [linking and brushing](http://www.infovis-wiki.net/index.php?title=Linking_and_Brushing)),
or walk through a particular example in additional detail.

### [`models`](models/)

This directory contains examples that use the lowest-level
[`bokeh.models`](https://docs.bokeh.org/en/latest/docs/reference/models.html)
interface. For more information about Bokeh models see
[the concepts section of the user_guide](https://docs.bokeh.org/en/latest/docs/user_guide/concepts.html#interfaces)


### [`output`](output/)

This folder contains examples of how to use Bokeh to generate various types of output,
including static image files, standalone HTML files, and embedded Bokeh plots in Jupyter
notebooks.

### [`plotting`](plotting/)

This directory contains example using the
[`bokeh.plotting`](https://docs.bokeh.org/en/latest/docs/reference/plotting.html)
interface. For more information about Bokeh plotting see
[the concepts section of the user_guide](https://docs.bokeh.org/en/latest/docs/user_guide/concepts.html#interfaces)

### [`reference`](reference/)

This folder contains a collection of examples that demonstrate the usage and
functionality of various Bokeh objects and properties, including Bokeh models, properties,
and tools.

### [`server`](server/)

This folder contains a collection of examples that demonstrate
how to create interactive web applications using Bokeh server.

### [`styling`](styling/)

This folder contains a collection of examples that demonstrate
various ways to style Bokeh plots using CSS styles and themes.

### [`topics`](topics/)

This folder contains a collection of examples that cover a
wide range of topics related to creating interactive visualizations with Bokeh.


## Other sources for examples

* There are many examples in the [Bokeh Gallery](https://docs.bokeh.org/en/latest/docs/gallery.html) on main documentation site https://docs.bokeh.org.

* The [Bokeh User's Guide](https://docs.bokeh.org/en/latest/docs/user_guide.html) has many plots with corresponding code samples throughout.

* Many examples of Bokeh being used with the [Jupyter](http://jupyter.org) notebook, including a set or tutorial notebooks, are collected in the [`bokeh-notebooks`](https://github.com/bokeh/bokeh-notebooks) repository. Live versions of these notebooks [can be run online on MyBinder](https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/HEAD?labpath=index.ipynb). These notebooks are also available statically rendered on the [Bokeh NBViewer page](http://nbviewer.jupyter.org/github/bokeh/bokeh-notebooks/blob/master/index.ipynb).
