''' A simple bar chart using plain Python lists.

.. bokeh-example-metadata::
    :apis: bokeh.plotting.figure.vbar
    :refs: :ref:`ug_basic_bars`
    :keywords: bars, categorical

'''
from bokeh.plotting import figure, show

fruits = ['Apples', 'Pears', 'Nectarines', 'Plums', 'Grapes', 'Strawberries']
counts = [5, 3, 4, 2, 4, 6]

p = figure(x_range=fruits, height=350, title="Fruit Counts",
           toolbar_location=None, tools="")

p.vbar(x=fruits, top=counts, width=0.9)

p.xgrid.grid_line_color = None
p.y_range.start = 0

show(p)
