# -----------------------------------------------------------------------------
# Copyright (c) Anaconda, Inc., and Bokeh Contributors.
# All rights reserved.
#
# The full license is in the file LICENSE.txt, distributed with this software.
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# Boilerplate
# -----------------------------------------------------------------------------

import pytest ; pytest

# -----------------------------------------------------------------------------
# Imports
# -----------------------------------------------------------------------------

# Bokeh imports
from bokeh.layouts import gridplot
from bokeh.plotting import figure

# Module under test

# -----------------------------------------------------------------------------
# Setup
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# General API
# -----------------------------------------------------------------------------


def test_gridplot_typing_no_ncols() -> None:
    def p() -> figure:
        pp = figure()
        pp.scatter([1, 2, 3], [4, 5, 6])
        return pp

    p0, p1, p2, p3 = p(), p(), p(), p()

    with pytest.raises(TypeError):
        gridplot([p0, p1, p2, p3])  # type: ignore[list-item]

    with pytest.raises(ValueError):
        gridplot([[1], [p2], [p3]])


def test_gridplot_typing_using_ncols() -> None:
    def p() -> figure:
        pp = figure()
        pp.scatter([1, 2, 3], [4, 5, 6])
        return pp

    p0, p1, p2, p3 = p(), p(), p(), p()

    with pytest.raises(ValueError):
        gridplot([[p0, p1], [p2, p3]], ncols=2)

    with pytest.raises(ValueError):
        gridplot([1, p2, p3], ncols=2)


#-----------------------------------------------------------------------------
# Dev API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Private API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Code
#-----------------------------------------------------------------------------
