// langfuse
//
// ## Authentication  Authenticate with the API using [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication), get API keys in the project settings:  - username: Langfuse Public Key - password: Langfuse Secret Key  ## Exports  - OpenAPI spec: https://cloud.langfuse.com/generated/api/openapi.yml - Postman collection: https://cloud.langfuse.com/generated/postman/collection.json
//
// The version of the OpenAPI document:
//
// Generated by: https://openapi-generator.tech

use crate::models;
use serde::{Deserialize, Serialize};

/// Usage : (Deprecated. Use usageDetails and costDetails instead.) Standard interface for usage and
/// cost
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Usage {
    /// Number of input units (e.g. tokens)
    #[serde(
        rename = "input",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub input: Option<Option<i32>>,
    /// Number of output units (e.g. tokens)
    #[serde(
        rename = "output",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub output: Option<Option<i32>>,
    /// Defaults to input+output if not set
    #[serde(
        rename = "total",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub total: Option<Option<i32>>,
    #[serde(rename = "unit", skip_serializing_if = "Option::is_none")]
    pub unit: Option<models::ModelUsageUnit>,
    /// USD input cost
    #[serde(
        rename = "inputCost",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub input_cost: Option<Option<f64>>,
    /// USD output cost
    #[serde(
        rename = "outputCost",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub output_cost: Option<Option<f64>>,
    /// USD total cost, defaults to input+output
    #[serde(
        rename = "totalCost",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub total_cost: Option<Option<f64>>,
}

impl Usage {
    /// (Deprecated. Use usageDetails and costDetails instead.) Standard interface for usage and
    /// cost
    pub fn new() -> Usage {
        Usage {
            input: None,
            output: None,
            total: None,
            unit: None,
            input_cost: None,
            output_cost: None,
            total_cost: None,
        }
    }
}

impl From<swiftide_core::chat_completion::Usage> for Usage {
    fn from(value: swiftide_core::chat_completion::Usage) -> Self {
        Usage {
            input: Some(Some(value.prompt_tokens as i32)),
            output: Some(Some(value.completion_tokens as i32)),
            total: Some(Some(value.total_tokens as i32)),
            unit: Some(models::ModelUsageUnit::Tokens),
            input_cost: None,
            output_cost: None,
            total_cost: None,
        }
    }
}
