// langfuse
//
// ## Authentication  Authenticate with the API using [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication), get API keys in the project settings:  - username: Langfuse Public Key - password: Langfuse Secret Key  ## Exports  - OpenAPI spec: https://cloud.langfuse.com/generated/api/openapi.yml - Postman collection: https://cloud.langfuse.com/generated/postman/collection.json
//
// The version of the OpenAPI document:
//
// Generated by: https://openapi-generator.tech

use crate::models;
use chrono::Utc;
use serde::{Deserialize, Serialize};
use uuid::Uuid;

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum IngestionEvent {
    TraceCreate(Box<models::TraceCreate>),
    ScoreCreate(Box<models::ScoreCreate>),
    SpanCreate(Box<models::SpanCreate>),
    SpanUpdate(Box<models::SpanUpdate>),
    GenerationCreate(Box<models::GenerationCreate>),
    GenerationUpdate(Box<models::GenerationUpdate>),
    EventCreate(Box<models::EventCreate>),
    SdkLog(Box<models::SdkLog>),
    ObservationCreate(Box<models::ObservationCreate>),
    ObservationUpdate(Box<models::ObservationUpdate>),
}

impl Default for IngestionEvent {
    fn default() -> Self {
        Self::TraceCreate(Default::default())
    }
}

impl IngestionEvent {
    pub fn new_trace_create(body: models::TraceBody) -> Self {
        IngestionEvent::TraceCreate(Box::new(models::TraceCreate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of::Type::TraceCreate,
        )))
    }

    pub fn new_score_create(body: models::ScoreBody) -> Self {
        IngestionEvent::ScoreCreate(Box::new(models::ScoreCreate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_1::Type::ScoreCreate,
        )))
    }

    pub fn new_span_create(body: models::CreateSpanBody) -> Self {
        IngestionEvent::SpanCreate(Box::new(models::SpanCreate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_2::Type::SpanCreate,
        )))
    }

    pub fn new_span_update(body: models::UpdateSpanBody) -> Self {
        IngestionEvent::SpanUpdate(Box::new(models::SpanUpdate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_3::Type::SpanUpdate,
        )))
    }

    pub fn new_generation_create(body: models::CreateGenerationBody) -> Self {
        IngestionEvent::GenerationCreate(Box::new(models::GenerationCreate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_4::Type::GenerationCreate,
        )))
    }

    pub fn new_generation_update(body: models::UpdateGenerationBody) -> Self {
        IngestionEvent::GenerationUpdate(Box::new(models::GenerationUpdate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_5::Type::GenerationUpdate,
        )))
    }

    pub fn new_event_create(body: models::CreateEventBody) -> Self {
        IngestionEvent::EventCreate(Box::new(models::EventCreate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_6::Type::EventCreate,
        )))
    }

    pub fn new_sdk_log(body: models::SdkLogBody) -> Self {
        IngestionEvent::SdkLog(Box::new(models::SdkLog::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_7::Type::SdkLog,
        )))
    }

    pub fn new_observation_create(body: models::ObservationBody) -> Self {
        IngestionEvent::ObservationCreate(Box::new(models::ObservationCreate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_8::Type::ObservationCreate,
        )))
    }

    pub fn new_observation_update(body: models::ObservationBody) -> Self {
        IngestionEvent::ObservationUpdate(Box::new(models::ObservationUpdate::new(
            body,
            Uuid::new_v4().to_string(),
            Utc::now().to_rfc3339(),
            models::ingestion_event_one_of_9::Type::ObservationUpdate,
        )))
    }
}
