// langfuse
//
// ## Authentication  Authenticate with the API using [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication), get API keys in the project settings:  - username: Langfuse Public Key - password: Langfuse Secret Key  ## Exports  - OpenAPI spec: https://cloud.langfuse.com/generated/api/openapi.yml - Postman collection: https://cloud.langfuse.com/generated/postman/collection.json
//
// The version of the OpenAPI document:
//
// Generated by: https://openapi-generator.tech

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScoreBody {
    #[serde(
        rename = "id",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub id: Option<Option<String>>,
    #[serde(
        rename = "traceId",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub trace_id: Option<Option<String>>,
    #[serde(
        rename = "sessionId",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub session_id: Option<Option<String>>,
    #[serde(
        rename = "observationId",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub observation_id: Option<Option<String>>,
    #[serde(
        rename = "datasetRunId",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub dataset_run_id: Option<Option<String>>,
    #[serde(rename = "name")]
    pub name: String,
    #[serde(
        rename = "environment",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub environment: Option<Option<String>>,
    #[serde(rename = "value")]
    pub value: Box<models::CreateScoreValue>,
    #[serde(
        rename = "comment",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub comment: Option<Option<String>>,
    #[serde(
        rename = "metadata",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub metadata: Option<Option<serde_json::Value>>,
    #[serde(rename = "dataType", skip_serializing_if = "Option::is_none")]
    pub data_type: Option<models::ScoreDataType>,
    /// Reference a score config on a score. When set, the score name must equal the config name
    /// and scores must comply with the config's range and data type. For categorical scores, the
    /// value must map to a config category. Numeric scores might be constrained by the score
    /// config's max and min values
    #[serde(
        rename = "configId",
        default,
        with = "::serde_with::rust::double_option",
        skip_serializing_if = "Option::is_none"
    )]
    pub config_id: Option<Option<String>>,
}

impl ScoreBody {
    pub fn new(name: String, value: models::CreateScoreValue) -> ScoreBody {
        ScoreBody {
            id: None,
            trace_id: None,
            session_id: None,
            observation_id: None,
            dataset_run_id: None,
            name,
            environment: None,
            value: Box::new(value),
            comment: None,
            metadata: None,
            data_type: None,
            config_id: None,
        }
    }
}
