# Contribution Guidelines

The primary aim of the [Awesome Network Analysis list](https://github.com/briatte/awesome-network-analysis) is to spread awesome network analysis resources.

Please contribute to it by sending [pull requests](https://github.com/briatte/awesome-network-analysis/pulls) or by fixing its [issues](https://github.com/briatte/awesome-network-analysis/issues).

## Copyright Waiver

If you contribute to this list, please add your name to the copyright waiver at the end of the list, with an optional link to your personal homepage, GitHub profile, or social media profile (Facebook, LinkedIn, Twitter, whatever).

## Inclusion Criteria

The [Awesome Manifesto](https://github.com/sindresorhus/awesome/blob/master/awesome.md) states:

> __Only awesome is awesome__
> 
> Research if the stuff you're including is actually awesome. Put only stuff on the list you or another contributor can personally recommend and rather leave stuff out than include too much.  
>
> ...
> 
> __Comment on why something is awesome__  
>  
> Apart from suggesting a particular item on your list, you should also inform your readers why it's on the list and how they will benefit from it.

See the [list of rejected content](https://github.com/briatte/awesome-network-analysis/wiki/rejected-content) for counter-examples of non-awesome or off-topic stuff _not_ to submit.

## Publishing History

- Details on how the list has developed appear in the [release notes](https://github.com/briatte/awesome-network-analysis/releases).
- Details on how collaborators were recruited appear in the [publishing roadmap](https://github.com/briatte/awesome-network-analysis/wiki/publishing-roadmap).

## Style Guide

- __All resources__ are listed alphabetically.
- __All titles__ are Title Cased, Chicago-style.
- __Authors__ are required only for blog series, selected papers, books and courses.
- __Books__ should link to their official publisher's page, not a vendor's page.
- __Dates__ are mentioned for books and tutorials.
- __Default spelling__ is __U.S. English__.
- __Do not use__
  - __copyright or trademark symbols__.
  - __quotes__ around titles.
  - __monospace text__ for software names.
- __Italics__ are used only for books and journal names.
- __Journals__ require the name of the publisher.
  - Please include only journals with __~ 75% or more content__ about network analysis.
  - Please mention if the journal is __gated__ or not.
- __Language__ is required if the resource is not in English.
  - Additions in __all languages__ are welcome.
  - Consider __translating titles__ into English.
- __Review Articles__ require a journal and date indication.
- __Software__ should be at least free for noncommercial use (only [few exceptions](https://github.com/briatte/awesome-network-analysis/wiki/rejected-content#systematic-rejections) will be granted).
  - __R__: consider citing the stable __CRAN__ version when it exists.
  - __Python__: consider citing the __PyPi__ version when it exists.
