# Contributing Guidelines

Thank you for showing interest in contributing to this list! Before submitting new links, please review the following in order for your pull request to be approved.

## Pull Requests

- New links **need to be related to the latest GameMaker version in some reasonable way.** This includes compatible libraries, guides, blog posts, etc.
- Avoid GMS1-exclusive (or pre-2.3) content.
- Avoid asset packs for sprites and audio. Typically, most assets are GameMaker-agnostic and do not need to be on this list.
- For extensions or GameMaker projects, please link an official Itch.io or repository (Github/Gitlab/etc). (For example, avoid project dumps on Google Drive that have zero version control.)
- Make sure it isn't already on the list.
- [Optional] If you are releasing an library/extension, It's recommend to build an importable `.yymps` file and keep everything in one folder if possible.
- Provide a succinct description for each linked resource.
- Check the official [awesome pull request requirements](https://github.com/sindresorhus/awesome/blob/main/pull_request_template.md#requirements-for-your-awesome-list) to ensure your changes are consistent with their guidelines. You usually don't need to worry about this if you're just adding or removing a couple links.

1. Fork a new branch of the repo.

2. **Place your link(s) at the bottom of the respective category it belongs to.** (If you are unsure, place it in `Useful Extras`.)

3. Specify if it's a paid asset by including 💸 at the end of your description.

4. When adding a YouTube link outside of the YouTube category, include ![YouTube](https://github.com/bytecauldron/awesome-gamemaker/raw/main/icons/youtube.png) at the end of your description using this markdown:

   `![YouTube](https://github.com/bytecauldron/awesome-gamemaker/raw/main/icons/youtube.png)`

5. Include the following format:
   
   `- [Awesome Example](https://github.com/username/gamemaker_library) - A short description. 💸`

6. Submit the pull request to merge back to `main`.

## Creating Issues

Issues can be created for spelling/list errors, pruning dead links or abandoned projects, or specifying if an asset is now free or paid.
Authors can also ask for the removal of their content, if requested. Suggestions for new categories, links, and better descriptions are also encouraged.

## Additional Feedback

If you have a better way to organize the list information or other ideas, please share them by opening up a new issue.
