# Security Policy

## Supported Versions

The CAMEL AI project is currently at version 0.2.66. We are committed to providing security updates for this version.

| Version | Supported |
| ------- | -------- |
| 0.2.66  | <br>• Code Scanning<br>• Private Vulnerability Reporting<br>• Security Policy<br>• Dependabot Alerts<br>• Incident Response Plan |


## Reporting a Vulnerability

The CAMEL-AI team and community take all security vulnerabilities seriously. Thank you for your efforts to responsibly disclose your findings. We appreciate your help in keeping CAMEL AI secure.

To report a security vulnerability, please use the **GitHub Private Vulnerability Reporting** feature. This can be done by navigating to the "Security" tab of the CAMEL-AI repository and clicking on "Report a vulnerability".

When reporting a vulnerability, please include the following information:

*   **A clear description of the vulnerability**: Explain the nature of the vulnerability and its potential impact.
*   **Steps to reproduce**: Provide detailed steps that allow us to reproduce the vulnerability. Include any relevant code snippets, configurations, or specific scenarios.
*   **Affected versions**: Specify the versions of CAMEL-AI that are affected.
*   **Your contact information**: Provide a way for us to contact you if we need more information.

**What to Expect:**

1.  **Acknowledgement**: We will acknowledge receipt of your vulnerability report within 48-72 hours.
2.  **Assessment**: Our security team will investigate the reported vulnerability to assess its validity and severity.
3.  **Updates**: We will keep you informed of the progress of our investigation and the planned remediation.
4.  **Resolution**: Once the vulnerability is addressed, we will notify you. We aim to resolve critical vulnerabilities as quickly as possible.
5.  **Public Disclosure**: We may publicly disclose the vulnerability once it has been fixed, and we are happy to credit you for your discovery unless you prefer to remain anonymous.

Please **do not** report security vulnerabilities through public GitHub issues, discussions, or other public channels.

If you have questions or issues with the private reporting process, you can contact us through one of our official communication channels:

- **Discord:** [Join here](https://discord.camel-ai.org/)

Private GitHub reporting is always the preferred method for security vulnerabilities.
