<a id="camel.logger"></a>

<a id="camel.logger._configure_library_logging"></a>

## _configure_library_logging

```python
def _configure_library_logging():
```

<a id="camel.logger.set_log_file"></a>

## set_log_file

```python
def set_log_file(file_path):
```

Set a file handler for the CAMEL library logging.

**Parameters:**

- **file_path** (str): Path to the log file. If the directory doesn't exist, it will be created.

**Returns:**

  logging.FileHandler: The file handler that was added to the logger.

<a id="camel.logger.disable_logging"></a>

## disable_logging

```python
def disable_logging():
```

Disable all logging for the CAMEL library.


This function sets the log level to a value higher than CRITICAL,
effectively disabling all log messages, and adds a NullHandler to
suppress any potential warnings about no handlers being found.

<a id="camel.logger.enable_logging"></a>

## enable_logging

```python
def enable_logging():
```

Enable logging for the CAMEL library.


This function re-enables logging if it was previously disabled,
and configures the library logging using the default settings.
If the logging is already configured,
this function does not change its configuration.

<a id="camel.logger.set_log_level"></a>

## set_log_level

```python
def set_log_level(level):
```

Set the logging level for the CAMEL library.

**Parameters:**

- **level** (Union[str, int]): The logging level to set. This can be a string (e.g., 'INFO') or a logging level constant (e.g., logging.INFO, logging.DEBUG). See https://docs.python.org/3/library/logging.html#levels

**Raises:**

- **ValueError**: If the provided level is not a valid logging level.

<a id="camel.logger.get_logger"></a>

## get_logger

```python
def get_logger(name: str):
```

Get a logger with the specified name, prefixed with 'camel.'.

**Parameters:**

- **name** (str): The name to be appended to 'camel.' to create the logger.

**Returns:**

  logging.Logger: A logger instance with the name 'camel.\{name\}'.
