<a id="camel.societies.workforce.utils"></a>

<a id="camel.societies.workforce.utils.WorkerConf"></a>

## WorkerConf

```python
class WorkerConf(BaseModel):
```

The configuration of a worker.

<a id="camel.societies.workforce.utils.TaskResult"></a>

## TaskResult

```python
class TaskResult(BaseModel):
```

The result of a task.

<a id="camel.societies.workforce.utils.TaskAssignment"></a>

## TaskAssignment

```python
class TaskAssignment(BaseModel):
```

An individual task assignment within a batch.

<a id="camel.societies.workforce.utils.TaskAssignment._split_and_strip"></a>

### _split_and_strip

```python
def _split_and_strip(dep_str: str):
```

Utility to split a comma separated string and strip whitespace.

<a id="camel.societies.workforce.utils.TaskAssignment.validate_dependencies"></a>

### validate_dependencies

```python
def validate_dependencies(cls, v):
```

<a id="camel.societies.workforce.utils.TaskAssignResult"></a>

## TaskAssignResult

```python
class TaskAssignResult(BaseModel):
```

The result of task assignment for both single and batch assignments.

<a id="camel.societies.workforce.utils.RecoveryStrategy"></a>

## RecoveryStrategy

```python
class RecoveryStrategy(str, Enum):
```

Strategies for handling failed tasks.

<a id="camel.societies.workforce.utils.RecoveryStrategy.__str__"></a>

### __str__

```python
def __str__(self):
```

<a id="camel.societies.workforce.utils.RecoveryStrategy.__repr__"></a>

### __repr__

```python
def __repr__(self):
```

<a id="camel.societies.workforce.utils.FailureContext"></a>

## FailureContext

```python
class FailureContext(BaseModel):
```

Context information about a task failure.

<a id="camel.societies.workforce.utils.RecoveryDecision"></a>

## RecoveryDecision

```python
class RecoveryDecision(BaseModel):
```

Decision on how to recover from a task failure.

<a id="camel.societies.workforce.utils.check_if_running"></a>

## check_if_running

```python
def check_if_running(
    running: bool,
    max_retries: int = 3,
    retry_delay: float = 1.0,
    handle_exceptions: bool = False
):
```

Check if the workforce is (not) running, specified by the boolean
value. Provides fault tolerance through automatic retries and exception
handling.

**Parameters:**

- **running** (bool): Expected running state (True or False).
- **max_retries** (int, optional): Maximum number of retry attempts if the operation fails. Set to 0 to disable retries. (default: :obj:`3`)
- **retry_delay** (float, optional): Delay in seconds between retry attempts. (default: :obj:`1.0`)
- **handle_exceptions** (bool, optional): If True, catch and log exceptions instead of propagating them. (default: :obj:`False`)

**Raises:**

- **RuntimeError**: If the workforce is not in the expected status and
- **Exception**: Any exception raised by the decorated function if
