<a id="camel.toolkits.aci_toolkit"></a>

<a id="camel.toolkits.aci_toolkit.ACIToolkit"></a>

## ACIToolkit

```python
class ACIToolkit(BaseToolkit):
```

A toolkit for interacting with the ACI API.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.__init__"></a>

### __init__

```python
def __init__(
    self,
    api_key: Optional[str] = None,
    base_url: Optional[str] = None,
    linked_account_owner_id: Optional[str] = None,
    timeout: Optional[float] = None
):
```

Initialize the ACI toolkit.

**Parameters:**

- **api_key** (Optional[str]): The API key for authentication. (default: :obj:`None`)
- **base_url** (Optional[str]): The base URL for the ACI API. (default: :obj:`None`)
- **linked_account_owner_id** (Optional[str]): ID of the owner of the linked account, e.g., "johndoe" (default: :obj:`None`)
- **timeout** (Optional[float]): Request timeout. (default: :obj:`None`)

<a id="camel.toolkits.aci_toolkit.ACIToolkit.search_tool"></a>

### search_tool

```python
def search_tool(
    self,
    intent: Optional[str] = None,
    allowed_app_only: bool = True,
    include_functions: bool = False,
    categories: Optional[List[str]] = None,
    limit: Optional[int] = 10,
    offset: Optional[int] = 0
):
```

Search for apps based on intent.

**Parameters:**

- **intent** (Optional[str]): Search results will be sorted by relevance to this intent. (default: :obj:`None`)
- **allowed_app_only** (bool): If true, only return apps that are allowed by the agent/accessor, identified by the api key. (default: :obj:`True`)
- **include_functions** (bool): If true, include functions (name and description) in the search results. (default: :obj:`False`)
- **categories** (Optional[List[str]]): List of categories to filter the search results. Defaults to an empty list. (default: :obj:`None`)
- **limit** (Optional[int]): Maximum number of results to return. (default: :obj:`10`)
- **offset** (Optional[int]): Offset for pagination. (default: :obj:`0`)

**Returns:**

  Optional[List[AppBasic]]: List of matching apps if successful,
error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.list_configured_apps"></a>

### list_configured_apps

```python
def list_configured_apps(
    self,
    app_names: Optional[List[str]] = None,
    limit: Optional[int] = 10,
    offset: Optional[int] = 0
):
```

List all configured apps.

**Parameters:**

- **app_names** (Optional[List[str]]): List of app names to filter the results. (default: :obj:`None`)
- **limit** (Optional[int]): Maximum number of results to return. (default: :obj:`10`)
- **offset** (Optional[int]): Offset for pagination. (default: :obj:`0`) (default: 0)

**Returns:**

  Union[List[AppConfiguration], str]: List of configured apps if
successful, error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.configure_app"></a>

### configure_app

```python
def configure_app(self, app_name: str):
```

Configure an app with specified authentication type.

**Parameters:**

- **app_name** (str): Name of the app to configure.

**Returns:**

  Union[Dict, str]: Configuration result or error message.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.get_app_configuration"></a>

### get_app_configuration

```python
def get_app_configuration(self, app_name: str):
```

Get app configuration by app name.

**Parameters:**

- **app_name** (str): Name of the app to get configuration for.

**Returns:**

  Union[AppConfiguration, str]: App configuration if successful,
error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.delete_app"></a>

### delete_app

```python
def delete_app(self, app_name: str):
```

Delete an app configuration.

**Parameters:**

- **app_name** (str): Name of the app to delete.

**Returns:**

  Optional[str]: None if successful, error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.link_account"></a>

### link_account

```python
def link_account(self, app_name: str):
```

Link an account to a configured app.

**Parameters:**

- **app_name** (str): Name of the app to link the account to.

**Returns:**

  Union[LinkedAccount, str]: LinkedAccount object if successful,
error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.get_app_details"></a>

### get_app_details

```python
def get_app_details(self, app_name: str):
```

Get details of an app.

**Parameters:**

- **app_name** (str): Name of the app to get details for.

**Returns:**

  AppDetails: App details.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.get_linked_accounts"></a>

### get_linked_accounts

```python
def get_linked_accounts(self, app_name: str):
```

List all linked accounts for a specific app.

**Parameters:**

- **app_name** (str): Name of the app to get linked accounts for.

**Returns:**

  Union[List[LinkedAccount], str]: List of linked accounts if
successful, error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.enable_linked_account"></a>

### enable_linked_account

```python
def enable_linked_account(self, linked_account_id: str):
```

Enable a linked account.

**Parameters:**

- **linked_account_id** (str): ID of the linked account to enable.

**Returns:**

  Union[LinkedAccount, str]: Linked account if successful, error
message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.disable_linked_account"></a>

### disable_linked_account

```python
def disable_linked_account(self, linked_account_id: str):
```

Disable a linked account.

**Parameters:**

- **linked_account_id** (str): ID of the linked account to disable.

**Returns:**

  Union[LinkedAccount, str]: The updated linked account if
successful, error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.delete_linked_account"></a>

### delete_linked_account

```python
def delete_linked_account(self, linked_account_id: str):
```

Delete a linked account.

**Parameters:**

- **linked_account_id** (str): ID of the linked account to delete.

**Returns:**

  str: Success message if successful, error message otherwise.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.function_definition"></a>

### function_definition

```python
def function_definition(self, func_name: str):
```

Get the function definition for an app.

**Parameters:**

- **app_name** (str): Name of the app to get function definition for

**Returns:**

  Dict: Function definition dictionary.

<a id="camel.toolkits.aci_toolkit.ACIToolkit.search_function"></a>

### search_function

```python
def search_function(
    self,
    app_names: Optional[List[str]] = None,
    intent: Optional[str] = None,
    allowed_apps_only: bool = True,
    limit: Optional[int] = 10,
    offset: Optional[int] = 0
):
```

Search for functions based on intent.

**Parameters:**

- **app_names** (Optional[List[str]]): List of app names to filter the search results. (default: :obj:`None`)
- **intent** (Optional[str]): The search query/intent. (default: :obj:`None`)
- **allowed_apps_only** (bool): If true, only return functions from allowed apps. (default: :obj:`True`)
- **limit** (Optional[int]): Maximum number of results to return. (default: :obj:`10`)
- **offset** (Optional[int]): Offset for pagination. (default: :obj:`0`)

**Returns:**

  List[Dict]: List of matching functions

<a id="camel.toolkits.aci_toolkit.ACIToolkit.execute_function"></a>

### execute_function

```python
def execute_function(
    self,
    function_name: str,
    function_arguments: Dict,
    linked_account_owner_id: str,
    allowed_apps_only: bool = False
):
```

Execute a function call.

**Parameters:**

- **function_name** (str): Name of the function to execute.
- **function_arguments** (Dict): Arguments to pass to the function.
- **linked_account_owner_id** (str): To specify the end-user (account owner) on behalf of whom you want to execute functions You need to first link corresponding account with the same owner id in the ACI dashboard (https://platform.aci.dev).
- **allowed_apps_only** (bool): If true, only returns functions/apps that are allowed to be used by the agent/accessor, identified by the api key. (default: :obj:`False`)

**Returns:**

  Dict: Result of the function execution

<a id="camel.toolkits.aci_toolkit.ACIToolkit.get_tools"></a>

### get_tools

```python
def get_tools(self):
```

**Returns:**

  List[FunctionTool]: List of FunctionTool objects representing
available functions
