// Copyright 2025 The Casibase Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package storage

var FileCache = make(map[string]map[string]CachedFile)

type CachedFile struct {
	FileId string
	Object Object
}

func getCachedFileId(storeId string, key string) string {
	cachedFileMap, exists := FileCache[storeId]
	if !exists {
		return ""
	}
	cachedFile, exists := cachedFileMap[key]
	if !exists {
		return ""
	}
	return cachedFile.FileId
}

func addFileToCache(fileId string, storeId string, fileObject *Object) (string, error) {
	FileCache[storeId][fileObject.Key] = CachedFile{
		FileId: fileId,
		Object: *fileObject,
	}
	return fileObject.Url, nil
}

func removeFileFromCache(storeId string, key string) {
	if storeCache, exists := FileCache[storeId]; exists {
		delete(storeCache, key)
	}
}
